package com.artfess.workflow.runtime.model;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.builder.ToStringBuilder;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.artfess.base.entity.AutoFillModel;


 /**
 * 流程打印文件管理表
 * <pre> 
 * 描述：流程打印文件管理表 实体对象
 * 构建组：x7
 * 作者:zhangxw
 * 邮箱:zhangxw@jee-soft.cn
 * 日期:2020-05-23 19:58:35
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
 @TableName("BPM_PRINT_RECORD")
 @ApiModel(value = "BpmPrintRecord",description = "流程打印文件管理表") 
public class BpmPrintRecord extends AutoFillModel<BpmPrintRecord>{

	private static final long serialVersionUID = 1L;
	@XmlTransient
	@TableId("ID_")
	@ApiModelProperty(value="主键")
	protected String id; 
	
	@XmlAttribute(name = "procDefKey")
	@TableField("PROC_DEF_KEY_")
	@ApiModelProperty(value="流程定义KEY")
	protected String procDefKey; 
	
	@XmlAttribute(name = "procDefName")
	@TableField("PROC_DEF_NAME_")
	@ApiModelProperty(value="流程定义名称")
	protected String procDefName; 
	
	@XmlAttribute(name = "procDefId")
	@TableField("PROC_DEF_ID_")
	@ApiModelProperty(value="流程定义ID")
	protected String procDefId; 
	
	@XmlAttribute(name = "procInstId")
	@TableField("PROC_INST_ID_")
	@ApiModelProperty(value="流程实例ID")
	protected String procInstId; 
	
	@XmlAttribute(name = "nodeId")
	@TableField("NODE_ID_")
	@ApiModelProperty(value="流程节点ID")
	protected String nodeId; 
	
	@XmlAttribute(name = "formKey")
	@TableField("FORM_KEY_")
	@ApiModelProperty(value="表单key")
	protected String formKey; 
	
	@XmlAttribute(name = "templateId")
	@TableField("TEMPLATE_ID_")
	@ApiModelProperty(value="打印模板ID")
	protected String templateId; 
	
	@XmlAttribute(name = "templateName")
	@TableField("TEMPLATE_NAME_")
	@ApiModelProperty(value="打印模板名称")
	protected String templateName; 
	
	@XmlAttribute(name = "fileId")
	@TableField("FILE_ID_")
	@ApiModelProperty(value="打印文件id")
	protected String fileId; 
	
	@XmlAttribute(name = "lastVersion")
	@TableField("LAST_VERSION_")
	@ApiModelProperty(value="是否最后的版本（1：是，0：否）")
	protected int lastVersion; 
	
	
	public void setId(String id) {
		this.id = id;
	}
	
	/**
	 * 返回 主键
	 * @return
	 */
	public String getId() {
		return this.id;
	}
	public void setProcDefKey(String procDefKey) {
		this.procDefKey = procDefKey;
	}
	
	/**
	 * 返回 PROC_DEF_KEY_
	 * @return
	 */
	public String getProcDefKey() {
		return this.procDefKey;
	}
	public void setProcDefName(String procDefName) {
		this.procDefName = procDefName;
	}
	
	/**
	 * 返回 PROC_DEF_NAME_
	 * @return
	 */
	public String getProcDefName() {
		return this.procDefName;
	}
	public void setProcDefId(String procDefId) {
		this.procDefId = procDefId;
	}
	
	/**
	 * 返回 PROC_DEF_ID_
	 * @return
	 */
	public String getProcDefId() {
		return this.procDefId;
	}
	public void setProcInstId(String procInstId) {
		this.procInstId = procInstId;
	}
	
	/**
	 * 返回 PROC_INST_ID_
	 * @return
	 */
	public String getProcInstId() {
		return this.procInstId;
	}
	public void setNodeId(String nodeId) {
		this.nodeId = nodeId;
	}
	
	/**
	 * 返回 NODE_ID_
	 * @return
	 */
	public String getNodeId() {
		return this.nodeId;
	}
	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}
	
	/**
	 * 返回 表单key
	 * @return
	 */
	public String getFormKey() {
		return this.formKey;
	}
	public void setTemplateId(String templateId) {
		this.templateId = templateId;
	}
	
	/**
	 * 返回 打印模板ID
	 * @return
	 */
	public String getTemplateId() {
		return this.templateId;
	}
	public void setTemplateName(String templateName) {
		this.templateName = templateName;
	}
	
	/**
	 * 返回 打印模板名称
	 * @return
	 */
	public String getTemplateName() {
		return this.templateName;
	}
	public void setFileId(String fileId) {
		this.fileId = fileId;
	}
	
	/**
	 * 返回 打印文件id
	 * @return
	 */
	public String getFileId() {
		return this.fileId;
	}
	public void setLastVersion(int lastVersion) {
		this.lastVersion = lastVersion;
	}
	
	/**
	 * 返回 是否最后的版本（1：是，0：否）
	 * @return
	 */
	public int getLastVersion() {
		return this.lastVersion;
	}
	
	/**
	 * @see Object#toString()
	 */
	public String toString() {
		return new ToStringBuilder(this)
		.append("id", this.id) 
		.append("procDefKey", this.procDefKey) 
		.append("procDefName", this.procDefName) 
		.append("procDefId", this.procDefId) 
		.append("procInstId", this.procInstId) 
		.append("nodeId", this.nodeId) 
		.append("formKey", this.formKey) 
		.append("templateId", this.templateId) 
		.append("templateName", this.templateName) 
		.append("fileId", this.fileId) 
		.append("lastVersion", this.lastVersion) 
		.toString();
	}
}