package com.artfess.dataAccess.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 数据权限定义
 *
 * @author llj
 * @since 2021-04-01
 */
@ApiModel(value="DataAccessDefined对象", description="数据权限定义")
@TableName("PORTAL_SYS_DATA_ACCESS_DEFINED")
public class DataAccessDefined extends AutoFillModel<DataAccessDefined> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "接口ID")
    @TableField("INTERFACE_ID_")
    private String interfaceId;


    @ApiModelProperty(value = "接口名")
    @TableField("INTERFACE_NAME_")
    private String interfaceName;

    @ApiModelProperty(value = "（1：本人  2：本人及直属下级 3：本组织数据 4：本组织及以下组织数据 5 指定组织 6 指定用户 7：所有 ）")
    @TableField("ACCESS_RANGE_TYPE_")
    private Integer accessRangeType;
    //a授权范围的名称
    @TableField(exist=false)
    private String rangeNameList;
    //受控类型
    @TableField(exist=false)
    private String type;

    @ApiModelProperty(value = "授权范围ID")
    @TableField("ACCESS_RANGE_ID")
    private String accessRangeId;

    @TableField("MEMO_")
    private String memo;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getInterfaceId() {
        return interfaceId;
    }

    public void setInterfaceId(String interfaceId) {
        this.interfaceId = interfaceId;
    }
    public String getInterfaceName() {
        return interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }
    public Integer getAccessRangeType() {
        return accessRangeType;
    }

    public void setAccessRangeType(Integer accessRangeType) {
        this.accessRangeType = accessRangeType;
    }
    public String getAccessRangeId() {
        return accessRangeId;
    }

    public void setAccessRangeId(String accessRangeId) {
        this.accessRangeId = accessRangeId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getRangeNameList() {
        return rangeNameList;
    }

    public void setRangeNameList(String rangeNameList) {
        this.rangeNameList = rangeNameList;
    }
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return "DataAccessDefined{" +
            "id=" + id +
            ", interfaceId=" + interfaceId +
            ", interfaceName=" + interfaceName +
            ", accessRangeType=" + accessRangeType +
            ", accessRangeId=" + accessRangeId +
            ", memo=" + memo +
        "}";
    }
}
