package com.artfess.uc.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

@ApiModel(value = "MatrixParam",description = "矩阵参数")
public class MatrixParam implements Serializable {
	private static final long serialVersionUID = -8990830427180487863L;
	
	@ApiModelProperty(value="账号",required=true)
	protected String account; 
	
	@ApiModelProperty(value="矩阵code",required=true)
	protected String matrixCode; 
	
	@ApiModelProperty(value="账号所在角色列code，参数规则为 ['ddd','eee']；若不传入则查找所有角色，其中一个角色满足即可",required=false)
	protected List<String> roleCodes; 
	
	@ApiModelProperty(value="精确条件列查找：参数规则为 {'aaa':'123','bbb':'123456789'} ,可不传入",required=false)
	protected Map<String,String> conds; 
	
	@ApiModelProperty(value="指定返回条件列字段code，参数规则为 ['aaa','bbb'],不传入则返回所有条件列数据",required=false)
	protected List<String> backConds;

	public String getAccount() {
		return account;
	}

	public void setAccount(String account) {
		this.account = account;
	}

	public String getMatrixCode() {
		return matrixCode;
	}

	public void setMatrixCode(String matrixCode) {
		this.matrixCode = matrixCode;
	}


	public List<String> getRoleCodes() {
		return roleCodes;
	}

	public void setRoleCodes(List<String> roleCodes) {
		this.roleCodes = roleCodes;
	}

	public Map<String, String> getConds() {
		return conds;
	}

	public void setConds(Map<String, String> conds) {
		this.conds = conds;
	}

	public List<String> getBackConds() {
		return backConds;
	}

	public void setBackConds(List<String> backConds) {
		this.backConds = backConds;
	} 
	
}
