package com.artfess.uc.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.uc.model.MatrixColDef;

import java.util.List;

/**
 * 
 * <pre> 
 * 描述：矩阵列定义 处理接口
 * 构建组：x7
 * 作者:pangq
 * 邮箱:pangq@jee-soft.cn
 * 日期:2020-06-05 14:02:42
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
public interface MatrixColDefManager extends BaseManager<MatrixColDef>{

	/**
	 * 获取未删除的条件列  即：isDele = 0
	 * @param matrixId
	 * @return
	 */
	List<MatrixColDef> getCondList(String matrixId);

	/**
	 * 获取未删除的角色列  即：isDele = 0
	 */
	List<MatrixColDef> getRoleList(String matrixId);

	/**
	 * 获取未删除的列定义list 即：isDele = 0
	 * @param matrixId
	 * @param colType
	 * @return
	 */
	List<MatrixColDef> getColList(String matrixId, Integer colType);

	/**
	 * 获取全部的列定义，包括已删除的
	 * @param matrixId
	 * @param colType
	 * @return
	 */
	List<MatrixColDef> getColAllList(String matrixId, Integer colType);
	
	/**
	 * 
	 * @param matrixId 矩阵id
	 * @param matrixColDef 
	 * @param colType 列类型： 条件类型 角色类型
	 * @param isCodeExist code是否已存在
	 * @return 返回是否创建了新的字列，如果创建了新的列则把矩阵状态改为待发布
	 */
	boolean saveCol(String matrixId, MatrixColDef matrixColDef,Integer colType,boolean isCodeExist);

	void updateStatus(List<String> ids, Integer status);

	
}
