package com.artfess.security.util;

/**
 * @Author: wh
 * @Description: 返回码定义
 * 规定:
 * #1表示成功
 * #1001～1999 区间表示参数错误
 * #2001～2999 区间表示用户错误
 * #3001～3999 区间表示接口异常
 * @Date Create in 2019/7/22 19:28
 */
public enum ResultCode {
    /* 成功 */
    SUCCESS(200, "成功"),

    THROWS_OUT(666, "抛出流程审批人和抄送人"),

    /* 默认失败 */
    COMMON_FAIL(500, "后台服务错误"),

    /* 参数错误：1000～1999 */
    PARAM_NOT_VALID(1001, "参数无效"),
    PARAM_IS_BLANK(1002, "参数为空"),
    PARAM_TYPE_ERROR(1003, "参数类型错误"),
    PARAM_NOT_COMPLETE(1004, "参数缺失"),
    PARAM_NOT_TOKEN(1005, "参数token缺失"),
    PARAM_ERROR_TOKEN(1006, "非法的token"),
    PARAM_ERROR_TOKEN_DISABLE(401, "Token失效，请重新登录"),
    PARAM_ERROR_KEY(406, "密钥Key错误！"),

    /* 用户错误 */
    USER_NOT_LOGIN(2001, "用户未登录"),
    USER_ACCOUNT_EXPIRED(2002, "账号已过期"),
    USER_CREDENTIALS_ERROR(2003, "密码错误"),
    USER_CREDENTIALS_EXPIRED(2004, "密码过期"),
    USER_ACCOUNT_DISABLE(2005, "账号不可用,请联系管理员"),
    USER_ACCOUNT_LOCKED(2006, "账号被锁定,请联系管理员"),
    USER_ACCOUNT_NOT_EXIST(2007, "账号不存在，请确认账号信息"),
    USER_ACCOUNT_ALREADY_EXIST(2008, "账号已存在"),
    USER_ACCOUNT_USE_BY_OTHERS(2009, "账号下线"),
    USER_ACCOUNT_USE_BY_OTHERS_EQU(2010, "Token失效，请检查账号是否在其他设备登录!"),
    USER_COMPANY_NOT_EXIST(2011, "企业不存在，请确认信息"),
    /* 业务错误 */
    NO_PERMISSION(3001, "没有权限"),

    NO_DECRYPT_ERROR(4001, "授权解析出错，请联系管理员"),
    NO_DECRYPT_DATE_LONG(4002, "授权到期，请联系管理员"),
    NO_DECRYPT_SYSTEM(4003, "授权单位和认证单位不匹配，请联系管理员"),
    NO_DECRYPT_WILL_DATE_LONG(4004, "授权还有{day}天到期，请联系管理员"),
    NO_DECRYPT_DATE_ERROR(4005, "系统时间异常，请联系管理员");

    private Integer code;
    private String message;

    ResultCode(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * 根据code获取message
     *
     * @param code
     * @return
     */
    public static String getMessageByCode(Integer code) {
        for (ResultCode ele : values()) {
            if (ele.getCode().equals(code)) {
                return ele.getMessage();
            }
        }
        return null;
    }
}