package com.artfess.bpm.plugin.execution.globalRestful.plugin;

import java.util.List;

import javax.annotation.Resource;

import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.api.model.process.def.Restful;
import com.artfess.bpm.api.plugin.core.def.BpmExecutionPluginDef;
import com.artfess.bpm.api.plugin.core.session.BpmExecutionPluginSession;
import com.artfess.bpm.api.service.RestfulService;
import com.artfess.bpm.engine.identity.DefaultBpmIdentityService;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.plugin.core.runtime.AbstractBpmExecutionPlugin;
import com.artfess.bpm.plugin.execution.globalRestful.def.GlobalRestfulInvokePluginDef;
import com.artfess.uc.api.service.IUserService;

/**
 * restful接口调用插件
 * @author heyifan
 *
 */
public class GlobalRestfulInvokePlugin extends AbstractBpmExecutionPlugin{
	
	@Resource
	BpmProcessInstanceManager bpmProcessInstanceManager;
	@Resource
	BpmDefinitionManager bpmDefinitionManager;
	@Resource
	IUserService userServiceImpl;
	@Resource
	DefaultBpmIdentityService bpmIdentityService;

	@Resource
	RestfulService restfulService;
	
	@Override
	public Void execute(BpmExecutionPluginSession pluginSession,
			BpmExecutionPluginDef pluginDef) {
		GlobalRestfulInvokePluginDef restfulPluginDef = (GlobalRestfulInvokePluginDef) pluginDef;
		List<Restful> restfuls = restfulPluginDef.getRestfulList();
		return BeanUtils.isNotEmpty(restfuls)?restfulService.executionPluginExecute(pluginSession, pluginDef,restfuls):null;
	}
	
}