package com.artfess.portal.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@TableName("PORTAL_SYS_COMMON_BASIC")
@ApiModel(value="SysCommonBasic对象", description="系统基本设置")
public class CommonBasic extends BaseModel<CommonBasic>  {

    @ApiModelProperty(name="id", notes="主键")
    @TableId("id")
    protected String id;

    @ApiModelProperty(value = "系统名称")
    @TableField("SYS_NAME")
    private String sysName;

    @ApiModelProperty(value = "系统版本")
    @TableField("SYS_VERSION")
    private String sysVersion;

    @ApiModelProperty(value = "公司名称")
    @TableField("SYS_COMPANY_NAME")
    private String sysCompanyName;

    @ApiModelProperty(value = "公司联系人")
    @TableField("SYS_COMPANY_LEGAL")
    private String sysCompanyLegal;

    @ApiModelProperty(value = "公司电话")
    @TableField("SYS_COMPANY_PHONE")
    private String sysCompanyPhone;

    @ApiModelProperty(value = "系统描述")
    @TableField(value = "SYS_MEMO")
    private String sysMemo;

    @ApiModelProperty(value = "到期时间")
    private transient String expireDate;
}
