package com.artfess.form.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.form.model.ComponentValidEntity;
import com.artfess.form.model.OperationButtonEntity;
import com.artfess.form.persistence.manager.ComponentValidManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @program: cqgs
 * @Date: 2020/9/26 17:21
 * @Author: ZQF
 * @Description: 建模引擎-元件管理-数据有效性校验配置
 */
@Slf4j
@RequestMapping("/components/componentValid")
@RestController
@Api(tags="数据有效性校验配置")
@ApiGroup(group = {ApiGroupConsts.GROUP_APPLICATION})
public class ComponentValidController extends BaseController<ComponentValidManager, ComponentValidEntity> {

    @Resource
    ComponentValidManager componentValidService;

    @ApiOperation("新增数据有效性校验配置信息")
    @PostMapping("/insertComponentValid")
    @RequestMapping(value = "insertComponentValid", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    public ComponentValidEntity insertComponentValid(@RequestBody ComponentValidEntity componentValidEntity){
        if(componentValidEntity.getSn()==null){
            componentValidEntity.setSn(this.componentValidService.getNextSequence(null));
        }
        this.componentValidService.insertComponentValid(componentValidEntity);
        return componentValidEntity;

    }

    @ApiOperation("修改数据有效性校验配置信息")
    @PostMapping("/updateComponentValid")
    @RequestMapping(value = "updateComponentValid", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    public ComponentValidEntity updateComponentValid(@RequestBody ComponentValidEntity componentValidEntity){

            this.componentValidService.updateComponentValid(componentValidEntity);
            return componentValidEntity;

    }

    @ApiOperation("根据ID查询数据有效性校验配置信息")
    @RequestMapping(value = "loadComponentValid", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    public ComponentValidEntity loadComponentValid(@ApiParam("数据有效性校验配置ID") @RequestParam String id){

            return this.componentValidService.loadComponentValid(id);


    }

    @ApiOperation("根据ID批量删除数据有效性校验配置信息")
    @RequestMapping(value = "deleteComponentValid", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    public CommonResult<String> deleteComponentValid(@ApiParam("数据有效性校验配置ID集合，用逗号隔开") @RequestParam String ids){

        componentValidService.deleteComponentValid(ids);
        return new CommonResult<String>(true,"成功");
    }


    @RequestMapping(value = "listJson", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "数据有效性校验列表(分页条件查询)数据", httpMethod = "POST", notes = "数据有效性校验列表(分页条件查询)数据")
    public @ResponseBody
    PageList<ComponentValidEntity> listJson(@ApiParam(name = "queryFilter", value = "通用查询对象") @RequestBody QueryFilter<ComponentValidEntity> queryFilter) throws Exception {
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("ID_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return componentValidService.query(queryFilter);
    }




}
