package com.artfess.assembly;

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceAutoConfigure;
import com.artfess.base.annotation.IgnoreOnAssembly;

import com.mzt.logapi.starter.annotation.EnableLogRecord;
import lombok.extern.slf4j.Slf4j;
import net.hasor.spring.boot.EnableHasor;
import net.hasor.spring.boot.EnableHasorWeb;
import org.apache.catalina.Context;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.context.request.RequestContextListener;

import javax.annotation.PostConstruct;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.TimeZone;

@EnableHasor()      // 在Spring 中启用 Hasor
@EnableHasorWeb()   // 将 hasor-web 配置到 Spring 环境中，Dataway 的 UI 是通过 hasor-web 提供服务。
@EnableLogRecord(tenant = "com.artfess.assembly")
@SpringBootApplication(exclude = {DruidDataSourceAutoConfigure.class})
@Configuration
@EnableAsync
@MapperScan(basePackages = {"com.artfess.**.dao"})
@ComponentScan(basePackages = {"com.artfess.*", "org.jeecg.modules.jmreport","org.activiti.engine.*"},
        excludeFilters = {@ComponentScan.Filter(type = FilterType.ANNOTATION, value = {IgnoreOnAssembly.class})})
//@EnableMongoRepositories(repositoryBaseClass = MongoDbRepositoryImpl.class)
@Slf4j
public class Application {

    @PostConstruct
    void started() {
        //设置时区，处理linux设置的时区不一致的情况
        TimeZone.setDefault(TimeZone.getTimeZone("Asia/Shanghai"));
    }

    public static void main(String[] args) throws UnknownHostException {

        ConfigurableApplicationContext configurableApplicationContext = SpringApplication.run(Application.class, args);
        // 启动后初始化国际化资源到缓存中
//		I18nUtil.initMessage();
        //解决WebSocket不能注入的问题
        //ChatServer.setApplicationContext(configurableApplicationContext);
        Environment env = configurableApplicationContext.getEnvironment();
        String ip = InetAddress.getLocalHost().getHostAddress();
        String port = env.getProperty("server.port");
        String path = env.getProperty("server.servlet.context-path");
        path = path==null?"":path;
        log.info("\n----------------------------------------------------------\n\t" +
                "Application is running success! Access URLs:\n\t" +
                "Local: \t\thttp://localhost:" + port + path + "/\n\t" +
                "External: \thttp://" + ip + ":" + port + path + "/\n\t" +
                "Swagger-UI: \t\thttp://" + ip + ":" + port + path + "/doc.html\n\t" +
                "dataWay: \t\thttp://" + ip + ":" + port + path + "/interface-ui/\n" +
                "----------------------------------------------------------");

    }

    /**
     * tomcat-embed-jasper引用后提示jar找不到的问题
     */
    @Bean
    public TomcatServletWebServerFactory tomcatFactory() {
        return new TomcatServletWebServerFactory() {
            @Override
            protected void postProcessContext(Context context) {
                ((StandardJarScanner) context.getJarScanner()).setScanManifest(false);
            }
        };
    }

    /**
     * 监听器：监听HTTP请求事件
     * 解决RequestContextHolder.getRequestAttributes()空指针问题
     * @return
     */
//    @Bean
//    public RequestContextListener requestContextListener(){
//        return new RequestContextListener();
//    }
}
