package com.artfess.application.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.application.persistence.manager.ElaticsearchLogManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @program: edp
 * @Date: 2021/3/16 9:21
 * @Author: llj
 * @Description: Elasticsearch日志查询
 */
@RestController
@RequestMapping("/logs/ElasticsearchLog/v1/")
@Api(tags = "ES业务日志")
@ApiGroup(group = {ApiGroupConsts.GROUP_APPLICATION})
public class ElasticsearchLogController {
    @Resource
    private ElaticsearchLogManager elaticsearchLogManager;
//    /**
//     * es分页查询日志信息
//     * @return
//     */
//    @PostMapping(value="slicedElasticsearchLog", produces={"application/json; charset=utf-8" })
//    @ApiOperation("es分页查询日志信息")
//    public Map<String, Object> slicedElasticsearchLog(@RequestParam(name = "pageNum",required = false,defaultValue = "0") Integer pageNum,
//                                                  @RequestParam(name = "pageSize",required = false,defaultValue = "10") Integer pageSize) throws IOException {
//        Map<String, Object> data = elaticsearchLogManager.queryDataByQueryBuilder(pageNum, pageSize);
//        return data ;
//    }

    /**
     * es通过ID查询日志信息
     *
     * @return
     */
    @ApiOperation("es通过ID查询日志信息")
    @PostMapping("/selectErrorElasticsearchLog")
    public List<Map<String, Object>> selectErrorElasticsearchLog(@RequestParam(name = "id") String id) throws IOException {
        List<Map<String, Object>> maps = this.elaticsearchLogManager.queryApplicationLogById(id);
        return maps;
    }

    /**
     * es分页查询业务日志信息
     *
     * @return
     */
    @ApiOperation("es分页查询业务日志信息")
    @PostMapping("/selectBusinessElasticsearchLog")
    public Map<String, Object> selectBusinessElasticsearchLog(
            @ApiParam(name = "logType", value = "日志类型，不传查询全部日志，异常日志、操作日志两种类型", required = false) @RequestParam(name = "logType", required = false, defaultValue = "") String logType,
            @ApiParam(name = "user", value = "人员登录名", required = false) @RequestParam(name = "user", required = false, defaultValue = "") String user,
            @ApiParam(name = "startDate", value = "开始时间", required = false) @RequestParam(name = "startDate", required = false) String startDate,
            @ApiParam(name = "endDate", value = "结束时间", required = false) @RequestParam(name = "endDate", required = false) String endDate,
            @ApiParam(name = "pageNum", value = "起始页", required = false) @RequestParam(name = "pageNum", required = false, defaultValue = "0") Integer pageNum,
            @ApiParam(name = "pageSize", value = "页数", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "20") Integer pageSize) throws IOException {
        Map<String, Object> data = this.elaticsearchLogManager.queryBusinessByQueryBuilder(logType, user, startDate, endDate, pageNum, pageSize);

        return data;
    }

    /**
     * es分页查询业务日志信息
     *
     * @return
     */
    @ApiOperation("es分页查询错误日志信息")
    @PostMapping("/queryErrorByQueryBuilder")
    public Map<String, Object> queryErrorByQueryBuilder(
            @ApiParam(name = "user", value = "错误级别", required = false) @RequestParam(name = "user", required = false, defaultValue = "") String user,
            @ApiParam(name = "startDate", value = "开始时间", required = false) @RequestParam(name = "startDate", required = false) String startDate,
            @ApiParam(name = "endDate", value = "结束时间", required = false) @RequestParam(name = "endDate", required = false) String endDate,
            @ApiParam(name = "pageNum", value = "起始页", required = false) @RequestParam(name = "pageNum", required = false, defaultValue = "0") Integer pageNum,
            @ApiParam(name = "pageSize", value = "页数", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "20") Integer pageSize) throws IOException {
        Map<String, Object> data = this.elaticsearchLogManager.queryErrorByQueryBuilder(user, startDate, endDate, pageNum, pageSize);

        return data;
    }
}
