package com.artfess.yhxt.statistics.manager;

import com.artfess.yhxt.statistics.vo.*;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * @author zhx
 * @create 2022/1/6
 */
public interface StatisticalStatementManager {
    /**
     * 道路病害
     *
     * @return
     */
    Map<String, Object> countDisease(Map<String, Object> map);

    /**
     * 日常养护
     * @return
     */
    Map<String, Object> countMaintenance(Map<String, Object> map);

    /**
     * 日巡检
     * @param map
     * @return
     */
    Map<String, Object> countSiteDaily(Map<String, Object> map);

    /**
     * 夜巡检
     * @param map
     * @return
     */
    Map<String, Object> countSiteNight(Map<String, Object> map);

    /**
     * 桥梁巡检统计
     * @return
     */
    Map<String, Object> countBridgeCheck(Map<String, Object> map);

    /**
     * 桥梁结构统计
     * @param map
     * @return
     */
    Map<String, Object> countReportBridge(Map<String, Object> map);

    /**
     * 桥梁结构导出
     * @param response
     * @param map
     * @return
     */
    HSSFWorkbook exportBridge(HttpServletResponse response, Map<String, Object> map);

    /**
     * 管养信息统计
     * @param map
     */
    List<MaintainMessageVo> maintainMessage(Map<String, Object> map);

    /**
     * 隧道经常检查
     * @param map
     * @return
     */
    Map<String, Object> countTunnelCheck(Map<String, Object> map);

    /**
     * 边坡经常检查
     * @param map
     * @return
     */
    Map<String, Object> countSideSlopCheck(Map<String, Object> map);

    Map<String, Object> countCulvertCheck(Map<String, Object> map);

    /**
     * MQI检查统计
     * @param map
     */
    List<MqiDataVo> countMqiReport(Map<String, Object> map);

    /**
     * 结构物检查情况
     * @param map
     */
    List<CountStructureVo> countStructure(Map<String, Object> map);

    Map<String, Object> countMaintenanceNew(Map<String, Object> map);

    List<OrgMessageVo> getMessageCountVo();


}
