package com.artfess.yhxt.basedata.vo;

import com.artfess.yhxt.basedata.model.BridgeInformation;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.Date;

/**
 * @author zhx
 * @create 2021/8/9
 */
@ApiModel(value="桥梁检查 VO对象")
@Data
public class BridgeRegularVo extends BridgeInformation {
    @ApiModelProperty(value = "检查日期")
    @TableField("CHECK_DATE_")
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private Date checkDate;


    @ApiModelProperty(value = "下次检查日期")
    @TableField("CHECK_NEW_DAY_")
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private Date checkNewDay;


    @ApiModelProperty(value = "总体状况评定等级值")
    @TableField(exist = false)
    private String overallRatingValue;

    @ApiModelProperty(value = "桥梁定期预警时间")
    @TableField(exist = false)
    private String value;

    @ApiModelProperty(value = "下次检查距离天数")
    @TableField(exist = false)
    private Integer checkDays;

    @ApiModelProperty(value = "上一次检查距离天数")
    @TableField(exist = false)
    private Integer alreadyCheckDays;

    @ApiModelProperty(value = "上次大中修日期")
    @TableField(exist = false)
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private LocalDate lastRepairDate;

    @ApiModelProperty(value = "是否临期 0:未临期 1:临期")
    @TableField(exist = false)
    private Integer temporary;
}
