package com.artfess.yhxt.basedata.controller;


import com.artfess.yhxt.basedata.manager.BizEngineeringDrawingManager;
import com.artfess.yhxt.basedata.model.BizEngineeringDrawing;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.yhxt.basedata.model.BridgeInformation;
import com.artfess.yhxt.basedata.vo.BizEngineeringDrawingVo;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import org.springframework.web.multipart.MultipartFile;

import java.util.Arrays;
import java.util.List;

/**
 * 工程图纸表 前端控制器
 *
 * @author wangping
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-08-02
 */
@RestController
@RequestMapping("/bizEngineeringDrawing/v1/")
@Api(tags = "工程图纸管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizEngineeringDrawingController extends BaseController<BizEngineeringDrawingManager, BizEngineeringDrawing> {


    /**
     * 工程图纸管理列表(分页条件查询)数据
     *
     * @param queryFilter
     * @return
     * @throws Exception PageJson
     * @throws
     */
    @PostMapping("/list")
    @ApiOperation(value = "工程图纸管理数据列表", httpMethod = "POST", notes = "获取工程图纸管理列表")
    public PageList<BizEngineeringDrawing> list(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter<BizEngineeringDrawing> queryFilter) throws Exception {
        return baseService.query(queryFilter);
    }

    /**
     * 工程图纸管理明细页面
     *
     * @param id
     * @return
     * @throws Exception ModelAndView
     */
    @GetMapping(value = "/get/{id}")
    @ApiOperation(value = "工程图纸管理数据详情", httpMethod = "GET", notes = "工程图纸管理数据详情")
    public BizEngineeringDrawing get(@ApiParam(name = "id", value = "业务对象主键", required = true) @PathVariable String id) throws Exception {
        return baseService.get(id);
    }
    @GetMapping(value = "/getVo/{id}")
    @ApiOperation(value = "工程图纸管理、图纸数据详情", httpMethod = "GET", notes = "工程图纸管理数据详情")
    public BizEngineeringDrawingVo getVo(@ApiParam(name = "id", value = "业务对象主键", required = true) @PathVariable String id) throws Exception {
        return baseService.getVo(id);
    }

    /**
     * 新增工程图纸管理
     *
     * @param bizEngineeringDrawing
     * @return
     * @throws Exception
     * @throws
     */
    @PostMapping(value = "/save")
    @ApiOperation(value = "新增,更新工程图纸管理数据", httpMethod = "POST", notes = "新增,更新工程图纸管理数据")
    public CommonResult<BizEngineeringDrawing> save(@ApiParam(name = "BizEngineeringDrawing", value = "工程图纸管理业务对象", required = true) @RequestBody BizEngineeringDrawing bizEngineeringDrawing) throws Exception {
        String msg = "添加工程图纸管理成功";
        if (StringUtil.isEmpty(String.valueOf(bizEngineeringDrawing.getId()))) {
            bizEngineeringDrawing.setIsDele("0");
            baseService.create(bizEngineeringDrawing);
        } else {
            baseService.update(bizEngineeringDrawing);
            msg = "更新工程图纸管理成功";
        }
        return new CommonResult<BizEngineeringDrawing>(true, msg, bizEngineeringDrawing);
    }


    /**
     * 新增工程图纸管理
     *
     * @param bizEngineeringDrawingVo
     * @return
     * @throws Exception
     * @throws
     */
    @PostMapping(value = "/saveVo")
    @ApiOperation(value = "新增,更新工程图纸管理、附件数据", httpMethod = "POST", notes = "新增,更新工程图纸管理数据")
    public CommonResult<BizEngineeringDrawingVo> saveVo(@ApiParam(name = "bizEngineeringDrawingVo", value = "工程图纸", required = true) @RequestBody BizEngineeringDrawingVo bizEngineeringDrawingVo) throws Exception {
        String msg = "添加工程图纸管理成功";
        BizEngineeringDrawing bizEngineeringDrawing = bizEngineeringDrawingVo.getBizEngineeringDrawing();
        if (StringUtil.isEmpty(String.valueOf(bizEngineeringDrawing.getId()))) {
            bizEngineeringDrawing.setIsDele("0");
            baseService.saveVo(bizEngineeringDrawingVo);
        } else {
            baseService.updateVo(bizEngineeringDrawingVo);
            msg = "更新工程图纸管理成功";
        }
        return new CommonResult<BizEngineeringDrawingVo>(true, msg, bizEngineeringDrawingVo);
    }

    /**
     * 删除工程图纸管理记录
     *
     * @param id
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/remove/{id}")
    @ApiOperation(value = "删除工程图纸管理记录", httpMethod = "DELETE", notes = "删除工程图纸管理记录")
    public CommonResult<String> remove(@ApiParam(name = "id", value = "业务主键", required = true) @PathVariable String id) throws Exception {
        baseService.remove(id);
        return new CommonResult<String>(true, "删除成功");
    }

    /**
     * 批量删除工程图纸管理记录
     *
     * @param ids
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除工程图纸管理记录", httpMethod = "DELETE", notes = "批量删除工程图纸管理记录")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "多个主键之间用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true, "删除成功");
    }

    @RequestMapping(value = "/getList", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "不分页查询工程图纸明细信息", httpMethod = "POST")
    public PageList<BizEngineeringDrawing> getList(@ApiParam(name = "queryFilter", value = "不分页查询信息") @RequestBody QueryFilter<BizEngineeringDrawing> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE);
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);
        PageList<BizEngineeringDrawing> bizEngineeringDrawing = baseService.queryBizEngineeringDrawing(queryFilter);
        return bizEngineeringDrawing;
    }

    @RequestMapping(value = "/getJson", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "分页查询工程图纸明细信息", httpMethod = "POST")
    public PageList<BizEngineeringDrawing> getJson(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizEngineeringDrawing> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageList<BizEngineeringDrawing> pageList = baseService.queryBizEngineeringDrawing(queryFilter);
        return pageList;
    }

    @RequestMapping(value = "updateBatch", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "逻辑删除", httpMethod = "POST", notes = "逻辑删除")
    public CommonResult<String> updateBatchBizEngineeringDrawing(@ApiParam(name = "id", value = "工程图纸ID", required = true) @RequestParam(value = "id", required = true) String id) throws Exception {

        if (StringUtils.isNotBlank(id))
            baseService.updateBizEngineeringDrawing(id);
        return new CommonResult<>(true, "删除成功");
    }

    @RequestMapping(value = "updateEngineeringDrawing", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量逻辑删除", httpMethod = "DELETE", notes = "批量逻辑删除")
    public CommonResult<String> updateEngineeringDrawing(
            @ApiParam(name = "ids", value = "工程图纸ID集合以，隔开", required = true)
            @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BizEngineeringDrawing> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("is_dele_", "1");
            baseService.update(null, updateWrapper);

        }

        return new CommonResult<>(true, "批量删除成功");
    }

    /**
     * 地图工具
     *
     * @param
     * @return
     * @throws Exception
     * @throws
     */
    @PostMapping(value = "/maptools")
    @ApiOperation(value = "地图工具修改接口", httpMethod = "POST", notes = "地图工具修改接口")
    public CommonResult<String> mapTools(@ApiParam(name = "x", value = "横坐标", required = true) @RequestParam String x,
                                         @ApiParam(name = "y", value = "纵坐标", required = true) @RequestParam String y,
                                         @ApiParam(name = "type", value = "类型 1桥梁 2隧道 3 边坡 4涵洞", required = true) @RequestParam Integer type,
                                         @ApiParam(name = "id", value = "主键", required = true) @RequestParam String id) throws Exception {
        //桥梁
        if (type == 1) {
            baseService.updateByBridgeCoordinate(id, x, y);
        }
        //隧道
        if (type == 2) {
            baseService.updateByTunnelCoordinate(id, x, y);
        }
        //边坡
        if (type == 3) {
            baseService.updateBySideSlopeCoordinate(id, x, y);
        }
        //涵洞
        if (type == 4) {
            baseService.updateByCulvertCoordinate(id, x, y);
        }

        return new CommonResult<String>(true, "修改成功");
    }



    @PostMapping("/minioDrawingUpload")
    @ApiOperation(value = "上传照片")
    public String minioDrawingUpload(MultipartFile file) {
        String fileurl = baseService.minioDrawingUpload(file);
        return fileurl;
    }

}



