package com.artfess.yhxt.assessment.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.*;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.poi.Excel;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.model.Role;
import com.artfess.yhxt.assessment.manager.CuringAssessmentDetailedManager;
import com.artfess.yhxt.assessment.model.CuringAssessmentDetailed;
import com.artfess.yhxt.assessment.vo.CuringAssessmentIVo;
import com.artfess.yhxt.check.regular.model.CulvertOftenCheck;
import com.artfess.yhxt.contract.manager.WorkOrderInformationManager;
import com.artfess.yhxt.contract.model.WorkOrderInformation;
import com.artfess.yhxt.contract.vo.WorkOrderDiseaseVo;
import com.artfess.yhxt.contract.vo.WorkOrderVo;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.assessment.model.CuringAssessment;
import com.artfess.yhxt.assessment.manager.CuringAssessmentManager;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;


/**
 * 养护考核表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2021-11-03
 */
@RestController
@Slf4j
@RequestMapping("/assessment/curingAssessment/v1/")
@Api(tags = "养护考核信息接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class CuringAssessmentController extends BaseController<CuringAssessmentManager, CuringAssessment> {

    @Resource
    private CuringAssessmentDetailedManager curingAssessmentDetailedManager;

    @Resource
    private WorkOrderInformationManager workOrderInformationManager;

    @Resource
    private BaseContext baseContext;

    @Resource
    private PermissionUtils permissionUtils;

    @RequestMapping(value = "saveCuringAssessment", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改养护考核信息", httpMethod = "POST")
    public CommonResult<String> saveCuringAssessment(@ApiParam(name = "curingAssessmentIVo", value = "养护考核对象")
                                                         @RequestBody CuringAssessmentIVo curingAssessmentIVo) throws Exception {

        String data = baseService.saveCuringAssessment(curingAssessmentIVo);
        return new CommonResult<String>(true,"数据保存成功", data);
    }


    @RequestMapping(value="getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询养护考核信息",httpMethod = "POST")
    public PageList<CuringAssessmentIVo> getJson(@ApiParam(name="queryFilter", value="分页查询信息")
                                                   @RequestBody QueryFilter<CuringAssessment> queryFilter) {
        queryFilter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);

        permissionUtils.addPermission(queryFilter);


        List<FieldSort> sorter = queryFilter.getSorter();
        for (FieldSort fieldSort : sorter) {
            if(fieldSort.getProperty().equals("startDate")){
                fieldSort.setProperty("START_DATE_");
            }
        }
        PageList<CuringAssessment> pageList = baseService.query(queryFilter);
        PageList<CuringAssessmentIVo> pageListVo = new PageList<>();
        pageListVo.setPage(pageList.getPage());
        pageListVo.setPageSize(pageList.getPageSize());
        pageListVo.setTotal(pageList.getTotal());
        List<CuringAssessment> rows = pageList.getRows();
        List<CuringAssessmentIVo> voRows = new ArrayList<>();
        if(rows != null){
            for(CuringAssessment curingAssessment : rows){
                CuringAssessmentIVo curingAssessmentIVo = new CuringAssessmentIVo();
                curingAssessmentIVo.setCuringAssessment(curingAssessment);
                QueryWrapper<CuringAssessmentDetailed> queryWrapper = new QueryWrapper<CuringAssessmentDetailed>();
                queryWrapper.eq("ASSESSMENT_MAIN_ID_",curingAssessment.getId());
                List<CuringAssessmentDetailed> curingAssessmentDetailedList = curingAssessmentDetailedManager.list(queryWrapper);
                curingAssessmentIVo.setCuringAssessmentDetailedList(curingAssessmentDetailedList);
                voRows.add(curingAssessmentIVo);
            }
        }
        pageListVo.setRows(voRows);
        return  pageListVo;
    }

    @RequestMapping(value="exportCuringOrder",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation("根据养护考核信息导出养护工单列表")
    public void exportCuringOrder(@ApiParam(required = true, name = "queryFilter", value = "查询参数对象（startTime开始时间 endTime 结束时间 roadId 路段id）")
                                      @RequestBody QueryFilter queryFilter, HttpServletResponse response) throws Exception{
        PageList<WorkOrderDiseaseVo> workOrderVoPageList = workOrderInformationManager.getWorkOrder(queryFilter);
        List<WorkOrderDiseaseVo> rows = workOrderVoPageList.getRows();
        HSSFWorkbook exportFile = baseService.exportCuringOrder(rows);
        ExcelUtil.downloadExcel(exportFile,"养护工单",response);
    }

    @RequestMapping(value="exportCuringAssessment",method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value="根据养护考核信息ID导出考核信息", httpMethod = "GET", notes = "根据养护考核信息ID导出考核信息")
    public void exportCuringAssessment(@ApiParam(name="ids",value="ids", required = true)@RequestParam String ids,
                                       HttpServletResponse response) throws Exception{
        HSSFWorkbook exportFile = baseService.exportCuringAssessment(ids);//日常养护考核评分表
        ExcelUtil.downloadExcel(exportFile,"日常养护考核评分表",response);
    }

}
