package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.manager.BizEngineeringAccessoriesManager;
import com.artfess.yhxt.specialproject.model.BizEngineeringAccessories;
import com.artfess.yhxt.specialproject.model.BizProjectSafetyEnvironmentalRecord;
import com.artfess.yhxt.specialproject.model.BizProjectSafetyEnvironmentalRecord;
import com.artfess.yhxt.specialproject.model.BizProjectSafetyEnvironmentalRecord;
import com.artfess.yhxt.specialproject.dao.BizProjectSafetyEnvironmentalRecordDao;
import com.artfess.yhxt.specialproject.manager.BizProjectSafetyEnvironmentalRecordManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.specialproject.vo.BizProjectSafetyEnvironmentalRecordVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 工程安全环保记录表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-11
 */
@Service
public class BizProjectSafetyEnvironmentalRecordManagerImpl extends BaseManagerImpl<BizProjectSafetyEnvironmentalRecordDao, BizProjectSafetyEnvironmentalRecord> implements BizProjectSafetyEnvironmentalRecordManager {

    @Resource
    private BizEngineeringAccessoriesManager bizEngineeringAccessoriesManager;

    @Override
    public PageList<BizProjectSafetyEnvironmentalRecord> queryBizProjectSafetyEnvironmentalRecord(QueryFilter<BizProjectSafetyEnvironmentalRecord> queryFilter) {
        IPage<BizProjectSafetyEnvironmentalRecord> result =  baseMapper.queryBizProjectSafetyEnvironmentalRecord(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizProjectSafetyEnvironmentalRecord getBizProjectSafetyEnvironmentalRecordById(String id) {
        BizProjectSafetyEnvironmentalRecord bizProjectSafetyEnvironmentalRecord = baseMapper.selectById(id);
        return bizProjectSafetyEnvironmentalRecord;
    }

    @Override
    public void saveVo(BizProjectSafetyEnvironmentalRecordVo bizProjectSafetyEnvironmentalRecordVo) {
        //安全环保
        BizProjectSafetyEnvironmentalRecord bizProjectSafetyEnvironmentalRecord = bizProjectSafetyEnvironmentalRecordVo.getBizProjectSafetyEnvironmentalRecord();
        this.create(bizProjectSafetyEnvironmentalRecord);
        //附件
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = bizProjectSafetyEnvironmentalRecordVo.getBizEngineeringAccessoriesList();
        String sourceId = bizProjectSafetyEnvironmentalRecord.getId();
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public void updateVo(BizProjectSafetyEnvironmentalRecordVo bizProjectSafetyEnvironmentalRecordVo) {
        //安全环保
        BizProjectSafetyEnvironmentalRecord bizProjectSafetyEnvironmentalRecord = bizProjectSafetyEnvironmentalRecordVo.getBizProjectSafetyEnvironmentalRecord();
        this.update(bizProjectSafetyEnvironmentalRecord);
        String sourceId = bizProjectSafetyEnvironmentalRecord.getId();
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = bizProjectSafetyEnvironmentalRecordVo.getBizEngineeringAccessoriesList();
        //删除附件信息
        bizEngineeringAccessoriesManager.removeEngineeringAccessories(sourceId);
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public BizProjectSafetyEnvironmentalRecordVo getVo(String id) {
        BizProjectSafetyEnvironmentalRecordVo bizProjectSafetyEnvironmentalRecordVo= new BizProjectSafetyEnvironmentalRecordVo();
        BizProjectSafetyEnvironmentalRecord bizProjectSafetyEnvironmentalRecord = this.getById(id);
        List<BizEngineeringAccessories> engineeringAccessories = this.bizEngineeringAccessoriesManager.getEngineeringAccessoriesBySourceId(id);
        bizProjectSafetyEnvironmentalRecordVo.setBizProjectSafetyEnvironmentalRecord(bizProjectSafetyEnvironmentalRecord);
        bizProjectSafetyEnvironmentalRecordVo.setBizEngineeringAccessoriesList(engineeringAccessories);
        return bizProjectSafetyEnvironmentalRecordVo;
    }
}
