package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.sysConfig.persistence.model.SysActuator;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.budget.manager.YearBudgetDetailedManager;
import com.artfess.yhxt.budget.manager.YearBudgetManager;
import com.artfess.yhxt.budget.model.YearBudget;
import com.artfess.yhxt.budget.model.YearBudgetDetailed;
import com.artfess.yhxt.contract.model.BillOfQuantities;
import com.artfess.yhxt.disease.model.Disease;
import com.artfess.yhxt.disease.vo.DiseaseReportVO;
import com.artfess.yhxt.specialproject.manager.*;
import com.artfess.yhxt.specialproject.model.*;
import com.artfess.yhxt.specialproject.dao.BizEngineeringProjectDao;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.specialproject.vo.BizEngineeringProjectVo;
import com.artfess.yhxt.specialproject.vo.ProjectMoneyListVO;
import com.artfess.yhxt.specialproject.vo.ProjectMoneyVO;
import com.artfess.yhxt.specialproject.vo.ProjectReportVO;
import com.artfess.yhxt.statistics.vo.Org4DiseaseVO;
import com.artfess.yhxt.statistics.vo.Org4ProjectMoneyVO;
import com.artfess.yhxt.statistics.vo.Org4ProjectVO;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * 工程项目表 服务实现类
 *
 * @author wangping
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-08-10
 */
@Service
public class BizEngineeringProjectManagerImpl extends BaseManagerImpl<BizEngineeringProjectDao, BizEngineeringProject> implements BizEngineeringProjectManager {
    @Resource
    BizEngineeringProjectDao bizEngineeringProjectDao;

    @Resource
    BizEngineeringAccessoriesManager bizEngineeringAccessoriesManager;

    @Resource
    private OrgDao orgDao;

    @Resource
    BaseContext baseContext;

    @Resource
    private RoadManager roadManager;

    @Resource
    private BizProjectContractManager bizProjectContractManager;

    @Resource
    private MeasurementPaymentManager measurementPaymentManager;

    @Resource
    private MeasurementPaymentDetailsManager measurementPaymentDetailsManager;

    @Autowired
    private YearBudgetManager yearBudgetManager;

    @Autowired
    private YearBudgetDetailedManager yearBudgetDetailedManager;




    @Override
    public List<ProjectMoneyListVO> getMoneyListReport(String year, String orgId) {
        List<ProjectMoneyListVO> vos =  new ArrayList<>();
        QueryWrapper<Road> roadWrapper = new QueryWrapper<>();
        roadWrapper.eq("IS_DELE_","0");
        roadWrapper.like("COMPANY_IDS_",orgId);
        List<Road> roads = roadManager.list(roadWrapper);
        for (Road road : roads){
            //获取金额
            QueryWrapper<YearBudget> queryWrapperYearBudget = new QueryWrapper<>();
            queryWrapperYearBudget.eq("IS_DELE_", "0");
            queryWrapperYearBudget.eq("ROAD_SEGMENT_ID_", road.getId());
            queryWrapperYearBudget.eq("ASCRIPTION_YEAR_", String.valueOf(year));
            YearBudget yearBudget = yearBudgetManager.getOne(queryWrapperYearBudget);

            QueryWrapper<BizEngineeringProject> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("IS_DELE_","0");
            queryWrapper.eq("ROAD_SEGMENT_ID_",road.getId());
            queryWrapper.eq("PROJECT_YEAR_",year);
            List<BizEngineeringProject> list = this.list(queryWrapper);
            for (BizEngineeringProject project : list){
                BigDecimal payMoney = BigDecimal.ZERO;
                ProjectMoneyListVO vo = new ProjectMoneyListVO();
                vo.setRoadName(road.getName());
                vo.setProjectName(project.getProjectName());
                vo.setProjectMoney(project.getProjectMoney());
                if (yearBudget!=null){
                    QueryWrapper<YearBudgetDetailed> detailedQueryWrapper = new QueryWrapper<>();
                    detailedQueryWrapper.eq("YEAR_BUDGET_ID_",yearBudget.getId());
                    detailedQueryWrapper.eq("IS_DELE_","0");
                    detailedQueryWrapper.eq("BUDGET_CONTENT",project.getProjectName());
                    List<YearBudgetDetailed> detaileds = yearBudgetDetailedManager.list(detailedQueryWrapper);
                    if (detaileds.size()>0){
                        List<BigDecimal> worlMoneyF = detaileds.stream().filter(s -> s != null && s.getImageProgress() != null).map(YearBudgetDetailed::getImageProgress).collect(Collectors.toList());
                        for (BigDecimal pay : worlMoneyF){
                            payMoney = payMoney.add(pay);
                        }
                    }
                }
                vo.setPayMoney(payMoney);
                if (!payMoney.equals(BigDecimal.ZERO)&&!vo.getProjectMoney().equals(BigDecimal.ZERO)){
                    vo.setPayRate(vo.getPayMoney().divide(vo.getProjectMoney(),2,BigDecimal.ROUND_UP));
                }else {
                    vo.setPayRate(BigDecimal.ZERO);
                }
                vos.add(vo);
            }
        }
        return vos;
    }

    @Override
    public List<ProjectMoneyVO> getMoneyReport(String year, String orgId) {
        List<ProjectMoneyVO> vos =  new ArrayList<>();
        QueryWrapper<Road> roadWrapper = new QueryWrapper<>();
        roadWrapper.eq("IS_DELE_","0");
        roadWrapper.like("COMPANY_IDS_",orgId);
        List<Road> roads = roadManager.list(roadWrapper);
        for (Road road : roads){
            ProjectMoneyVO vo = new ProjectMoneyVO();
            vo.setRoadName(road.getName());
            QueryWrapper<BizEngineeringProject> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("IS_DELE_","0");
            queryWrapper.eq("ROAD_SEGMENT_ID_",road.getId());
            queryWrapper.eq("PROJECT_YEAR_",year);
            List<BizEngineeringProject> list = this.list(queryWrapper);
            BigDecimal payMoney = BigDecimal.ZERO;
            if (list.size()>0){
                vo.setProjectCount(list.size());
                vo.setProjectMoney(list.stream().map(p -> p.getProjectMoney()).reduce(BigDecimal.ZERO, BigDecimal::add));
                //获取金额
                QueryWrapper<YearBudget> queryWrapperYearBudget = new QueryWrapper<>();
                queryWrapperYearBudget.eq("IS_DELE_", "0");
                queryWrapperYearBudget.eq("ROAD_SEGMENT_ID_", road.getId());
                queryWrapperYearBudget.eq("ASCRIPTION_YEAR_", String.valueOf(year));
                YearBudget yearBudget = yearBudgetManager.getOne(queryWrapperYearBudget);
                if (yearBudget!=null){
                    for (BizEngineeringProject project:list){
                        QueryWrapper<YearBudgetDetailed> detailedQueryWrapper = new QueryWrapper<>();
                        detailedQueryWrapper.eq("YEAR_BUDGET_ID_",yearBudget.getId());
                        detailedQueryWrapper.eq("IS_DELE_","0");
                        detailedQueryWrapper.eq("BUDGET_CONTENT",project.getProjectName());
                        List<YearBudgetDetailed> detaileds = yearBudgetDetailedManager.list(detailedQueryWrapper);
                        if (detaileds.size()>0){
                            List<BigDecimal> worlMoneyF = detaileds.stream().filter(s -> s != null && s.getImageProgress() != null).map(YearBudgetDetailed::getImageProgress).collect(Collectors.toList());
                            for (BigDecimal pay : worlMoneyF){
                                payMoney = payMoney.add(pay);
                            }
                        }
                    }
                }
            }else {
                vo.setProjectMoney(BigDecimal.ZERO);
            }
            vo.setPayMoney(payMoney);
            if (!payMoney.equals(BigDecimal.ZERO)&&!vo.getProjectMoney().equals(BigDecimal.ZERO)){
                vo.setPayRate(payMoney.divide(vo.getProjectMoney(),2,BigDecimal.ROUND_UP));
            }else {
                vo.setPayRate(BigDecimal.ZERO);
            }
            vos.add(vo);
        }
        return vos;
    }

    @Override
    public List<ProjectReportVO> getReport(String year,String orgId) {
        List<ProjectReportVO> vos =  new ArrayList<>();
        QueryWrapper<Road> roadWrapper = new QueryWrapper<>();
        roadWrapper.eq("IS_DELE_","0");
        roadWrapper.like("COMPANY_IDS_",orgId);
        List<Road> roads = roadManager.list(roadWrapper);
        for (Road road : roads){
            ProjectReportVO vo = new ProjectReportVO();
            vo.setRoadName(road.getName());
            QueryWrapper<BizEngineeringProject> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("IS_DELE_","0");
            queryWrapper.eq("ROAD_SEGMENT_ID_",road.getId());
            queryWrapper.eq("PROJECT_YEAR_",year);
            List<BizEngineeringProject> list = this.list(queryWrapper);
            if (list.size()>0){
                vo.setProjectCount(list.size());
                vo.setProjectMoney(list.stream().map(p -> p.getProjectMoney()).reduce(BigDecimal.ZERO, BigDecimal::add));
                List<BizEngineeringProject> spePoject = list.stream().filter(p -> p.getSpecialType().equals("0")).collect(Collectors.toList());
                List<BizEngineeringProject> dayPoject = list.stream().filter(p -> p.getSpecialType().equals("1")).collect(Collectors.toList());
                vo.setSpecialCount(spePoject.size());
                vo.setSpecialMoney(spePoject.stream().map(p -> p.getProjectMoney()).reduce(BigDecimal.ZERO,BigDecimal::add));
                vo.setDailyCount(dayPoject.size());
                vo.setDailyMoney(dayPoject.stream().map(p -> p.getProjectMoney()).reduce(BigDecimal.ZERO,BigDecimal::add));
                vo.setStartCount(list.stream().filter(p -> p.getStartupFlag()>0).collect(Collectors.toList()).size());
                vo.setUnStartCount(list.size()-vo.getStartCount());
                if (vo.getStartCount()>0){
                    vo.setStartRate(new BigDecimal(vo.getStartCount()).divide(new BigDecimal(list.size()),2,BigDecimal.ROUND_UP));
                }else {
                    vo.setStartRate(new BigDecimal(0));
                }
            }else {
                vo.setDailyMoney(new BigDecimal(0));
                vo.setSpecialMoney(new BigDecimal(0));
                vo.setStartRate(new BigDecimal(0));
            }
            vos.add(vo);
        }
        return vos;
    }

    @Override
    public List<Org4ProjectMoneyVO> getProjectMoneyCount(String year) {
        String orgId ;
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId())&&!"0".equals(baseContext.getCurrentOrgId())){
            orgId = baseContext.getCurrentOrgId();
        }else {
            orgId = "1419863231459102720";
        }
        List<Org4ProjectMoneyVO> lists = new ArrayList<>();

        List<Org> rtnList = new ArrayList<Org>();

        QueryWrapper<Org> rgQueryWrapper = new QueryWrapper<>();
        rgQueryWrapper.eq("is_dele_","0");
        List<Org> allList = orgDao.selectList(rgQueryWrapper);

        List<Org> list = getOrgChild(allList, orgId, rtnList);
        for (Org org: list){
            Org4ProjectMoneyVO fvo = new Org4ProjectMoneyVO();
            BeanUtils.copyProperties(org,fvo);
            lists.add(fvo);
        }
        lists = getMoneyChild(lists,orgId);

        return this.setMoneyCount(lists,year);
    }

    public Org4ProjectMoneyVO newMoneyCount(List<String> ids,Org4ProjectMoneyVO orgVO,String year) {
        QueryWrapper<BizEngineeringProject> orderQueryWrapper = new QueryWrapper<>();
        orderQueryWrapper.in("ROAD_SEGMENT_ID_", ids);
        orderQueryWrapper.eq("PROJECT_YEAR_",year);
        orderQueryWrapper.eq("IS_DELE_",0);
        List<BizEngineeringProject> list = this.list(orderQueryWrapper);
        if (list.size()>0){
            orgVO.setProjectMoney(list.stream().map(p -> p.getProjectMoney())
                    .reduce(BigDecimal.ZERO, (b1, b2) -> b1.add(b2)));

            List<String> projectIds = list.stream().map(BizEngineeringProject::getId).collect(Collectors.toList());

            QueryWrapper<MeasurementPayment> payQueryWrapper = new QueryWrapper<>();
            payQueryWrapper.in("PROJECT_ID_",projectIds);
            payQueryWrapper.eq("IS_DELE_",0);
            List<MeasurementPayment> payments = measurementPaymentManager.list(payQueryWrapper);
            if (payments.size()>0){
                List<String> payIdS = payments.stream().map(MeasurementPayment::getId).collect(Collectors.toList());
                QueryWrapper<MeasurementPaymentDetails> detatilQueryWrapper = new QueryWrapper<>();
                detatilQueryWrapper.in("MEASUREMENT_PAYMENT_ID_",payIdS);
                detatilQueryWrapper.isNotNull("PAID_MONEY_");
                List<MeasurementPaymentDetails> details = measurementPaymentDetailsManager.list(detatilQueryWrapper);
                if (details.size()>0){
                    orgVO.setPayMoney(details.stream().map(p -> p.getPaidMoney())
                            .reduce(BigDecimal.ZERO, (b1, b2) -> b1.add(b2)));
                }else {
                    orgVO.setPayMoney(new BigDecimal("0"));
                }
            }else {
                orgVO.setPayMoney(new BigDecimal("0"));
            }
            if ("4".equals(orgVO.getGrade())){
                orgVO.setRoadSegmentId(list.get(0).getRoadSegmentId());
            }

            for (BizEngineeringProject project : list){
                String regEx="[^0-9]";
                Pattern p = Pattern.compile(regEx);
                Matcher m = p.matcher(project.getWorkProgress());
                project.setPersent(BigDecimal.valueOf(Double.valueOf(m.replaceAll("").trim())));
            }
            orgVO.setProgress(this.getPercent(list.stream().map(p -> p.getPersent())
                    .reduce(BigDecimal.ZERO, (b1, b2) -> b1.add(b2)),list.size()*100));
        }else {
            orgVO.setPayMoney(new BigDecimal("0"));
            orgVO.setProgress("0.00%");
            orgVO.setProjectMoney(new BigDecimal("0"));

        }
        return orgVO;
    }

    public List<Org4ProjectMoneyVO> setMoneyCount(List<Org4ProjectMoneyVO> list,String year){

        // 获取迭代器
        Iterator<Org4ProjectMoneyVO> it = list.iterator();

        while(it.hasNext()){
            Org4ProjectMoneyVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<>();
            if (grade<4){
                QueryWrapper<Road> roadQueryWrapper = new QueryWrapper<>();
                roadQueryWrapper.like( "COMPANY_IDS_", orgVO.getId());
                roadList = roadManager.list(roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }else if (grade==4){
                QueryWrapper<Road> roadByNameQueryWrapper = new QueryWrapper<>();
                roadByNameQueryWrapper.eq("NAME_",orgVO.getName());
                roadList =
                        roadManager.list(roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size()>0){
                orgVO = this.newMoneyCount(roadList,orgVO,year);
            }else {
                it.remove();
            }
            if (orgVO.getChirldren().size()>0&&Integer.valueOf(orgVO.getGrade())<4){
                this.setMoneyCount(orgVO.getChirldren(),year);
            }
        }
        return list;
    }

    public static List<Org4ProjectMoneyVO> getMoneyChild(List<Org4ProjectMoneyVO> allList, String pCode) {
        List<Org4ProjectMoneyVO> returnList = new ArrayList<>();
        for (Org4ProjectMoneyVO entity : allList){
            if (pCode.equals(entity.getParentId())) {
                entity.setChirldren(getMoneyChild(allList, entity.getId()));
                returnList.add(entity);
            }
        }
        return returnList;
    }

    @Override
    public List<Org4ProjectVO> getProjectCount(String year) {
        String orgId ;
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId())&&!"0".equals(baseContext.getCurrentOrgId())){
            orgId = baseContext.getCurrentOrgId();
        }else {
            orgId = "1419863231459102720";
        }
        List<Org4ProjectVO> lists = new ArrayList<>();

        List<Org> rtnList = new ArrayList<Org>();

        QueryWrapper<Org> rgQueryWrapper = new QueryWrapper<>();
        rgQueryWrapper.eq("is_dele_","0");
        List<Org> allList = orgDao.selectList(rgQueryWrapper);

        List<Org> list = getOrgChild(allList, orgId, rtnList);
        for (Org org: list){
            Org4ProjectVO fvo = new Org4ProjectVO();
            BeanUtils.copyProperties(org,fvo);
            lists.add(fvo);
        }
        lists = getChild(lists,orgId);

        return this.setCount(lists,year);
    }

    public List<Org4ProjectVO> setCount(List<Org4ProjectVO> list,String year){

        // 获取迭代器
        Iterator<Org4ProjectVO> it = list.iterator();

        while(it.hasNext()){
            Org4ProjectVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<>();
            if (grade<4){
                QueryWrapper<Road> roadQueryWrapper = new QueryWrapper<>();
                roadQueryWrapper.like( "COMPANY_IDS_", orgVO.getId());
                roadList = roadManager.list(roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }else if (grade==4){
                QueryWrapper<Road> roadByNameQueryWrapper = new QueryWrapper<>();
                roadByNameQueryWrapper.eq("NAME_",orgVO.getName());
                roadList =
                        roadManager.list(roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size()>0){
                orgVO = this.newCountWorkOrder(roadList,orgVO,year);
            }else {
                it.remove();
            }
            if (orgVO.getChirldren().size()>0&&Integer.valueOf(orgVO.getGrade())<4){
                this.setCount(orgVO.getChirldren(),year);
            }
        }
        return list;
    }


    public static String getPercent(BigDecimal x, int y) {
        double d1 = x.doubleValue();
        double d2 = y * 1.0;
        NumberFormat percentInstance = NumberFormat.getPercentInstance();
        // 设置保留几位小数，这里设置的是保留两位小数
        percentInstance.setMinimumFractionDigits(2);
        return percentInstance.format(d1 / d2);
    }

    //统计表格
    public Org4ProjectVO newCountWorkOrder(List<String> ids,Org4ProjectVO orgVO,String year) {
        QueryWrapper<BizEngineeringProject> orderQueryWrapper = new QueryWrapper<>();
        orderQueryWrapper.in("ROAD_SEGMENT_ID_", ids);
        orderQueryWrapper.eq("PROJECT_YEAR_",year);
        orderQueryWrapper.eq("IS_DELE_",0);
        List<BizEngineeringProject> list = this.list(orderQueryWrapper);
        if (list.size()>0){
            orgVO.setProjectMoney(list.stream().map(p -> p.getProjectMoney())
                    .reduce(BigDecimal.ZERO, (b1, b2) -> b1.add(b2)));


            List<String> projectIds = list.stream().map(BizEngineeringProject::getId).collect(Collectors.toList());
            QueryWrapper<BizProjectContract> contractQueryWrapper = new QueryWrapper<>();
            contractQueryWrapper.in("PROJECT_ID_",projectIds);
            contractQueryWrapper.eq("IS_DELE_",0);
            contractQueryWrapper.isNotNull("CONTRACT_AMOUNT_");
            List<BizProjectContract> contracts = bizProjectContractManager.list(contractQueryWrapper);
            if (contracts.size()>0){
                orgVO.setContractMoney(contracts.stream().map(p -> new BigDecimal(p.getContractAmount()))
                        .reduce(BigDecimal.ZERO, (b1, b2) -> b1.add(b2)));
            }else {
                orgVO.setContractMoney(new BigDecimal("0"));
            }

            QueryWrapper<MeasurementPayment> payQueryWrapper = new QueryWrapper<>();
            payQueryWrapper.in("PROJECT_ID_",projectIds);
            payQueryWrapper.eq("IS_DELE_",0);
            List<MeasurementPayment> payments = measurementPaymentManager.list(payQueryWrapper);
            if (payments.size()>0){
                List<String> payIdS = payments.stream().map(MeasurementPayment::getId).collect(Collectors.toList());
                QueryWrapper<MeasurementPaymentDetails> detatilQueryWrapper = new QueryWrapper<>();
                detatilQueryWrapper.in("MEASUREMENT_PAYMENT_ID_",payIdS);
                detatilQueryWrapper.isNotNull("PAID_MONEY_");
                List<MeasurementPaymentDetails> details = measurementPaymentDetailsManager.list(detatilQueryWrapper);
                if (details.size()>0){
                    orgVO.setPayMoney(details.stream().map(p -> p.getPaidMoney())
                            .reduce(BigDecimal.ZERO, (b1, b2) -> b1.add(b2)));
                }else {
                    orgVO.setPayMoney(new BigDecimal("0"));
                }
            }else {
                orgVO.setPayMoney(new BigDecimal("0"));
            }
            if ("4".equals(orgVO.getGrade())){
                orgVO.setRoadSegmentId(list.get(0).getRoadSegmentId());
            }

            for (BizEngineeringProject project : list){
                String regEx="[^0-9]";
                Pattern p = Pattern.compile(regEx);
                Matcher m = p.matcher(project.getWorkProgress());
                project.setPersent(BigDecimal.valueOf(Double.valueOf(m.replaceAll("").trim())));
            }
            orgVO.setProgress(this.getPercent(list.stream().map(p -> p.getPersent())
                    .reduce(BigDecimal.ZERO, (b1, b2) -> b1.add(b2)),list.size()*100));
        }else {
            orgVO.setPayMoney(new BigDecimal("0"));
            orgVO.setProgress("0.00%");
            orgVO.setProjectMoney(new BigDecimal("0"));
            orgVO.setContractMoney(new BigDecimal("0"));
        }


        return orgVO;
    }

    /**
     * 获取某个父节点下面的所有子节点
     *
     * @param orgList
     * @param parentId
     * @return
     */
    public static List<Org> getOrgChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            // 遍历出父id等于参数的id，add进子节点集合
            if (parentId.equals(org.getParentId())) {
                // 递归遍历下一级
                getOrgChild(orgList, org.getId(), rtnList);
                rtnList.add(org);
            }
        }
        return rtnList;
    }

    public static List<Org4ProjectVO> getChild(List<Org4ProjectVO> allList, String pCode) {
        List<Org4ProjectVO> returnList = new ArrayList<>();
        for (Org4ProjectVO entity : allList){
            if (pCode.equals(entity.getParentId())) {
                entity.setChirldren(getChild(allList, entity.getId()));
                returnList.add(entity);
            }
        }
        return returnList;
    }

    @Override
    public PageList<BizEngineeringProject> queryBizEngineeringProject(QueryFilter<BizEngineeringProject> queryFilter) {
        IPage<BizEngineeringProject> result = baseMapper.queryBizEngineeringProject(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizEngineeringProject getBizEngineeringProjectById(String id) {
        BizEngineeringProject bizEngineeringProject = baseMapper.selectById(id);
        return bizEngineeringProject;
    }

    @Override
    public void updateFlag(String ids, Integer flag) {
        List<String> idsList = Arrays.asList(ids.split(","));
        UpdateWrapper<BizEngineeringProject> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("VALID_FLAG_", flag).in("ID_", idsList);
        this.bizEngineeringProjectDao.update(null, updateWrapper);
    }

    @Override
    public void saveVo(BizEngineeringProjectVo bizEngineeringProjectVo) {
        //工程项目
        BizEngineeringProject bizEngineeringProject = bizEngineeringProjectVo.getBizEngineeringProject();
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId())){
            bizEngineeringProject.setCompanyId(baseContext.getCurrentOrgId());
        }

        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgName())){
            bizEngineeringProject.setCompanyName(baseContext.getCurrentOrgName());
        }

        this.create(bizEngineeringProject);
        //附件
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = bizEngineeringProjectVo.getBizEngineeringAccessoriesList();
        String sourceId = bizEngineeringProject.getId();
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public void updateVo(BizEngineeringProjectVo bizEngineeringProjectVo) {
        //工程项目
        BizEngineeringProject bizEngineeringProject = bizEngineeringProjectVo.getBizEngineeringProject();
        this.update(bizEngineeringProject);
        String sourceId = bizEngineeringProject.getId();
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = bizEngineeringProjectVo.getBizEngineeringAccessoriesList();
        bizEngineeringAccessoriesManager.removeEngineeringAccessories(sourceId);
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public BizEngineeringProjectVo getVo(String id) {
        BizEngineeringProjectVo bizEngineeringProjectVo= new BizEngineeringProjectVo();
        BizEngineeringProject bizEngineeringProject = this.getById(id);
        List<BizEngineeringAccessories> engineeringAccessories = this.bizEngineeringAccessoriesManager.getEngineeringAccessoriesBySourceId(id);
        bizEngineeringProjectVo.setBizEngineeringProject(bizEngineeringProject);
        bizEngineeringProjectVo.setBizEngineeringAccessoriesList(engineeringAccessories);
        return bizEngineeringProjectVo;
    }
}
