package com.artfess.yhxt.specialproject.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.specialproject.vo.ProjectOverApplyForVo;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.hasor.utils.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.specialproject.model.ProjectOverApplyFor;
import com.artfess.yhxt.specialproject.manager.ProjectOverApplyForManager;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * 项目交工申请表 前端控制器
 *
 * @author xzh
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-08-18
 */
@RestController
@RequestMapping("/projectOverApplyFor/v1/")
@Api(tags = "项目交工申请接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ProjectOverApplyForController extends BaseController<ProjectOverApplyForManager, ProjectOverApplyFor> {
    @Resource
    private PermissionUtils permissionUtils;

    @Resource
    private BaseContext baseContext;

    @RequestMapping(value = "getJson", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "分页查询项目交工申请信息", httpMethod = "POST")
    public PageList<ProjectOverApplyFor> getJson(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<ProjectOverApplyFor> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
//if (baseContext.getCurrentOrgName().equals("监理方")){
//    queryFilter.addFilter("CONFIRM_STATUS_",0,QueryOP.EQUAL, FieldRelation.OR);
//    queryFilter.addFilter("CONFIRM_STATUS_",1,QueryOP.EQUAL, FieldRelation.OR);
//    queryFilter.addFilter("CONFIRM_STATUS_",2,QueryOP.EQUAL, FieldRelation.OR);
//}
//if (baseContext.getCurrentOrgName().equals("业主方")){
//    queryFilter.addFilter("CONFIRM_STATUS_",3,QueryOP.EQUAL, FieldRelation.OR);
//    queryFilter.addFilter("CONFIRM_STATUS_",4,QueryOP.EQUAL, FieldRelation.OR);
//    queryFilter.addFilter("CONFIRM_STATUS_",5,QueryOP.EQUAL, FieldRelation.OR);
//}
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
            permissionUtils.addPermissionByCreateOrgId(queryFilter);
        }
        PageList<ProjectOverApplyFor> pageList = baseService.queryProjectOverApplyFor(queryFilter);
        return pageList;
    }

    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存项目交工申请信息", httpMethod = "POST")
    public CommonResult<String> save(@ApiParam(name = "projectOverApplyFor", value = "项目交工申请信息") @RequestBody ProjectOverApplyFor projectOverApplyFor) throws Exception {
        String msg = "添加成功";
        if (StringUtils.isEmpty(projectOverApplyFor.getId())){
            projectOverApplyFor.setConfirmStatus(0);
            baseService.saveProjectOverApplyFor(projectOverApplyFor);

        }else {
            Integer confirmStatus = projectOverApplyFor.getConfirmStatus();
            // 如如果监理方审核 不通过后则修改后重置为待审核状态
            if(null != confirmStatus && confirmStatus == 2){
                projectOverApplyFor.setConfirmStatus(0);
            }
            // 如如果业主方审核 不通过后则修改后重置为待审核状态
            if(null != confirmStatus && confirmStatus == 4){
                projectOverApplyFor.setConfirmStatus(0);
            }
            baseService.updateProjectOverApplyFor(projectOverApplyFor);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }

    @RequestMapping(value = "/saveVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存项目交工申请信息、附件", httpMethod = "POST")
    public CommonResult<String> saveVo(@ApiParam(name = "projectOverApplyForVo", value = "项目项目交工申请信息 vo") @RequestBody ProjectOverApplyForVo projectOverApplyForVo) throws Exception {
        String msg = "添加成功";
        ProjectOverApplyFor projectOverApplyFor = projectOverApplyForVo.getProjectOverApplyFor();
        if (StringUtils.isEmpty(projectOverApplyFor.getId())){

            baseService.saveVo(projectOverApplyForVo);

        }else {

            baseService.updateVo(projectOverApplyForVo);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }
    @GetMapping(value = "getVo/{id}")
    @ApiOperation(value = "根据ID项目交工申请信息、附件",httpMethod = "GET",notes = "根据ID项目交工申请信息、附件")
    public ProjectOverApplyForVo getVo(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        return baseService.getVo(id);
    }

    @RequestMapping(value = "/deleteProjectOverApplyFor", method = RequestMethod.DELETE, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "逻辑删除项目交工申请", httpMethod = "DELETE", notes = "逻辑删除项目交工申请")
    public CommonResult<String> deleteProjectOverApplyFor(@ApiParam(name = "ids", value = "ID集合以，隔开", required = true)
                                                          @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<ProjectOverApplyFor> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("ID_", idsList);
            updateWrapper.set("is_dele_", "1");
            baseService.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "删除成功");
    }

    @RequestMapping(value = "/ownerUserAudit", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "项目交工申请-业主方审核接口", httpMethod = "POST", notes = "项目交工申请-业主方审核接口")
    public CommonResult<String> ownerUserAudit(@ApiParam(name = "ids", value = "ID集合以，隔开", required = true)
                                               @RequestParam(value = "ids", required = true) String ids,
                                               @ApiParam(name = "ownerDescription", value = "业主方审核意见", required = true)
                                               @RequestParam String ownerDescription,
                                               @ApiParam(name = "confirmStatus", value = "审核状态", required = true)
                                               @RequestParam Integer confirmStatus) throws Exception {
        this.baseService.ownerUserAudit(ids,ownerDescription,confirmStatus);

        return new CommonResult<>(true, "审核成功");
    }

    @RequestMapping(value = "/confirmUserAudit", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "项目交工申请-监理方审核接口", httpMethod = "POST", notes = "项目交工申请-监理方审核接口")
    public CommonResult<String> confirmUserAudit(@ApiParam(name = "ids", value = "ID集合以，隔开", required = true)
                                                 @RequestParam(value = "ids", required = true) String ids,
                                                 @ApiParam(name = "confirmDescription", value = "监理方审核意见", required = true)
                                                 @RequestParam String confirmDescription,
                                                 @ApiParam(name = "confirmStatus", value = "审核状态", required = true)
                                                 @RequestParam Integer confirmStatus) throws Exception {
        this.baseService.confirmUserAudit(ids,confirmDescription,confirmStatus);

        return new CommonResult<>(true, "审核成功");
    }
}
