package com.artfess.yhxt.specialproject.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.yhxt.specialproject.params.ConstructionParamVo;
import com.artfess.yhxt.specialproject.vo.MeasurementPaymentVo;
import com.artfess.yhxt.util.ExcelToPdfUtil;
import com.artfess.yhxt.util.PermissionUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.hasor.utils.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.specialproject.model.MeasurementPayment;
import com.artfess.yhxt.specialproject.manager.MeasurementPaymentManager;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;

/**
 * 专项工程-计量支付 前端控制器
 *
 * @author xmz
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-06-29
 */
@RestController
@RequestMapping("/measurement/payment/v1/")
@Api(tags = "计量支付")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class MeasurementPaymentController extends BaseController<MeasurementPaymentManager, MeasurementPayment> {


    @Resource
    private PermissionUtils permissionUtils;

    @RequestMapping(value = "/saveVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改项目周报月报、附件信息", httpMethod = "POST")
    public CommonResult<String> saveVo(@ApiParam(name = "bizProjectWeeklyMonthlyReportVo", value = "项目周报月报对象") @RequestBody MeasurementPaymentVo vo) throws Exception {
        String msg = "添加成功";
        MeasurementPayment measurementPayment = vo.getMeasurementPayment();
        if (StringUtils.isEmpty(measurementPayment.getId())) {
            baseService.saveVo(vo);
        } else {
            baseService.updateVo(vo);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }

    @GetMapping("get/{id}")
    @ApiOperation("根据id查询实体")
    public MeasurementPaymentVo getVoById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        return baseService.getVoById(id);
    }

    @DeleteMapping("/removeById/{ids}")
    @ApiOperation("根据id删除")
    public CommonResult<String> removeById(@ApiParam(name = "ids", value = "对各主键用逗号分隔", required = true) @RequestParam String ids) {
        boolean result = baseService.removeVo(ids);
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>(true, "操作成功");
    }

    @PostMapping(value = "/query", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询结果")
    public PageList<MeasurementPayment> query(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<MeasurementPayment> queryFilter) {
        permissionUtils.addPermission(queryFilter);
        return baseService.query(queryFilter);
    }


    @PostMapping(value = "/online/preview/construction", produces = {"application/json; charset=utf-8"})
    @ApiOperation("工程收方记录表（施工类）在线预览")
    public CommonResult<HashMap> onlinePreviewConstruction(@RequestBody ConstructionParamVo param, HttpServletResponse response) throws Exception {
        HashMap map = baseService.onlinePreviewConstruction(param, response);
//        map.put("url","www.baidu.com");
        return new CommonResult<HashMap>(true, "", map);
    }


    @PostMapping(value = "/export/construction", produces = {"application/json; charset=utf-8"})
    @ApiOperation("工程收方记录表（施工类）导出")
    public void exportConstruction(@RequestBody ConstructionParamVo param, HttpServletResponse response) throws Exception {
        HSSFWorkbook workbook = baseService.exportConstruction(param, response);

        ExcelUtil.downloadExcel(workbook, "工程收方记录表", response);
    }

    @PostMapping(value = "/online/preview/collect", produces = {"application/json; charset=utf-8"})
    @ApiOperation("工程收方记录表（汇总类）在线预览")
    public CommonResult<HashMap> onlinePreviewCollect(@RequestBody ConstructionParamVo param, HttpServletResponse response) throws Exception {
        HashMap map = baseService.onlinePreviewCollect(param, response);
        return new CommonResult<HashMap>(true, "", map);
    }


    @PostMapping(value = "/export/collect", produces = {"application/json; charset=utf-8"})
    @ApiOperation("工程收方记录表（汇总类）导出")
    public void exportCollect(@RequestBody ConstructionParamVo param, HttpServletResponse response) throws Exception {
        HSSFWorkbook workbook = baseService.exportCollect(param, response);

        ExcelUtil.downloadExcel(workbook, "工程收方汇总表", response);
    }

}
