package com.artfess.yhxt.specialproject.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.specialproject.model.BizProjectManageQuality;
import com.artfess.yhxt.specialproject.vo.BizProjectManageQualityVo;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.hasor.utils.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.specialproject.model.BizProjectManageQuality;
import com.artfess.yhxt.specialproject.manager.BizProjectManageQualityManager;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * 工程质量管理质检单表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-12
 */
@RestController
@RequestMapping("/bizProjectManageQuality/v1/")
@Api(tags = "工程质量管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizProjectManageQualityController extends BaseController<BizProjectManageQualityManager, BizProjectManageQuality> {
    @Resource
    private PermissionUtils permissionUtils;

    @Resource
    private BaseContext baseContext;


    @RequestMapping(value = "/saveProjectManageQuality",method = RequestMethod.POST,produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改工程质量信息",httpMethod = "POST")
    public CommonResult<String> saveEngineeringProject(@ApiParam(name = "bizProjectManageQuality",value = "工程质量对象") @RequestBody BizProjectManageQuality bizProjectManageQuality) throws Exception {
        String msg = "添加成功";
        if (StringUtils.isEmpty(bizProjectManageQuality.getId())){
            bizProjectManageQuality.setReformFlag(0);
            bizProjectManageQuality.setReformCount(1);
            bizProjectManageQuality.setTestResult(0);
            if (bizProjectManageQuality.getTestResult() != null && bizProjectManageQuality.getTestResult() == 0){
                bizProjectManageQuality.setConfirmResult(1);
            }else {
                bizProjectManageQuality.setConfirmResult(2);
            }
            bizProjectManageQuality.setIsDele("0");
            baseService.create(bizProjectManageQuality);
        }else {
            baseService.update(bizProjectManageQuality);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }

    @RequestMapping(value = "/saveVo",method = RequestMethod.POST,produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改工程质量、附件信息",httpMethod = "POST")
    public CommonResult<String> saveVo(@ApiParam(name = "bizProjectManageQualityVo",value = "工程质量对象") @RequestBody BizProjectManageQualityVo bizProjectManageQualityVo) throws Exception {
        String msg = "添加成功";
        BizProjectManageQuality bizProjectManageQuality = bizProjectManageQualityVo.getBizProjectManageQuality();
        if (StringUtils.isEmpty(bizProjectManageQuality.getId())){
            bizProjectManageQuality.setReformFlag(0);
            bizProjectManageQuality.setReformCount(1);
            bizProjectManageQuality.setTestResult(0);
            if (bizProjectManageQuality.getTestResult() != null && bizProjectManageQuality.getTestResult() == 0){
                bizProjectManageQuality.setConfirmResult(1);
            }else {
                bizProjectManageQuality.setConfirmResult(2);
            }
            bizProjectManageQuality.setIsDele("0");
            baseService.saveVo(bizProjectManageQualityVo);
        }else {
            baseService.updateVo(bizProjectManageQualityVo);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }
    @GetMapping(value = "getVo/{id}")
    @ApiOperation(value = "根据ID查询工程质量、附件信息",httpMethod = "GET",notes = "根据ID查询工程质量信息")
    public BizProjectManageQualityVo getVo(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        return baseService.getVo(id);
    }

    @RequestMapping(value = "getJson",method = RequestMethod.POST,produces = {"application/json;charset=utf-8" })
    @ApiOperation(value = "分页查询工程质量信息",httpMethod ="POST")
    public PageList<BizProjectManageQuality> getJson(@ApiParam(name = "queryFilter",value = "分页查询信息")@RequestBody QueryFilter<BizProjectManageQuality> queryFilter){
        queryFilter.addFilter("is_dele_","0", QueryOP.EQUAL);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
            permissionUtils.addPermissionByCreateOrgId(queryFilter);
        }
        PageList<BizProjectManageQuality> pageList = baseService.queryBizProjectManageQuality(queryFilter);
        return pageList;
    }
    @RequestMapping(value = "getQuery",method = RequestMethod.POST,produces = {"application/json;charset=utf-8" })
    @ApiOperation(value = "分页查询工程质量信息",httpMethod ="POST")
    public PageList<BizProjectManageQuality> getQuery(@ApiParam(name = "queryFilter",value = "分页查询信息")@RequestBody QueryFilter<BizProjectManageQuality> queryFilter){
        queryFilter.addFilter("is_dele_","0", QueryOP.EQUAL);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
            permissionUtils.addPermissionByCreateOrgId(queryFilter);
        }
        PageList<BizProjectManageQuality> pageList = baseService.query(queryFilter);
        return pageList;
    }


    @GetMapping(value = "get/{id}")
    @ApiOperation(value = "根据ID查询工程质量信息",httpMethod = "GET",notes = "根据ID查询工程质量信息")
    public BizProjectManageQuality get(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        return baseService.getBizProjectManageQualityById(id);
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除工程质量信息",httpMethod = "DELETE",notes = "批量删除工程质量信息")
    public CommonResult<String> removes(@ApiParam(name = "ids",value = "对各主键用逗号分隔",required = true) @RequestParam String... ids) throws Exception{
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true,"删除成功");
    }

    @RequestMapping(value = "/updateManageQuality",method = RequestMethod.DELETE,produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "逻辑删除工程质量信息",httpMethod = "DELETE",notes = "逻辑删除工程质量信息")
    public CommonResult<String> updateManageQuality(@ApiParam(name = "ids",value = "ID集合以，隔开",required = true)
                                              @RequestParam(value = "ids",required = true)String ids)throws Exception{
        if (StringUtils.isNotBlank(ids)){
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BizProjectManageQuality> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_",idsList);
            updateWrapper.set("is_dele_","1");
            baseService.update(null,updateWrapper);
        }
        return new CommonResult<>(true,"删除成功");
    }
}
