package com.artfess.yhxt.contract.model;

import com.artfess.base.entity.BizModel;
import com.artfess.yhxt.basedata.model.Road;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 工单信息表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-20
 */
@ApiModel(value="WorkOrderInformation对象", description="工单信息表")
@TableName("biz_work_order_information")
@Data
public class WorkOrderInformation extends BizModel<WorkOrderInformation> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "工单类型")
    @TableField("TYPE_")
    private String type;

    @ApiModelProperty(value = "管理中心Id")
    @TableField("MANAGE_UNIT_ID_")
    private String manageUnitId;

    @ApiModelProperty(value = "施工单位Id")
    @TableField("CONSTRUCT_UNIT_ID_")
    private String constructUnitId;

    @ApiModelProperty(value = "施工单位Ids")
    @TableField("CONSTRUCT_UNIT_IDS_")
    private String constructUnitIds;

    @ApiModelProperty(value = "养护人员id")
    @TableField("ASSIGNED_PERSONNEL_ID_")
    private String assignedPersonnelId;

    @ApiModelProperty(value = "养护人员账号")
    @TableField("ASSIGNED_PERSONNEL_ACCOUNT_")
    private String assignedPersonnelAccount;

    @ApiModelProperty(value = "养护人员姓名")
    @TableField("ASSIGNED_PERSONNEL_")
    private String assignedPersonnel;

    @ApiModelProperty(value = "养护单位名称")
    @TableField("MAINTENANCE_UNIT_AUDIT_")
    private String maintenanceUnitAudit;

    @ApiModelProperty(value = "养护单位Id")
    @TableField("MAINTENANCE_UNIT_AUDIT_ID_")
    private String maintenanceUnitAuditId;
    @ApiModelProperty(value = "养护单位Ids")
    @TableField("MAINTENANCE_UNIT_AUDIT_IDS_")
    private String maintenanceUnitAuditIds;

    @ApiModelProperty(value = "收方审核人Id")
    @TableField("RECEIVING_PARTY_REVIEW_ID_")
    private String receivingPartyReviewId;
    @ApiModelProperty(value = "收方审核人账号")
    @TableField("RECEIVING_PARTY_REVIEW_ACCOUNT_")
    private String receivingPartyReviewAccount;
    @ApiModelProperty(value = "收方审核人姓名")
    @TableField("RECEIVING_PARTY_REVIEW_")
    private String receivingPartyReview;

    @ApiModelProperty(value = "养护站审核人Id")
    @TableField("MAINTENANCE_STATION_ID_")
    private String maintenanceStationAuditId;

    @ApiModelProperty(value = "养护站审核人姓名")
    @TableField("MAINTENANCE_STATION_AUDIT_")
    private String maintenanceStationAudit;

    @ApiModelProperty(value = "养护站审核人账号")
    @TableField("MAINTENANCE_STATION_ACCOUNT_")
    private String maintenanceStationAuditAccount;

    @ApiModelProperty(value = "养护部审核id")
    @TableField("MAINTENANCE_DEPT_ID_")
    private String maintenanceDeptId;

    @ApiModelProperty(value = "养护部审核账号")
    @TableField("MAINTENANCE_DEPT_ACCOUNT_")
    private String maintenanceDeptAccount;

    @ApiModelProperty(value = "养护部审核名称")
    @TableField("MAINTENANCE_DEPT_")
    private String maintenanceDept;

    @ApiModelProperty(value = "所属路段Id(关联路段表ID)")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "工单号")
    @TableField("JOB_NUMBER_")
    private String jobNumber;

    @ApiModelProperty(value = "位置")
    @TableField("POSITION_")
    private String position;

    @ApiModelProperty(value = "类别CODE")
    @TableField("CATEGORY_ID_")
    private String categoryId;

    @ApiModelProperty(value = "细目类别CODE")
    @TableField("DETAILS_ID_")
    private String detailsId;

    @ApiModelProperty(value = "合同Id")
    @TableField("CONTRACT_ID_")
    private String contractId;

    @ApiModelProperty(value = "要求修复日期")
    @TableField("DEMAND_FINISH_TIME_")
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private LocalDate demandFinishTime;

    @ApiModelProperty(value = "签发人")
    @TableField("ISSUER_")
    private String issuer;

    @ApiModelProperty(value = "签发日期")
    @TableField("ISSUE_DATE_")
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private LocalDate issueDate;

    @ApiModelProperty(value = "任务内容")
    @TableField("TASK_CONTENT_")
    private String taskContent;

    @ApiModelProperty(value = "是否完成")
    @TableField("IS_COMPLETE_")
    private Integer isComplete;

    @ApiModelProperty(value = "施工结束时间")
    @TableField("CONSTRUCTION_FINISH_TIME_")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime constructionFinishTime;

    @ApiModelProperty(value = "施工起点桩号")
    @TableField("CONSTRUCTION_START_PEG_")
    private Float constructionStartPeg;

    @ApiModelProperty(value = "施工单位")
    @TableField("RESPONSIBLE_PERSON_")
    private String responsiblePerson;

    @ApiModelProperty(value = "施工描述")
    @TableField("CONSTRUCTION_DESC_")
    private String constructionDesc;

    @ApiModelProperty(value = "收方意见")
    @TableField("RECEIVER_OPINION_")
    private String receiverOpinion;


    @ApiModelProperty(value = "最终审核状态 0作废 1通过")
    @TableField("APPROVE_STATE_")
    private Integer approveState;

    @ApiModelProperty(value = "收方人")
    @TableField("RECEIVEROR_")
    private String receiveror;

    @ApiModelProperty(value = "收方日期")
    @TableField("RECEIVER_DATE_")
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private LocalDate receiverDate;

    @ApiModelProperty(value = "审核意见")
    @TableField("AUDIT_OPINION_")
    private String auditOpinion;

    @ApiModelProperty(value = "审核人")
    @TableField("AUDITOR_")
    private String auditor;

    @ApiModelProperty(value = "审核日期")
    @TableField("AUDIT_DATE_")
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private LocalDate auditDate;

    @ApiModelProperty(value = "总数量")
    @TableField("TOTAL_AMOUNT_")
    private Float totalAmount;

    @ApiModelProperty(value = "总金额")
    @TableField("TOTAL_MONEY_")
    private Float totalMoney;

    @ApiModelProperty(value = "状态")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "是否逾期  0 未逾期 1 已逾期")
    @TableField("OVERDUE_")
    private Integer overdue;

    @ApiModelProperty(value = "逾期天数")
    @TableField("OVERDUE_DAYS_")
    private String overdueDays;

    @ApiModelProperty(value = "是否结算")
    @TableField("IS_SETTLEMENT_")
    private Integer isSettlement;

    @ApiModelProperty(value = "合同是否结算")
    @TableField("IS_CONTRACT_SETTLEMENT_")
    private Integer isContractSettlement;

    @ApiModelProperty(value = "总合同金额")
    @TableField("TOTAL_CONTRACT_MONEY_")
    private Integer totalContractMoney;

    @ApiModelProperty(value = "流程实例ID")
    @TableField("PROC_INS_ID_")
    private String procInsId;

    @ApiModelProperty(value = "流程定义ID")
    @TableField("PROC_DEF_ID_")
    private String procDefId;

    @ApiModelProperty(value = "IS_PROCESS_")
    @TableField("IS_PROCESS_")
    private String isProcess;

    @ApiModelProperty(value = "状态值")
    @TableField("STATUS_VALUE_")
    private String statusValue;

    @ApiModelProperty(value = "类型值")
    @TableField("TYPE_VALUE_")
    private String typeValue;

    @ApiModelProperty(value = "施工开始桩号KM")
    @TableField("CONSTRUCTION_START_PEG_K_")
    private String constructionStartPegK;

    @ApiModelProperty(value = "施工结束桩号KM")
    @TableField("CONSTRUCTION_END_PEG_K_")
    private String constructionEndPegK;

    @ApiModelProperty(value = "施工位置或桩号")
    @TableField("CONSTRUCTION_POSITION_")
    private String constructionPosition;

    @ApiModelProperty(value = "工单项目金额")
    @TableField("WORK_ORDER_PROJECT_AMOUNT_")
    private Float workOrderProjectAmount;

    @ApiModelProperty(value = "附件列表ID")
    @TableField("FILE_IDS_")
    private String fileIds;

    @ApiModelProperty(value = "病害ID")
    @TableField("DISEASE_ID_")
    private String diseaseId;
    @ApiModelProperty(value = "病害照片列表ID")
    @TableField("DISEASE_PIC_IDS_")
    private String diseasePicIds;

    @ApiModelProperty(value = "施工照片列表ID")
    @TableField("CONSTRUCTION_PIC_IDS_")
    private String constructionPicIds;

    @ApiModelProperty(value = "公司NAME")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "结束时间")
    @TableField("END_TIME_")
    private LocalDate endTime;

    @ApiModelProperty(value = "路段信息实体")
    @TableField(exist = false)
    private Road road;


    @ApiModelProperty(value = "类别Name")
    @TableField(exist = false)
    private String categoryName;
    @ApiModelProperty(value = "细目类别Name")
    @TableField(exist = false)
    private String detailsName;

    @ApiModelProperty(value = "子科目编码")
    @TableField("SON_SUBJECT_CODE_")
    private String sonSubjectCode;

    @ApiModelProperty(value = "子科目名称")
    @TableField("SON_SUBJECT_NAME_")
    private String sonSubjectName;



}
