package com.artfess.yhxt.basedata.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 车辆设备表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2022-08-30
 */
@ApiModel(value="BizCarEquipment对象", description="车辆设备表")
@Data
public class BizCarEquipment extends BaseModel<BizCarEquipment> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "车牌")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "监控点编号")
    @TableField("camera_index_code_")
    private String cameraIndexCode;

    @ApiModelProperty(value = "监控点国标编号")
    @TableField("gb_index_code_")
    private String gbIndexCode;

    @ApiModelProperty(value = "所属设备编号")
    @TableField("device_index_code_")
    private String deviceIndexCode;

    @ApiModelProperty(value = "路段设备表id")
    @TableField("road_index_code_id_")
    private String roadIndexCodeId;

    @ApiModelProperty(value = "精度")
    @TableField("longitude")
    private String longitude;

    @ApiModelProperty(value = "维度")
    @TableField("latitude")
    private String latitude;

    @ApiModelProperty(value = "在线状态（0-不在线，1-在线")
    @TableField("status")
    private String status;

    @ApiModelProperty(value = "传输协议（0-UDP，1-TCP")
    @TableField("trans_type")
    private String transType;

    @ApiModelProperty(value = "创建人组织ID")
    @TableField("CREATE_ORG_ID_")
    private String createOrgId;

    @ApiModelProperty(value = "创建人组织名称")
    @TableField("CREATE_ORG_NAME_")
    private String createOrgName;

    @ApiModelProperty(value = "创建人单位ID")
    @TableField("CREATE_COMPANY_ID_")
    private String createCompanyId;

    @ApiModelProperty(value = "创建人单位名称")
    @TableField("CREATE_COMPANY_NAME_")
    private String createCompanyName;

    @ApiModelProperty(value = "创建时间")
    @TableField("CREATE_TIME_")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDate;

    @ApiModelProperty(value = "更新人ID")
    @TableField("UPDATE_BY_")
    private String updateBy;

    @ApiModelProperty(value = "更新人姓名")
    @TableField("UPDATE_NAME_")
    private String updateName;

    @ApiModelProperty(value = "更新人单位名称")
    @TableField("UPDATE_COMPANY_NAME_")
    private String updateCompanyName;

    @ApiModelProperty(value = "更新人单位ID")
    @TableField("UPDATE_COMPANY_ID_")
    private String updateCompanyId;

    @ApiModelProperty(value = "更新人组织ID")
    @TableField("UPDATE_ORG_ID_")
    private String updateOrgId;

    @ApiModelProperty(value = "更新人组织名称")
    @TableField("UPDATE_ORG_NAME_")
    private String updateOrgName;

    @ApiModelProperty(value = "更新时间")
    @TableField("UPDATE_TIME_")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime updateDate;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField("LAST_TIME_")
    private Long lastTime;

    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    @ApiModelProperty(value = "设备名称")
    @TableField("camera_name_")
    private String cameraName;


}
