package com.artfess.yhxt.basedata.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.manager.BizMaterialsManagementManager;
import com.artfess.yhxt.basedata.manager.BizStructureVehicleManager;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.model.*;
import com.artfess.yhxt.basedata.dao.BizEmergencyRescueManagementDao;
import com.artfess.yhxt.basedata.manager.BizEmergencyRescueManagementManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.basedata.vo.BizEmergencyRescueManagementVO;
import com.artfess.yhxt.statistics.vo.Org4MaintenanceVO;
import com.artfess.yhxt.statistics.vo.Org4RescueVO;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 救援点统计 服务实现类
 *
 * @author xmz
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-04-19
 */
@Service
public class BizEmergencyRescueManagementManagerImpl extends BaseManagerImpl<BizEmergencyRescueManagementDao, BizEmergencyRescueManagement> implements BizEmergencyRescueManagementManager {
    @Resource
    BaseContext baseContext;
    @Resource
    PermissionUtils permissionUtils;
    @Resource
    private BizStructureVehicleManager bizStructureVehicleManager;

    @Resource
    private OrgDao orgDao;

    @Resource
    private RoadManager roadManager;

    @Override
    public List<Org4RescueVO> getRescueCount() {
        String orgId ;
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId())&&!"0".equals(baseContext.getCurrentOrgId())){
            orgId = baseContext.getCurrentOrgId();
        }else {
            orgId = "1419863231459102720";
        }
        List<Org4RescueVO> lists = new ArrayList<>();

        List<Org> rtnList = new ArrayList<Org>();

        QueryWrapper<Org> rgQueryWrapper = new QueryWrapper<>();
        rgQueryWrapper.eq("is_dele_","0");
        List<Org> allList = orgDao.selectList(rgQueryWrapper);

        List<Org> list = getOrgChild(allList, orgId, rtnList);
        for (Org org: list){
            Org4RescueVO fvo = new Org4RescueVO();
            BeanUtils.copyProperties(org,fvo);
            lists.add(fvo);
        }
        lists = getChild(lists,orgId);


        return this.setCount(lists);
    }

    public List<Org4RescueVO> setCount(List<Org4RescueVO> list){
        // 获取迭代器
        Iterator<Org4RescueVO> it = list.iterator();

        while(it.hasNext()){
            Org4RescueVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<>();
            if (grade<4){
                QueryWrapper<Road> roadQueryWrapper = new QueryWrapper<>();
                roadQueryWrapper.like( "COMPANY_IDS_", orgVO.getId());
                roadList = roadManager.list(roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }else if (grade==4){
                QueryWrapper<Road> roadByNameQueryWrapper = new QueryWrapper<>();
                roadByNameQueryWrapper.eq("NAME_",orgVO.getName());
                roadList =
                        roadManager.list(roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size()>0){
                orgVO = this.newCount(roadList,orgVO);
            }else {
                it.remove();
            }
            if (orgVO.getChirldren().size()>0&&Integer.valueOf(orgVO.getGrade())<4){
                this.setCount(orgVO.getChirldren());
            }
        }
        return list;
    }

    public Org4RescueVO newCount(List<String> ids, Org4RescueVO orgVO) {

        QueryWrapper<BizEmergencyRescueManagement> wrapper = new QueryWrapper<>();
        wrapper.in("ROAD_SEGMENT_ID_", ids);
        List<BizEmergencyRescueManagement> rescues = this.list(wrapper);

        orgVO.setCountNum(rescues.size());
        orgVO.setPeopleNum(rescues.stream().mapToInt(BizEmergencyRescueManagement::getPersonnelQuantity).sum());

        if ("4".equals(orgVO.getGrade())){
            orgVO.setRoadSegmentId(ids.get(0));
        }

        return orgVO;
    }


    public static List<Org> getOrgChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            // 遍历出父id等于参数的id，add进子节点集合
            if (parentId.equals(org.getParentId())) {
                // 递归遍历下一级
                getOrgChild(orgList, org.getId(), rtnList);
                rtnList.add(org);
            }
        }
        return rtnList;
    }

    public static List<Org4RescueVO> getChild(List<Org4RescueVO> allList, String pCode) {
        List<Org4RescueVO> returnList = new ArrayList<>();
        for (Org4RescueVO entity : allList){
            if (pCode.equals(entity.getParentId())) {
                entity.setChirldren(getChild(allList, entity.getId()));
                returnList.add(entity);
            }
        }
        return returnList;
    }


    @Override
    public PageList<BizEmergencyRescueManagementVO> queryEmergencyRescueManagement(QueryFilter<BizEmergencyRescueManagement> queryFilter) {
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId())) {
//            queryFilter.addFilter("COMPANY_ID_", String.join("','", baseContext.getCurrentOrgId()), QueryOP.IN, FieldRelation.AND);
            permissionUtils.addPermission(queryFilter);
        }
        PageList<BizEmergencyRescueManagement> list = this.query(queryFilter);

        List<BizEmergencyRescueManagementVO> rerurnList = new ArrayList<>();
        for (BizEmergencyRescueManagement model : list.getRows()){
            BizEmergencyRescueManagementVO vo = new BizEmergencyRescueManagementVO();
            BeanUtils.copyProperties(model,vo);
            QueryWrapper<BizStructureVehicle> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("STRUCTURAL_ID_",vo.getId());
            vo.setStructureVehicles(bizStructureVehicleManager.list(queryWrapper));
            rerurnList.add(vo);
        }
        PageList<BizEmergencyRescueManagementVO> pageList = new PageList<>();
        pageList.setPage(list.getPage());
        pageList.setPageSize(list.getPageSize());
        pageList.setTotal(list.getTotal());
        pageList.setRows(rerurnList);
        return pageList;
    }
}
