/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.form.model.OperationButtonEntity;
import com.artfess.form.persistence.manager.OperationButtonManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/components/button"})
@Api(tags={"\u7cfb\u7edf\u6309\u94ae"})
@ApiGroup(group={"group_application"})
public class OperationButtonController
extends BaseController<OperationButtonManager, OperationButtonEntity> {
    private static final Logger log = LoggerFactory.getLogger(OperationButtonController.class);
    @Autowired
    private OperationButtonManager moduleButtonService;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u81ea\u5b9a\u4e49\u7cfb\u7edf\u6309\u94ae\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u81ea\u5b9a\u4e49\u7cfb\u7edf\u6309\u94ae\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    @ResponseBody
    public PageList<OperationButtonEntity> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<OperationButtonEntity> queryFilter) throws Exception {
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("ID_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return this.moduleButtonService.query(queryFilter);
    }

    @PostMapping(value={"/queryModuleButtonById"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2")
    @RequestMapping(value={"queryModuleButtonById"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    public OperationButtonEntity queryModuleButtonById(@ApiParam(value="\u6309\u94aeID") @RequestParam String id) {
        OperationButtonEntity m = (OperationButtonEntity)((Object)this.moduleButtonService.getById((Serializable)((Object)id)));
        return m;
    }

    @PostMapping(value={"/deleteModuleButton"})
    @ApiOperation(value="\u6839\u636eid\u6279\u91cf\u5220\u6309\u94ae")
    @RequestMapping(value={"deleteModuleButton"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiImplicitParam(name="ids", value="\u4e3b\u952eID\uff0c\u6279\u91cf\u5220\u9664\u662f\u7528\u9017\u53f7\u9694\u5f00", required=true)
    public CommonResult<String> deleteModuleButton(String ids) {
        if (!StringUtils.isNotBlank((CharSequence)ids)) {
            return new CommonResult(false, "ids\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<String> arrIds = Arrays.asList(ids.split(","));
        this.moduleButtonService.deleteModuleButton(arrIds);
        return new CommonResult(true, "\u6210\u529f");
    }

    @PostMapping(value={"/insertModuleButton"})
    @ApiOperation(value="\u6dfb\u52a0\u6309\u94ae")
    @RequestMapping(value={"insertModuleButton"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    public OperationButtonEntity insertModuleButton(@RequestBody OperationButtonEntity module) {
        if (module.getSn() == null) {
            module.setSn(this.moduleButtonService.queryNextSequence());
        }
        module.setFlag(1);
        module.setDelFlag(1);
        this.moduleButtonService.saveModuleButton(module);
        return module;
    }

    @PostMapping(value={"/updateModuleButton"})
    @ApiOperation(value="\u4fee\u6539\u6309\u94ae")
    @RequestMapping(value={"updateModuleButton"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    public OperationButtonEntity updateModuleButton(@RequestBody OperationButtonEntity module) {
        this.moduleButtonService.saveModuleButton(module);
        return module;
    }
}

