/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.statistics.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.statistics.manager.BaseDataStatisticsManager;
import com.artfess.yhxt.statistics.model.CamerasRequest;
import com.artfess.yhxt.statistics.model.PreviewURLsRequest;
import com.artfess.yhxt.statistics.vo.BaseDataParamVo;
import com.artfess.yhxt.statistics.vo.CompanyUserVo;
import com.artfess.yhxt.statistics.vo.CountMileageVo;
import com.artfess.yhxt.statistics.vo.CountRoadsideFacilities;
import com.artfess.yhxt.statistics.vo.CountVehicleVo;
import com.artfess.yhxt.statistics.vo.MaintenanceStationVo;
import com.artfess.yhxt.statistics.vo.MileageVo;
import com.artfess.yhxt.statistics.vo.VehicleQuantityVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/baseDataStatistics/v1/"})
@Api(tags={"\u57fa\u7840\u6570\u636e\u7edf\u8ba1\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
public class BaseDataStatisticsController {
    @Resource
    private BaseDataStatisticsManager baseDataStatisticsManager;

    @RequestMapping(value={"getBridgeStatistics"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6865\u6881\u7edf\u8ba1", httpMethod="POST")
    public Map<String, List> getBridgeStatistics(@ApiParam(name="map", value="roadSegmentId:\u8def\u6bb5id companyId:\u516c\u53f8id") @RequestBody Map<String, Object> map) {
        return this.baseDataStatisticsManager.getBridgeStatistics(map);
    }

    @RequestMapping(value={"getTunnelStatistics"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u96a7\u9053\u7edf\u8ba1", httpMethod="POST")
    public Map<String, List> getTunnelStatistics(@ApiParam(name="map", value="roadSegmentId:\u8def\u6bb5id companyId:\u516c\u53f8id") @RequestBody Map<String, Object> map) {
        return this.baseDataStatisticsManager.getTunnelStatistics(map);
    }

    @RequestMapping(value={"/export"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6865\u6881\u4e0a\u90e8\u7ed3\u6784\u6570\u636e\u5bfc\u51fa", httpMethod="POST", notes="\u6865\u6881\u4e0a\u90e8\u7ed3\u6784\u6570\u636e\u5bfc\u51fa")
    public void export(HttpServletResponse response, @ApiParam(name="map", value="roadSegmentId:\u8def\u6bb5id companyId:\u516c\u53f8id") @RequestBody Map<String, Object> map) throws Exception {
        this.baseDataStatisticsManager.export(response, map);
    }

    @RequestMapping(value={"/getAllStructureCount"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5404\u4e2a\u7ed3\u6784\u6570\u91cf", httpMethod="POST", notes="\u5404\u4e2a\u7ed3\u6784\u6570\u91cf")
    public Map<String, List> getAllStructureCount(@ApiParam(name="map", value="roadSegmentId:\u8def\u6bb5id companyId:\u516c\u53f8id routeId:\u8def\u7ebfID") @RequestBody Map<String, Object> map) throws Exception {
        return this.baseDataStatisticsManager.getAllStructureCount(map);
    }

    @RequestMapping(value={"/getSideSlopCompany"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5404\u4e2a\u5206\u516c\u53f8\u8fb9\u5761\u662f\u5426\u9ad8\u5371\u6570\u91cf\u67e5\u8be2", httpMethod="POST", notes="\u5404\u4e2a\u5206\u516c\u53f8\u8fb9\u5761\u662f\u5426\u9ad8\u5371\u6570\u91cf\u67e5\u8be2")
    public Map<String, List> getSideSlopCompany() throws Exception {
        return this.baseDataStatisticsManager.getSideSlopCompany();
    }

    @RequestMapping(value={"/getRoadsideFacilitiesCompany"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5404\u4e2a\u5206\u516c\u53f8\u6cbf\u7ebf\u8bbe\u65bd\u6570\u91cf\u67e5\u8be2", httpMethod="POST", notes="\u5404\u4e2a\u5206\u516c\u53f8\u6cbf\u7ebf\u8bbe\u65bd\u6570\u91cf\u67e5\u8be2")
    public Map<String, List> getRoadsideFacilitiesCompany() throws Exception {
        return this.baseDataStatisticsManager.getRoadsideFacilitiesCompany();
    }

    @RequestMapping(value={"/getRoadSectionCompany"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5404\u4e2a\u5206\u516c\u53f8\u6cbf\u7ebf\u8bbe\u65bd\u6570\u91cf\u67e5\u8be2", httpMethod="POST", notes="\u5404\u4e2a\u5206\u516c\u53f8\u6cbf\u7ebf\u8bbe\u65bd\u6570\u91cf\u67e5\u8be2")
    public Map<String, List> getRoadSectionCompany() throws Exception {
        return this.baseDataStatisticsManager.getRoadSectionCompany();
    }

    @RequestMapping(value={"/getBridgeCompany"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5404\u4e2a\u5206\u516c\u53f8\u6865\u6881\u6570\u91cf\u67e5\u8be2", httpMethod="POST", notes="\u5404\u4e2a\u5206\u516c\u53f8\u6865\u6881\u6570\u91cf\u67e5\u8be2")
    public Map<String, List> getBridgeCompany() throws Exception {
        return this.baseDataStatisticsManager.getBridgeCompany();
    }

    @RequestMapping(value={"/getTunnelCompany"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5404\u4e2a\u5206\u516c\u53f8\u96a7\u9053\u6570\u91cf\u67e5\u8be2", httpMethod="POST", notes="\u5404\u4e2a\u5206\u516c\u53f8\u96a7\u9053\u6570\u91cf\u67e5\u8be2")
    public Map<String, List> getTunnelCompany() throws Exception {
        return this.baseDataStatisticsManager.getTunnelCompany();
    }

    @RequestMapping(value={"/getCulvertCompany"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5404\u4e2a\u5206\u516c\u53f8\u6db5\u6d1e\u6570\u91cf\u67e5\u8be2", httpMethod="POST", notes="\u5404\u4e2a\u5206\u516c\u53f8\u96a7\u9053\u6570\u91cf\u67e5\u8be2")
    public Map<String, List> getCulvertCompany() throws Exception {
        return this.baseDataStatisticsManager.getCulvertCompany();
    }

    @RequestMapping(value={"/getBridgeTunnelCountRanking"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6865\u6881\u96a7\u9053\u6570\u91cf\u6392\u884c", httpMethod="POST", notes="\u6865\u6881\u96a7\u9053\u6570\u91cf\u6392\u884c")
    public Map<String, List> getBridgeTunnelCountRanking() throws Exception {
        return this.baseDataStatisticsManager.getBridgeTunnelCountRanking();
    }

    @RequestMapping(value={"/getMileage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u91cc\u7a0b\u6392\u884c\u7edf\u8ba1", httpMethod="POST", notes="\u91cc\u7a0b\u6392\u884c\u7edf\u8ba1")
    public List<MileageVo> getMileage(@RequestBody BaseDataParamVo baseDataParamVo) throws Exception {
        return this.baseDataStatisticsManager.getRoadMileageCount(baseDataParamVo);
    }

    @RequestMapping(value={"/getMaintenanceStation"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u517b\u62a4\u7ad9\u4e2a\u6570\u7edf\u8ba1", httpMethod="POST", notes="\u517b\u62a4\u7ad9\u4e2a\u6570\u7edf\u8ba1")
    public List<MaintenanceStationVo> getMaintenanceStation(@RequestBody BaseDataParamVo baseDataParamVo) throws Exception {
        return this.baseDataStatisticsManager.getMaintenanceStation(baseDataParamVo);
    }

    @RequestMapping(value={"/getUserCount"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5404\u4e2a\u516c\u53f8\u4eba\u5458\u67e5\u8be2", httpMethod="POST", notes="\u5404\u4e2a\u516c\u53f8\u4eba\u5458\u67e5\u8be2")
    public List<CompanyUserVo> getUserCount(@RequestBody BaseDataParamVo baseDataParamVo) throws Exception {
        return this.baseDataStatisticsManager.getUserCount(baseDataParamVo);
    }

    @RequestMapping(value={"/getRoad"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u8def\u6bb5", httpMethod="POST", notes="\u67e5\u8be2\u8def\u6bb5")
    public CommonResult<String> getRoad(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter queryFilter) throws Exception {
        return new CommonResult(this.baseDataStatisticsManager.getRoad(queryFilter));
    }

    @RequestMapping(value={"/getRoadsideFacilities"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u6cbf\u7ebf\u8bbe\u65bd", httpMethod="POST", notes="\u67e5\u8be2\u6cbf\u7ebf\u8bbe\u65bd")
    public CommonResult<String> getRoadsideFacilities(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter queryFilter) throws Exception {
        return new CommonResult(this.baseDataStatisticsManager.getRoadsideFacilities(queryFilter));
    }

    @RequestMapping(value={"/getSideSlop"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u8fb9\u5761", httpMethod="POST", notes="\u67e5\u8be2\u8fb9\u5761")
    public CommonResult<String> getSideSlop(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter queryFilter) throws Exception {
        return new CommonResult(this.baseDataStatisticsManager.getSideSlop(queryFilter));
    }

    @RequestMapping(value={"/getBridgeInformation"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u6865\u6881", httpMethod="POST", notes="\u67e5\u8be2\u6865\u6881")
    public CommonResult<String> getBridgeInformation(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter queryFilter) throws Exception {
        return new CommonResult(this.baseDataStatisticsManager.getBridgeInformation(queryFilter));
    }

    @RequestMapping(value={"/getTunnelInformation"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u96a7\u9053", httpMethod="POST", notes="\u67e5\u8be2\u96a7\u9053")
    public CommonResult<String> getTunnelInformation(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter queryFilter) throws Exception {
        return new CommonResult(this.baseDataStatisticsManager.getTunnelInformation(queryFilter));
    }

    @RequestMapping(value={"/getCulvertInformation"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u6db5\u6d1e", httpMethod="POST", notes="\u67e5\u8be2\u6db5\u6d1e")
    public CommonResult<String> getCulvertInformation(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter queryFilter) throws Exception {
        return new CommonResult(this.baseDataStatisticsManager.getCulvertInformation(queryFilter));
    }

    @RequestMapping(value={"/countRoadside"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6cbf\u7ebf\u8bbe\u65bd", httpMethod="POST", notes="\u6cbf\u7ebf\u8bbe\u65bd")
    public CommonResult<List<CountRoadsideFacilities>> countRoadside(@ApiParam(name="baseDataParamVo", value="\u67e5\u8be2\u4fe1\u606f") @RequestBody BaseDataParamVo baseDataParamVo) throws Exception {
        return new CommonResult(true, "\u67e5\u8be2\u6cbf\u7ebf\u8bbe\u65bd\u6210\u529f", this.baseDataStatisticsManager.countRoadsideFacilities(baseDataParamVo));
    }

    @RequestMapping(value={"/countVehicle"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u517b\u62a4\u8f66\u8f86\u7edf\u8ba1", httpMethod="POST", notes="\u8f66\u8f86\u7edf\u8ba1")
    public CommonResult<List<CountVehicleVo>> countVehicle(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter queryFilter) throws Exception {
        return new CommonResult(true, "\u67e5\u8be2\u6cbf\u7ebf\u8bbe\u65bd\u6210\u529f", this.baseDataStatisticsManager.countVehicle(queryFilter));
    }

    @RequestMapping(value={"/countAvgMileage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5e73\u5747\u91cc\u7a0b\u517b\u62a4\u8d39\u7528", httpMethod="POST", notes="\u5e73\u5747\u91cc\u7a0b\u517b\u62a4\u8d39\u7528")
    public CommonResult<List<CountMileageVo>> countAvgMileage(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter queryFilter) throws Exception {
        return new CommonResult(true, "\u67e5\u8be2\u5e73\u5747\u91cc\u7a0b\u517b\u62a4\u8d39\u7528\u6210\u529f", this.baseDataStatisticsManager.countAvgMileage(queryFilter));
    }

    @RequestMapping(value={"/countVehicleQuantity"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u517b\u62a4\u8f66\u8f86\u6570\u91cf\u7edf\u8ba1", httpMethod="POST", notes="\u517b\u62a4\u8f66\u8f86\u6570\u91cf\u7edf\u8ba1")
    public CommonResult<List<VehicleQuantityVo>> countVehicleQuantity() throws Exception {
        return new CommonResult(true, "\u67e5\u8be2\u6cbf\u7ebf\u8bbe\u65bd\u6210\u529f", this.baseDataStatisticsManager.countVehicleQuantity());
    }

    @RequestMapping(value={"/getPreviewURLs"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u76d1\u63a7\u70b9\u9884\u89c8\u53d6\u6d41URL", httpMethod="POST", notes="")
    public CommonResult<String> getPreviewURLs(@RequestBody PreviewURLsRequest previewURLsRequest) throws Exception {
        Map map = this.baseDataStatisticsManager.getPreviewURLs(previewURLsRequest);
        return new CommonResult(true, String.valueOf(map.get("msg")), (Object)String.valueOf(map.get("data")));
    }

    @RequestMapping(value={"/getCameras"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u76d1\u63a7\u70b9\u8d44\u6e90", httpMethod="POST", notes="")
    public CommonResult<String> getCameras(@RequestBody CamerasRequest camerasRequest) throws Exception {
        this.baseDataStatisticsManager.getCameras(camerasRequest);
        return new CommonResult(true, "\u5b8c\u6210");
    }
}

