/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.open.base.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.open.base.util.JwtCheckUtils;
import com.artfess.yhxt.statistics.manager.BaseDataStatisticsManager;
import com.artfess.yhxt.statistics.vo.BaseDataParamVo;
import com.artfess.yhxt.statistics.vo.CompanyUserVo;
import com.artfess.yhxt.statistics.vo.CountMileageVo;
import com.artfess.yhxt.statistics.vo.CountRoadsideFacilities;
import com.artfess.yhxt.statistics.vo.CountVehicleVo;
import com.artfess.yhxt.statistics.vo.MaintenanceStationVo;
import com.artfess.yhxt.statistics.vo.MileageVo;
import com.artfess.yhxt.statistics.vo.VehicleQuantityVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/server/"})
@Api(tags={"\u57fa\u7840\u6570\u636e\u7edf\u8ba1\u5bf9\u5916\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
public class BaseDataStatisticsOpenController {
    @Resource
    private BaseDataStatisticsManager baseDataStatisticsManager;
    @Resource
    private JwtCheckUtils jwtCheckUtils;

    @RequestMapping(value={"countBridgeStatistics"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6865\u6881\u7edf\u8ba1", httpMethod="POST")
    public CommonResult<Map> countBridgeStatistics(@ApiParam(name="map", value="roadSegmentId:\u8def\u6bb5id companyId:\u516c\u53f8id") @RequestBody Map<String, Object> map, @RequestParam String token) {
        boolean b = this.jwtCheckUtils.checkToken(token);
        if (b) {
            return new CommonResult(true, "\u83b7\u53d6\u6865\u6881\u7edf\u8ba1\u6210\u529f", this.baseDataStatisticsManager.getBridgeStatistics(map));
        }
        return new CommonResult(false, "Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6", null);
    }

    @RequestMapping(value={"countTunnelStatistics"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u96a7\u9053\u7edf\u8ba1", httpMethod="POST")
    public CommonResult<Map> countTunnelStatistics(@ApiParam(name="map", value="roadSegmentId:\u8def\u6bb5id companyId:\u516c\u53f8id") @RequestBody Map<String, Object> map, @RequestParam String token) {
        boolean b = this.jwtCheckUtils.checkToken(token);
        if (b) {
            return new CommonResult(true, "\u83b7\u53d6\u96a7\u9053\u7edf\u8ba1\u6210\u529f", this.baseDataStatisticsManager.getTunnelStatistics(map));
        }
        return new CommonResult(false, "Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6", null);
    }

    @RequestMapping(value={"/countAllStructureCount"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5404\u4e2a\u7ed3\u6784\u6570\u91cf", httpMethod="POST", notes="\u5404\u4e2a\u7ed3\u6784\u6570\u91cf")
    public CommonResult<Map> countAllStructureCount(@ApiParam(name="map", value="roadSegmentId:\u8def\u6bb5id companyId:\u516c\u53f8id routeId:\u8def\u7ebfID") @RequestBody Map<String, Object> map, @RequestParam String token) throws Exception {
        boolean b = this.jwtCheckUtils.checkToken(token);
        if (b) {
            return new CommonResult(true, "\u83b7\u53d6\u5404\u4e2a\u7ed3\u6784\u6570\u91cf\u6210\u529f", this.baseDataStatisticsManager.getAllStructureCount(map));
        }
        return new CommonResult(false, "Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6", null);
    }

    @RequestMapping(value={"/countMileage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u91cc\u7a0b\u6392\u884c\u7edf\u8ba1", httpMethod="POST", notes="\u91cc\u7a0b\u6392\u884c\u7edf\u8ba1")
    public CommonResult<List<MileageVo>> countMileage(@RequestBody BaseDataParamVo baseDataParamVo, @RequestParam String token) throws Exception {
        boolean b = this.jwtCheckUtils.checkToken(token);
        if (b) {
            return new CommonResult(true, "\u83b7\u53d6\u91cc\u7a0b\u6392\u884c\u6210\u529f", this.baseDataStatisticsManager.getRoadMileageCount(baseDataParamVo));
        }
        return new CommonResult(false, "Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6", null);
    }

    @RequestMapping(value={"/countMaintenanceStation"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u517b\u62a4\u7ad9\u4e2a\u6570\u7edf\u8ba1", httpMethod="POST", notes="\u517b\u62a4\u7ad9\u4e2a\u6570\u7edf\u8ba1")
    public CommonResult<List<MaintenanceStationVo>> countMaintenanceStation(@RequestBody BaseDataParamVo baseDataParamVo, @RequestParam String token) throws Exception {
        boolean b = this.jwtCheckUtils.checkToken(token);
        if (b) {
            return new CommonResult(true, "\u83b7\u53d6\u517b\u62a4\u7ad9\u4e2a\u6570\u6210\u529f", this.baseDataStatisticsManager.getMaintenanceStation(baseDataParamVo));
        }
        return new CommonResult(false, "Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6", null);
    }

    @RequestMapping(value={"/countUserCount"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5404\u4e2a\u516c\u53f8\u4eba\u5458\u6570\u67e5\u8be2", httpMethod="POST", notes="\u5404\u4e2a\u516c\u53f8\u4eba\u5458\u6570\u67e5\u8be2")
    public CommonResult<List<CompanyUserVo>> countUserCount(@RequestBody BaseDataParamVo baseDataParamVo, @RequestParam String token) throws Exception {
        boolean b = this.jwtCheckUtils.checkToken(token);
        if (b) {
            return new CommonResult(true, "\u83b7\u53d6\u5404\u4e2a\u516c\u53f8\u4eba\u5458\u6570\u6210\u529f", this.baseDataStatisticsManager.getUserCount(baseDataParamVo));
        }
        return new CommonResult(false, "Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6", null);
    }

    @RequestMapping(value={"/countRoadside"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6cbf\u7ebf\u8bbe\u65bd", httpMethod="POST", notes="\u6cbf\u7ebf\u8bbe\u65bd")
    public CommonResult<List<CountRoadsideFacilities>> countRoadside(@RequestBody BaseDataParamVo baseDataParamVo, @RequestParam String token) throws Exception {
        boolean b = this.jwtCheckUtils.checkToken(token);
        if (b) {
            return new CommonResult(true, "\u83b7\u53d6\u6cbf\u7ebf\u8bbe\u65bd\u6210\u529f", this.baseDataStatisticsManager.countRoadsideFacilities(baseDataParamVo));
        }
        return new CommonResult(false, "Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6", null);
    }

    @RequestMapping(value={"/countVehicle"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u517b\u62a4\u8f66\u8f86\u7edf\u8ba1", httpMethod="POST", notes="\u517b\u62a4\u8f66\u8f86\u7edf\u8ba1")
    public CommonResult<List<CountVehicleVo>> countVehicle(@RequestBody QueryFilter queryFilter, @RequestParam String token) throws Exception {
        boolean b = this.jwtCheckUtils.checkToken(token);
        if (b) {
            return new CommonResult(true, "\u83b7\u53d6\u517b\u62a4\u8f66\u8f86\u7edf\u8ba1\u6210\u529f", this.baseDataStatisticsManager.countVehicle(queryFilter));
        }
        return new CommonResult(false, "Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6", null);
    }

    @RequestMapping(value={"/countVehicleQuantity"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u517b\u62a4\u8f66\u8f86\u6570\u91cf", httpMethod="POST", notes="\u83b7\u53d6\u517b\u62a4\u8f66\u8f86\u6570\u91cf")
    public CommonResult<List<VehicleQuantityVo>> countVehicleQuantity(@RequestBody QueryFilter queryFilter, @RequestParam String token) throws Exception {
        boolean b = this.jwtCheckUtils.checkToken(token);
        if (b) {
            return new CommonResult(true, "\u83b7\u53d6\u517b\u62a4\u8f66\u8f86\u6570\u91cf\u6210\u529f", this.baseDataStatisticsManager.countVehicleQuantity());
        }
        return new CommonResult(false, "Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6", null);
    }

    @RequestMapping(value={"/countAvgMileage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5e73\u5747\u91cc\u7a0b\u517b\u62a4\u8d39\u7528", httpMethod="POST", notes="\u5e73\u5747\u91cc\u7a0b\u517b\u62a4\u8d39\u7528")
    public CommonResult<List<CountMileageVo>> countAvgMileage(@RequestBody QueryFilter queryFilter, @RequestParam String token) throws Exception {
        boolean b = this.jwtCheckUtils.checkToken(token);
        if (b) {
            return new CommonResult(true, "\u83b7\u53d6\u5e73\u5747\u91cc\u7a0b\u517b\u62a4\u8d39\u7528\u6210\u529f", this.baseDataStatisticsManager.countAvgMileage(queryFilter));
        }
        return new CommonResult(false, "Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6", null);
    }
}

