/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.disease.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.disease.dao.DiseaseDao;
import com.artfess.yhxt.disease.manager.DiseaseManager;
import com.artfess.yhxt.disease.model.Disease;
import com.artfess.yhxt.disease.vo.DiseaseReportVO;
import com.artfess.yhxt.statistics.vo.Org4DiseaseVO;
import com.artfess.yhxt.statistics.vo.OrgDisease4AppVO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DiseaseManagerImpl
extends BaseManagerImpl<DiseaseDao, Disease>
implements DiseaseManager {
    @Resource
    private AccessoryManager accessoryManager;
    @Resource
    private OrgDao orgDao;
    @Resource
    BaseContext baseContext;
    @Resource
    private RoadManager roadManager;

    @Override
    public List<DiseaseReportVO> diseaseReport(String year, String orgId) {
        ArrayList<DiseaseReportVO> vos = new ArrayList<DiseaseReportVO>();
        QueryWrapper roadWrapper = new QueryWrapper();
        roadWrapper.eq((Object)"IS_DELE_", (Object)"0");
        roadWrapper.like((Object)"COMPANY_IDS_", (Object)orgId);
        List roads = this.roadManager.list((Wrapper)roadWrapper);
        for (Road road : roads) {
            DiseaseReportVO vo = new DiseaseReportVO();
            vo.setRoadName(road.getName());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"ROAD_ID_", (Object)road.getId());
            queryWrapper.apply("year(CHECK_DATE_) = {0}", new Object[]{year});
            List list = this.list((Wrapper)queryWrapper);
            if (list.size() > 0) {
                vo.setDiseaseCount(list.size());
                vo.setDailyCount(list.stream().filter(p -> p.getType() == 1 || p.getType() == 2).collect(Collectors.toList()).size());
                vo.setOftenCount(list.stream().filter(p -> p.getType() == 3 || p.getType() == 4 || p.getType() == 5 || p.getType() == 6).collect(Collectors.toList()).size());
                vo.setRegularCount(list.stream().filter(p -> p.getType() == 7 || p.getType() == 8 || p.getType() == 9 || p.getType() == 10).collect(Collectors.toList()).size());
                vo.setTemporaryCount(list.stream().filter(p -> p.getType() == 11).collect(Collectors.toList()).size());
                vo.setBedCount(list.stream().filter(p -> null != p.getDiseaseCategory() && p.getDiseaseCategory().equals("1")).collect(Collectors.toList()).size());
                vo.setRoadCount(list.stream().filter(p -> null != p.getDiseaseCategory() && p.getDiseaseCategory().equals("2")).collect(Collectors.toList()).size());
                vo.setBridgeCount(list.stream().filter(p -> null != p.getDiseaseCategory() && p.getDiseaseCategory().equals("3")).collect(Collectors.toList()).size());
                vo.setTunnelCount(list.stream().filter(p -> null != p.getDiseaseCategory() && p.getDiseaseCategory().equals("4")).collect(Collectors.toList()).size());
                vo.setCulvertCount(list.stream().filter(p -> null != p.getDiseaseCategory() && p.getDiseaseCategory().equals("5")).collect(Collectors.toList()).size());
                vo.setHighWallCount(list.stream().filter(p -> null != p.getDiseaseCategory() && p.getDiseaseCategory().equals("6")).collect(Collectors.toList()).size());
                vo.setGreenCount(list.stream().filter(p -> null != p.getDiseaseCategory() && p.getDiseaseCategory().equals("7")).collect(Collectors.toList()).size());
                vo.setUntreatedCount(list.stream().filter(p -> null != p.getDiseaseCategory() && p.getHandlingSituation() != 2).collect(Collectors.toList()).size());
                vo.setFinishCount(list.stream().filter(p -> null != p.getDiseaseCategory() && p.getHandlingSituation() == 2).collect(Collectors.toList()).size());
                if (vo.getFinishCount() > 0) {
                    vo.setFinishRate(new BigDecimal(vo.getFinishCount()).divide(new BigDecimal(list.size()), 2, 0));
                } else {
                    vo.setFinishRate(new BigDecimal(0));
                }
                vo.setOrderCount(list.stream().filter(p -> StringUtils.isNotEmpty((CharSequence)p.getJobNumber())).collect(Collectors.toList()).size());
                List finishList = list.stream().filter(p -> null != p.getDiseaseCategory() && p.getHandlingSituation() == 2).collect(Collectors.toList());
                long minutes = 0L;
                for (Disease disease : finishList) {
                    if (null == disease.getHandledTimeStart() || null == disease.getHandledTimeEnd()) continue;
                    Duration dur = Duration.between(disease.getHandledTimeStart(), disease.getHandledTimeEnd());
                    minutes += dur.toMinutes();
                }
                vo.setHandleTime(this.turnDayHourMinuteString(new BigDecimal(minutes).divide(new BigDecimal(list.size()), 0, 0).longValue()));
            } else {
                vo.setFinishRate(new BigDecimal(0));
                vo.setHandleTime("0\u5206\u949f");
            }
            vos.add(vo);
        }
        return vos;
    }

    public String turnDayHourMinuteString(long minute) {
        if (0L == minute) {
            return "0\u5206\u949f";
        }
        if (0L < minute && minute < 60L) {
            return minute + "\u5206\u949f";
        }
        if (60L <= minute && minute < 1440L) {
            if (minute % 60L == 0L) {
                long h = minute / 60L;
                return h + "\u5c0f\u65f6";
            }
            long h = minute / 60L;
            long m = minute % 60L;
            return h + "\u5c0f\u65f6" + m + "\u5206\u949f";
        }
        if (minute >= 1440L) {
            long d = minute / 60L / 24L;
            long h = minute / 60L % 24L;
            long m = minute % 60L;
            String s1 = null;
            if (d > 0L) {
                s1 = d + "\u5929";
            }
            if (h >= 1L) {
                s1 = s1 + h + "\u5c0f\u65f6";
            }
            if (m > 0L) {
                s1 = s1 + m + "\u5206\u949f";
            }
            return s1;
        }
        return null;
    }

    @Override
    public OrgDisease4AppVO getDisease4AppCount(String level, String dimension, String date) {
        if ("0".equals(level)) {
            dimension = "1419863231459102720";
        }
        Org org = this.orgDao.get((Serializable)((Object)dimension));
        OrgDisease4AppVO fvo = new OrgDisease4AppVO();
        BeanUtils.copyProperties((Object)org, (Object)fvo);
        return this.setCount4App(fvo, date);
    }

    public OrgDisease4AppVO setCount4App(OrgDisease4AppVO orgVO, String year) {
        Integer grade = Integer.valueOf(orgVO.getGrade());
        List<String> roadList = new ArrayList<String>();
        if (grade < 4) {
            QueryWrapper roadQueryWrapper = new QueryWrapper();
            roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
            roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
        } else if (grade == 4) {
            QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
            roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
            roadList = this.roadManager.list((Wrapper)roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
        }
        if (roadList.size() > 0) {
            orgVO = this.diseaseCount4App(roadList, orgVO, year);
        } else {
            orgVO.setCount(0);
        }
        return orgVO;
    }

    public OrgDisease4AppVO diseaseCount4App(List<String> ids, OrgDisease4AppVO orgVO, String date) {
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        orderQueryWrapper.in((Object)"ROAD_ID_", ids);
        orderQueryWrapper.apply("date_format(CREATE_TIME_,'%Y-%m-%d') = {0}", new Object[]{date});
        List list = this.list((Wrapper)orderQueryWrapper);
        if (list.size() > 0) {
            List r0List = list.stream().filter(student -> Objects.equals(student.getHandlingSituation(), 0)).collect(Collectors.toList());
            orgVO.setRunCount(r0List.size());
            List r1List = list.stream().filter(student -> Objects.equals(student.getHandlingSituation(), 1)).collect(Collectors.toList());
            orgVO.setFinishCount(r1List.size());
            orgVO.setCount(list.size());
        } else {
            orgVO.setCount(0);
        }
        return orgVO;
    }

    @Override
    public List<Org4DiseaseVO> getDiseaseCount(String year) {
        String orgId = StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId()) && !"0".equals(this.baseContext.getCurrentOrgId()) ? this.baseContext.getCurrentOrgId() : "1419863231459102720";
        List<Org4DiseaseVO> lists = new ArrayList<Org4DiseaseVO>();
        ArrayList<Org> rtnList = new ArrayList<Org>();
        QueryWrapper rgQueryWrapper = new QueryWrapper();
        rgQueryWrapper.eq((Object)"is_dele_", (Object)"0");
        List allList = this.orgDao.selectList((Wrapper)rgQueryWrapper);
        List<Org> list = DiseaseManagerImpl.getOrgChild(allList, orgId, rtnList);
        for (Org org : list) {
            Org4DiseaseVO fvo = new Org4DiseaseVO();
            BeanUtils.copyProperties((Object)org, (Object)fvo);
            lists.add(fvo);
        }
        lists = DiseaseManagerImpl.getChild(lists, orgId);
        return this.setCount(lists, year);
    }

    public List<Org4DiseaseVO> setCount(List<Org4DiseaseVO> list, String year) {
        Iterator<Org4DiseaseVO> it = list.iterator();
        while (it.hasNext()) {
            Org4DiseaseVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<String>();
            if (grade < 4) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
                roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            } else if (grade == 4) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
                roadList = this.roadManager.list((Wrapper)roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size() > 0) {
                orgVO = this.newCountDisease(roadList, orgVO, year);
            } else {
                it.remove();
            }
            if (orgVO.getChirldren().size() <= 0 || Integer.valueOf(orgVO.getGrade()) >= 4) continue;
            this.setCount(orgVO.getChirldren(), year);
        }
        return list;
    }

    public Org4DiseaseVO newCountDisease(List<String> ids, Org4DiseaseVO orgVO, String year) {
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        orderQueryWrapper.in((Object)"ROAD_ID_", ids);
        orderQueryWrapper.apply("year(CHECK_DATE_) = {0}", new Object[]{year});
        List list = this.list((Wrapper)orderQueryWrapper);
        if (list.size() > 0) {
            List r0List = list.stream().filter(e -> e.getHandlingSituation().equals(0) && e.getTemporary().equals(0)).collect(Collectors.toList());
            orgVO.setRunCount(r0List.size());
            List r1List = list.stream().filter(student -> Objects.equals(student.getHandlingSituation(), 2)).collect(Collectors.toList());
            orgVO.setFinishCount(r1List.size());
            List r2List = list.stream().filter(student -> Objects.equals(student.getTemporary(), 1)).collect(Collectors.toList());
            orgVO.setTemporaryCount(r2List.size());
            if ("4".equals(orgVO.getGrade())) {
                orgVO.setRoadSegmentId(((Disease)((Object)list.get(0))).getRoadId());
            }
        } else {
            orgVO.setTemporaryCount(0);
            orgVO.setFinishCount(0);
            orgVO.setRunCount(0);
        }
        return orgVO;
    }

    public static List<Org> getOrgChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            if (!parentId.equals(org.getParentId())) continue;
            DiseaseManagerImpl.getOrgChild(orgList, org.getId(), rtnList);
            rtnList.add(org);
        }
        return rtnList;
    }

    public static List<Org4DiseaseVO> getChild(List<Org4DiseaseVO> allList, String pCode) {
        ArrayList<Org4DiseaseVO> returnList = new ArrayList<Org4DiseaseVO>();
        for (Org4DiseaseVO entity : allList) {
            if (!pCode.equals(entity.getParentId())) continue;
            entity.setChirldren(DiseaseManagerImpl.getChild(allList, entity.getId()));
            returnList.add(entity);
        }
        return returnList;
    }

    @Override
    public PageList<Disease> queryDisease(QueryFilter<Disease> queryFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        IPage<Disease> result = ((DiseaseDao)this.baseMapper).getDisease((IPage<Disease>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<Disease>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public Accessory minioDiseaseUpload(MultipartFile file, String sourceId) {
        return this.accessoryManager.minIoUpload(file, "drawing", "", "yhxt", sourceId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void minioDiseaseDel(List<String> asList) {
        asList.forEach(s -> this.accessoryManager.minIoRemoveFile((String)s, "drawing", "yhxt"));
    }

    @Override
    public void minIoDiseaseDownFile(String ids, HttpServletResponse response) throws Exception {
        this.accessoryManager.minIoDownFile(ids, "drawing", "download/drawing", "yhxt", response);
    }

    @Override
    public PageList<Disease> getJsonBridgeDiseaseCheck(QueryFilter<Disease> queryFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        IPage<Disease> result = null;
        if ((Integer)queryFilter.getParams().get("flag") == 0) {
            result = ((DiseaseDao)this.baseMapper).getJsonDiseaseOftenCheck((IPage<Disease>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<Disease>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        } else if ((Integer)queryFilter.getParams().get("flag") == 1) {
            result = ((DiseaseDao)this.baseMapper).getJsonDiseaseRegularCheck((IPage<Disease>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<Disease>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        }
        return new PageList(result);
    }

    @Override
    public PageList<Disease> getJsonCulvertDiseaseCheck(QueryFilter<Disease> queryFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        IPage<Disease> result = null;
        if ((Integer)queryFilter.getParams().get("flag") == 0) {
            result = ((DiseaseDao)this.baseMapper).getCulvertDiseaseOftenCheck((IPage<Disease>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<Disease>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        } else if ((Integer)queryFilter.getParams().get("flag") == 1) {
            result = ((DiseaseDao)this.baseMapper).getCulvertDiseaseRegularCheck((IPage<Disease>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<Disease>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        }
        return new PageList(result);
    }

    @Override
    public PageList<Disease> getJsonTunnelDiseaseCheck(QueryFilter<Disease> queryFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        IPage<Disease> result = null;
        if ((Integer)queryFilter.getParams().get("flag") == 0) {
            result = ((DiseaseDao)this.baseMapper).getTunnelDiseaseOftenCheck((IPage<Disease>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<Disease>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        } else if ((Integer)queryFilter.getParams().get("flag") == 1) {
            result = ((DiseaseDao)this.baseMapper).getTunnelDiseaseRegularCheck((IPage<Disease>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<Disease>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        }
        return new PageList(result);
    }

    @Override
    public PageList<Disease> getJsonSideDiseaseCheck(QueryFilter<Disease> queryFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        IPage<Disease> result = null;
        Integer flag = (Integer)queryFilter.getParams().get("flag");
        if (flag == 0) {
            result = ((DiseaseDao)this.baseMapper).getSideDiseaseOftenCheck((IPage<Disease>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<Disease>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        } else if (flag == 1) {
            result = ((DiseaseDao)this.baseMapper).getSideDiseaseRegularCheck((IPage<Disease>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<Disease>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        }
        return new PageList(result);
    }

    @Override
    public LocalDateTime calculateDeadline(LocalDateTime checkDate) {
        String days = ((DiseaseDao)this.baseMapper).diseaseTimeDays();
        return checkDate.plusDays(Long.parseLong(days));
    }

    @Override
    public void saveDiseaseVo(Disease disease) {
        this.create((Model)disease);
        String id = disease.getId();
        List<Accessory> accessoryList = disease.getAccessories();
        if (accessoryList != null && accessoryList.size() > 0) {
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveBatch(accessoryList);
        }
    }

    @Override
    public void updateDiseaseVo(Disease disease) {
        this.update((Model)disease);
        String id = disease.getId();
        List<Accessory> accessoryList = disease.getAccessories();
        if (accessoryList.size() > 0) {
            this.accessoryManager.delAccessoryBySourceId(id);
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveOrUpdateBatch(accessoryList);
        }
    }

    @Override
    public Disease getByIdDisease(String id) {
        Disease disease = (Disease)((Object)this.getById((Serializable)((Object)id)));
        List<Accessory> accessories = this.accessoryManager.getAccessoryBySourceId(id);
        disease.setAccessories(accessories);
        return disease;
    }
}

