/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.check.regular.manager.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.manager.BizCulvertInformationManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.basedata.model.BizCulvertInformation;
import com.artfess.yhxt.check.detail.dao.CulvertOftenCheckDetailDao;
import com.artfess.yhxt.check.detail.manager.CulvertOftenCheckDetailManager;
import com.artfess.yhxt.check.detail.model.CulvertOftenCheckDetail;
import com.artfess.yhxt.check.regular.dao.CulvertOftenCheckDao;
import com.artfess.yhxt.check.regular.manager.CulvertOftenCheckManager;
import com.artfess.yhxt.check.regular.model.CulvertOftenCheck;
import com.artfess.yhxt.check.regular.vo.CulvertOftenCheckVo;
import com.artfess.yhxt.statistics.dao.SiteStatisticDao;
import com.artfess.yhxt.statistics.model.SiteStatistic;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CulvertOftenCheckManagerImpl
extends BaseManagerImpl<CulvertOftenCheckDao, CulvertOftenCheck>
implements CulvertOftenCheckManager {
    @Resource
    private CulvertOftenCheckDetailManager culvertOftenCheckDetailManager;
    @Resource
    private CulvertOftenCheckDetailDao culvertOftenCheckDetailDao;
    @Resource
    private BizCulvertInformationManager culvertInformationManager;
    @Resource
    private SiteStatisticDao siteStatisticDao;
    @Resource
    private AccessoryManager accessoryManager;

    @Override
    public PageList<CulvertOftenCheck> queryCulvertOftenCheck(QueryFilter<CulvertOftenCheck> queryFilter) {
        List sorter;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (null == (sorter = queryFilter.getSorter()) || sorter.isEmpty()) {
            sorter.add(new FieldSort("CHECK_DATE_", Direction.DESC));
            queryFilter.setSorter(sorter);
        }
        IPage<CulvertOftenCheck> result = ((CulvertOftenCheckDao)this.baseMapper).queryCulvertOftenCheck((IPage<CulvertOftenCheck>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<CulvertOftenCheck>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public void saveCulvertOftenCheck(CulvertOftenCheckVo vo) {
        CulvertOftenCheck culvertOftenCheck = vo.getCulvertOftenCheck();
        culvertOftenCheck.setIsDele("0");
        this.create((Model)culvertOftenCheck);
        vo.getCulvertOftenCheckDetails().forEach(s -> {
            s.setId(null);
            s.setCulvertOftenCheckId(culvertOftenCheck.getId());
            this.culvertOftenCheckDetailManager.saveOrUpdate(s);
        });
        List<Accessory> accessoryList = vo.getAccessories();
        String id = culvertOftenCheck.getId();
        if (null != accessoryList && accessoryList.size() > 0) {
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveBatch(accessoryList);
        }
    }

    @Override
    public void updateCulvertOftenCheck(CulvertOftenCheckVo vo) {
        CulvertOftenCheck culvertOftenCheck = vo.getCulvertOftenCheck();
        this.update((Model)culvertOftenCheck);
        vo.getCulvertOftenCheckDetails().forEach(s -> {
            s.setCulvertOftenCheckId(culvertOftenCheck.getId());
            this.culvertOftenCheckDetailManager.saveOrUpdate(s);
        });
        List<Accessory> accessoryList = vo.getAccessories();
        String id = culvertOftenCheck.getId();
        if (null != accessoryList && accessoryList.size() > 0) {
            this.accessoryManager.delAccessoryBySourceId(id);
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveOrUpdateBatch(accessoryList);
        }
    }

    @Override
    public CulvertOftenCheckVo getCulvertOftenCheckById(String id) {
        CulvertOftenCheckVo checkVo = new CulvertOftenCheckVo();
        CulvertOftenCheck culvertOftenCheck = (CulvertOftenCheck)((Object)this.getById((Serializable)((Object)id)));
        if (culvertOftenCheck != null) {
            checkVo.setCulvertOftenCheck(culvertOftenCheck);
            QueryWrapper queryWrapper = new QueryWrapper();
            if (StringUtils.isNotBlank((CharSequence)culvertOftenCheck.getId())) {
                queryWrapper.eq((Object)"CULVERT_OFTEN_CHECK_ID_", (Object)culvertOftenCheck.getId());
                List sideSlopeOftenCheckDetailList = this.culvertOftenCheckDetailDao.selectList((Wrapper)queryWrapper);
                checkVo.setCulvertOftenCheckDetails(sideSlopeOftenCheckDetailList);
            }
            List<Accessory> accessories = this.accessoryManager.getAccessoryBySourceId(id);
            checkVo.setAccessories(accessories);
        }
        return checkVo;
    }

    @Override
    public void importExcelData(MultipartFile file, CulvertOftenCheck parseObject) {
        Assert.notNull((Object)((Object)parseObject), (String)"\u4e3b\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        try (InputStream inputStream = file.getInputStream();){
            List data = ExcelImportUtil.importExcel((InputStream)inputStream, CulvertOftenCheckDetail.class, (ImportParams)new ImportParams());
            CulvertOftenCheckVo vo = new CulvertOftenCheckVo();
            vo.setCulvertOftenCheck(parseObject);
            vo.setCulvertOftenCheckDetails(data);
            this.saveCulvertOftenCheck(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveSiteStatistic(CulvertOftenCheck culvertOftenCheck) {
        SiteStatistic siteStatistic = new SiteStatistic();
        String checkId = culvertOftenCheck.getCulvertId();
        BizCulvertInformation culvertInformation = (BizCulvertInformation)((Object)this.culvertInformationManager.getById((Serializable)((Object)checkId)));
        siteStatistic.setRoadSegmentId(culvertInformation.getRoadSegmentId());
        siteStatistic.setRoadSegmentName(culvertInformation.getRoadSegmentName());
        siteStatistic.setCompanyId(culvertOftenCheck.getCompanyId());
        siteStatistic.setCompanyName(culvertOftenCheck.getCompanyName());
        siteStatistic.setSiteCode(5);
        siteStatistic.setSiteName("\u6db5\u6d1e\u7ecf\u5e38\u68c0\u67e5");
        Date checkDate = culvertOftenCheck.getCheckDate();
        String month = new SimpleDateFormat("yyyy-MM").format(checkDate);
        siteStatistic.setAccDateMonth(month);
        String year = new SimpleDateFormat("yyyy").format(checkDate);
        siteStatistic.setAccDateYear(year);
        siteStatistic.setComplete("1");
        siteStatistic.setCompleteNo("0");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)month), (Object)"ACC_DATE_MONTH_", (Object)month);
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)year), (Object)"ACC_DATE_YEAR_", (Object)year);
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)culvertInformation.getRoadSegmentId()), (Object)"ROAD_SEGMENT_ID_", (Object)culvertInformation.getRoadSegmentId());
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)culvertInformation.getCompanyId()), (Object)"COMPANY_ID_", (Object)culvertInformation.getCompanyId());
        queryWrapper.eq((Object)"SITE_CODE_", (Object)5);
        queryWrapper.eq((Object)"SITE_NAME_", (Object)"\u6db5\u6d1e\u7ecf\u5e38\u68c0\u67e5");
        List siteStatistics = this.siteStatisticDao.selectList((Wrapper)queryWrapper);
        if (siteStatistics.size() > 0) {
            SiteStatistic statistic = (SiteStatistic)((Object)siteStatistics.get(0));
            statistic.setComplete(String.valueOf(Integer.parseInt(statistic.getCompleteNo()) + 1));
            this.siteStatisticDao.update((Object)siteStatistic, (Wrapper)queryWrapper);
        } else {
            this.siteStatisticDao.insert((Object)siteStatistic);
        }
    }
}

