/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.assessment.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.poi.Excel;
import com.artfess.poi.editor.IFontEditor;
import com.artfess.poi.style.Align;
import com.artfess.poi.style.BorderStyle;
import com.artfess.poi.style.Color;
import com.artfess.poi.style.font.BoldWeight;
import com.artfess.poi.style.font.Font;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.yhxt.assessment.dao.CuringAssessmentDao;
import com.artfess.yhxt.assessment.manager.CuringAssessmentDetailedManager;
import com.artfess.yhxt.assessment.manager.CuringAssessmentManager;
import com.artfess.yhxt.assessment.model.CuringAssessment;
import com.artfess.yhxt.assessment.model.CuringAssessmentDetailed;
import com.artfess.yhxt.assessment.vo.CuringAssessmentIVo;
import com.artfess.yhxt.contract.model.BillOfQuantities;
import com.artfess.yhxt.contract.model.Contract;
import com.artfess.yhxt.contract.model.WorkOrderInformation;
import com.artfess.yhxt.contract.vo.WorkOrderDiseaseVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.stereotype.Service;

@Service
public class CuringAssessmentManagerImpl
extends BaseManagerImpl<CuringAssessmentDao, CuringAssessment>
implements CuringAssessmentManager {
    @Resource
    private CuringAssessmentDetailedManager curingAssessmentDetailedManager;

    @Override
    public String saveCuringAssessment(CuringAssessmentIVo curingAssessmentIVo) {
        LocalDate nowDate;
        CuringAssessment curingAssessment = curingAssessmentIVo.getCuringAssessment();
        Integer assessmentContent = curingAssessment.getAssessmentQuarter();
        String errMsg = "";
        if (1 == assessmentContent) {
            nowDate = LocalDate.now();
            curingAssessment.setStartDate(nowDate.plusMonths(1 - nowDate.getMonthValue()).with(TemporalAdjusters.firstDayOfMonth()));
            curingAssessment.setEndDate(nowDate.plusMonths(3 - nowDate.getMonthValue()).with(TemporalAdjusters.lastDayOfMonth()));
            errMsg = nowDate.getYear() + "\u5e74\u7b2c\u4e00\u5b63\u5ea6\u8003\u6838\u4fe1\u606f\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0";
        }
        if (2 == assessmentContent) {
            nowDate = LocalDate.now();
            curingAssessment.setStartDate(nowDate.plusMonths(4 - nowDate.getMonthValue()).with(TemporalAdjusters.firstDayOfMonth()));
            curingAssessment.setEndDate(nowDate.plusMonths(6 - nowDate.getMonthValue()).with(TemporalAdjusters.lastDayOfMonth()));
            errMsg = nowDate.getYear() + "\u5e74\u7b2c\u4e8c\u5b63\u5ea6\u8003\u6838\u4fe1\u606f\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0";
        }
        if (3 == assessmentContent) {
            nowDate = LocalDate.now();
            curingAssessment.setStartDate(nowDate.plusMonths(7 - nowDate.getMonthValue()).with(TemporalAdjusters.firstDayOfMonth()));
            curingAssessment.setEndDate(nowDate.plusMonths(9 - nowDate.getMonthValue()).with(TemporalAdjusters.lastDayOfMonth()));
            errMsg = nowDate.getYear() + "\u5e74\u7b2c\u4e09\u5b63\u5ea6\u8003\u6838\u4fe1\u606f\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0";
        }
        if (4 == assessmentContent) {
            nowDate = LocalDate.now();
            curingAssessment.setStartDate(nowDate.plusMonths(10 - nowDate.getMonthValue()).with(TemporalAdjusters.firstDayOfMonth()));
            curingAssessment.setEndDate(nowDate.plusMonths(12 - nowDate.getMonthValue()).with(TemporalAdjusters.lastDayOfMonth()));
            errMsg = nowDate.getYear() + "\u5e74\u7b2c\u56db\u5b63\u5ea6\u8003\u6838\u4fe1\u606f\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0";
        }
        if (5 == assessmentContent) {
            nowDate = LocalDate.now();
            curingAssessment.setStartDate(nowDate.plusMonths(10 - nowDate.getMonthValue()).with(TemporalAdjusters.firstDayOfMonth()));
            curingAssessment.setEndDate(nowDate.plusMonths(12 - nowDate.getMonthValue()).with(TemporalAdjusters.lastDayOfMonth()));
            errMsg = nowDate.getYear() + "\u5e74\u3010" + curingAssessment.getStartDate() + "~" + curingAssessment.getEndDate() + "\u3011\u8003\u6838\u4fe1\u606f\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0";
        }
        if (StringUtils.isEmpty((CharSequence)curingAssessment.getId())) {
            QueryWrapper queryCountWrapper = new QueryWrapper();
            queryCountWrapper.eq((Object)"ASSESSMENT_QUARTER_", (Object)assessmentContent);
            queryCountWrapper.eq((Object)"START_DATE_", (Object)curingAssessment.getStartDate());
            queryCountWrapper.eq((Object)"END_DATE_", (Object)curingAssessment.getEndDate());
            Integer count = ((CuringAssessmentDao)this.baseMapper).selectCount((Wrapper)queryCountWrapper);
            if (count > 0) {
                throw new RuntimeException(errMsg);
            }
            curingAssessment.setIsDele("0");
            ((CuringAssessmentDao)this.baseMapper).insert((Object)curingAssessment);
        } else {
            ((CuringAssessmentDao)this.baseMapper).updateById((Object)curingAssessment);
        }
        List<CuringAssessmentDetailed> curingAssessmentDetailedList = curingAssessmentIVo.getCuringAssessmentDetailedList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"ASSESSMENT_MAIN_ID_", (Object)curingAssessment.getId());
        this.curingAssessmentDetailedManager.remove((Wrapper)queryWrapper);
        for (CuringAssessmentDetailed curingAssessmentDetailed : curingAssessmentDetailedList) {
            curingAssessmentDetailed.setAssessmentMainId(curingAssessment.getId());
            this.curingAssessmentDetailedManager.save((Object)curingAssessmentDetailed);
        }
        return curingAssessment.getId();
    }

    @Override
    public HSSFWorkbook exportCuringOrder(List<WorkOrderDiseaseVo> workOrderDiseaseVoList) throws Exception {
        if (null == workOrderDiseaseVoList) {
            workOrderDiseaseVoList = new ArrayList<WorkOrderDiseaseVo>();
        }
        Excel excel = new Excel();
        excel.setWorkingSheet(0);
        excel.sheet().sheetName("\u517b\u62a4\u5de5\u5355\u660e\u7ec6\u8868");
        HSSFSheet sheet = ExcelUtil.getHSSFSheet((HSSFWorkbook)excel.getWorkBook(), (int)0);
        LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
        exportMap.put("jobNumber", "\u5de5\u5355\u53f7");
        exportMap.put("roadSegmentName", "\u8def\u6bb5");
        exportMap.put("position", "\u4f4d\u7f6e");
        exportMap.put("name", "\u5408\u540c");
        exportMap.put("issuer", "\u7b7e\u53d1\u4eba");
        exportMap.put("issueDate", "\u7b7e\u53d1\u65e5\u671f");
        exportMap.put("demandFinishTime", "\u8981\u6c42\u4fee\u590d\u65e5\u671f");
        exportMap.put("taskContent", "\u4efb\u52a1\u5185\u5bb9");
        exportMap.put("constructionStartPegK", "\u65bd\u5de5\u8d77\u70b9\u6869\u53f7KM");
        exportMap.put("constructionEndPegK", "\u65bd\u5de5\u7ed3\u675f\u6869\u53f7KM");
        exportMap.put("subjectName", "\u79d1\u76ee\u540d\u79f0");
        exportMap.put("fineSubjectName", "\u7ec6\u76ee\u540d\u79f0");
        exportMap.put("spec", "\u5355\u4f4d");
        exportMap.put("PRICE_", "\u5355\u4ef7\uff08\u5143\uff09");
        exportMap.put("amount", "\u6570\u91cf");
        exportMap.put("money", "\u91d1\u989d\uff08\u5143\uff09");
        exportMap.put("auditPrice", "\u5ba1\u6838\u5355\u4ef7\uff08\u5143\uff09");
        exportMap.put("auditAmount", "\u5ba1\u6838\u6570\u91cf");
        exportMap.put("auditMoney", "\u5ba1\u6838\u91d1\u989d\uff08\u5143\uff09");
        exportMap.put("receiverPrice", "\u6536\u65b9\u5355\u4ef7\uff08\u5143\uff09");
        exportMap.put("receiverAmount", "\u6536\u65b9\u6570\u91cf");
        exportMap.put("receiverMoney", "\u6536\u65b9\u91d1\u989d\uff08\u5143\uff09");
        exportMap.put("remarks", "\u5907\u6ce8");
        this.setSheetTitle(excel, "\u517b\u62a4\u5de5\u5355\u660e\u7ec6\u8868");
        ExcelUtil.addMergeCellReign((Sheet)sheet, (int)0, (int)0, (int)0, (int)(exportMap.size() - 1));
        for (int r = 1; r < exportMap.size(); ++r) {
            excel.cell(0, r).border(BorderStyle.THIN, Color.BLACK);
        }
        this.setSheetHeader(excel, exportMap, 1, 0);
        int workOrderDiseaseVoListSize = workOrderDiseaseVoList.size();
        int currentRow = 2;
        for (int i = 0; i < workOrderDiseaseVoListSize; ++i) {
            WorkOrderDiseaseVo workOrderDiseaseVo = workOrderDiseaseVoList.get(i);
            WorkOrderInformation workOrderInformation = workOrderDiseaseVo.getWorkOrderInformation();
            Contract contract = workOrderDiseaseVo.getContract();
            List<BillOfQuantities> billOfQuantitiesList = workOrderDiseaseVo.getBillOfQuantities();
            ArrayList<Map> billOfQuantitiesToMaplist = new ArrayList<Map>();
            if (BeanUtils.isNotEmpty(billOfQuantitiesList)) {
                for (BillOfQuantities billOfQuantities : billOfQuantitiesList) {
                    billOfQuantitiesToMaplist.add(JsonUtil.toMap((String)JsonUtil.toJson((Object)((Object)billOfQuantities))));
                }
            }
            this.setSheetCell(excel, currentRow, 0, workOrderInformation.getJobNumber());
            this.setSheetCell(excel, currentRow, 1, contract.getRoadSegmentName());
            this.setSheetCell(excel, currentRow, 2, workOrderInformation.getPosition());
            this.setSheetCell(excel, currentRow, 3, contract.getName());
            this.setSheetCell(excel, currentRow, 4, workOrderInformation.getIssuer());
            this.setSheetCell(excel, currentRow, 5, workOrderInformation.getIssueDate());
            this.setSheetCell(excel, currentRow, 6, workOrderInformation.getDemandFinishTime());
            this.setSheetCell(excel, currentRow, 7, workOrderInformation.getTaskContent());
            this.setSheetCell(excel, currentRow, 8, workOrderInformation.getConstructionStartPegK());
            this.setSheetCell(excel, currentRow, 9, workOrderInformation.getConstructionEndPegK());
            this.setSheetCell(excel, currentRow, exportMap.size() - 1, workOrderInformation.getRemarks());
            if (billOfQuantitiesList != null && billOfQuantitiesList.size() > 1) {
                for (int r = currentRow + 1; r < currentRow + billOfQuantitiesList.size(); ++r) {
                    for (int j = 0; j < 10; ++j) {
                        excel.cell(r, j).border(BorderStyle.THIN, Color.BLACK);
                        this.setSheetCell(excel, r, j, "");
                    }
                    excel.cell(r, exportMap.size() - 1).border(BorderStyle.THIN, Color.BLACK);
                    this.setSheetCell(excel, r, exportMap.size() - 1, "");
                    ++r;
                }
                for (int j = 0; j < 10; ++j) {
                    ExcelUtil.addMergeCellReign((Sheet)sheet, (int)currentRow, (int)j, (int)(currentRow + billOfQuantitiesList.size() - 1), (int)j);
                }
                ExcelUtil.addMergeCellReign((Sheet)sheet, (int)currentRow, (int)(exportMap.size() - 1), (int)(currentRow + billOfQuantitiesList.size() - 1), (int)(exportMap.size() - 1));
            }
            LinkedHashMap<String, String> billOfQuantitiesMap = new LinkedHashMap<String, String>();
            billOfQuantitiesMap.put("subjectName", "\u79d1\u76ee\u540d\u79f0");
            billOfQuantitiesMap.put("fineSubjectName", "\u7ec6\u76ee\u540d\u79f0");
            billOfQuantitiesMap.put("spec", "\u5355\u4f4d");
            billOfQuantitiesMap.put("PRICE_", "\u5355\u4ef7\uff08\u5143\uff09");
            billOfQuantitiesMap.put("amount", "\u6570\u91cf");
            billOfQuantitiesMap.put("money", "\u91d1\u989d\uff08\u5143\uff09");
            billOfQuantitiesMap.put("auditPrice", "\u5ba1\u6838\u5355\u4ef7\uff08\u5143\uff09");
            billOfQuantitiesMap.put("auditAmount", "\u5ba1\u6838\u6570\u91cf");
            billOfQuantitiesMap.put("auditMoney", "\u5ba1\u6838\u91d1\u989d\uff08\u5143\uff09");
            billOfQuantitiesMap.put("receiverPrice", "\u6536\u65b9\u5355\u4ef7\uff08\u5143\uff09");
            billOfQuantitiesMap.put("receiverAmount", "\u6536\u65b9\u6570\u91cf");
            billOfQuantitiesMap.put("receiverMoney", "\u6536\u65b9\u91d1\u989d\uff08\u5143\uff09");
            currentRow = this.setSheetDataNoHeader(excel, billOfQuantitiesMap, billOfQuantitiesToMaplist, currentRow, 10);
        }
        return excel.getWorkBook();
    }

    @Override
    public HSSFWorkbook exportCuringAssessment(String ids) throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"ID_", (Object[])ids.split(","));
        List curingAssessments = ((CuringAssessmentDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        ArrayList<CuringAssessmentIVo> curingAssessmentIVoList = new ArrayList<CuringAssessmentIVo>();
        if (BeanUtils.isNotEmpty((Object)curingAssessments)) {
            for (CuringAssessment curingAssessment : curingAssessments) {
                CuringAssessmentIVo curingAssessmentIVo = new CuringAssessmentIVo();
                curingAssessmentIVo.setCuringAssessment(curingAssessment);
                QueryWrapper queryDetailedWrapper = new QueryWrapper();
                queryDetailedWrapper.eq((Object)"ASSESSMENT_MAIN_ID_", (Object)curingAssessment.getId());
                List curingAssessmentDetailedList = this.curingAssessmentDetailedManager.list((Wrapper)queryDetailedWrapper);
                curingAssessmentIVo.setCuringAssessmentDetailedList(curingAssessmentDetailedList);
                curingAssessmentIVoList.add(curingAssessmentIVo);
            }
        }
        HSSFWorkbook hssfWorkbook = this.getHSSFWorkbook(curingAssessmentIVoList);
        return hssfWorkbook;
    }

    public HSSFWorkbook getHSSFWorkbook(List<CuringAssessmentIVo> curingAssessmentIVoList) throws Exception {
        Excel excel = new Excel();
        for (int i = 0; i < curingAssessmentIVoList.size(); ++i) {
            CuringAssessmentIVo curingAssessmentIVo = curingAssessmentIVoList.get(i);
            CuringAssessment curingAssessment = curingAssessmentIVo.getCuringAssessment();
            excel.setWorkingSheet(i);
            String sheetName = "";
            Integer assessmentQuarter = curingAssessment.getAssessmentQuarter();
            sheetName = assessmentQuarter < 5 ? "\u7b2c" + assessmentQuarter + "\u5b63\u5ea6\u8003\u6838" : curingAssessment.getStartDate() + "~" + curingAssessment.getEndDate();
            excel.sheet().sheetName(sheetName);
            HSSFSheet sheet = ExcelUtil.getHSSFSheet((HSSFWorkbook)excel.getWorkBook(), (int)0);
            this.setSheetTitle(excel, "\u65e5\u5e38\u517b\u62a4\u8003\u6838\u8bc4\u5206\u8868");
            ExcelUtil.addMergeCellReign((Sheet)sheet, (int)0, (int)0, (int)0, (int)7);
            for (int r = 1; r < 8; ++r) {
                excel.cell(0, r).border(BorderStyle.THIN, Color.BLACK);
            }
            this.setSheetCell(excel, 1, 0, "\u516c    \u53f8:");
            this.setSheetCell(excel, 1, 1, "");
            ExcelUtil.addMergeCellReign((Sheet)sheet, (int)1, (int)0, (int)1, (int)1);
            this.setSheetCell(excel, 1, 2, curingAssessment.getCompanyName());
            this.setSheetCell(excel, 1, 3, "");
            ExcelUtil.addMergeCellReign((Sheet)sheet, (int)1, (int)2, (int)1, (int)3);
            this.setSheetCell(excel, 1, 4, "\u8def    \u6bb5:");
            this.setSheetCell(excel, 1, 5, "");
            ExcelUtil.addMergeCellReign((Sheet)sheet, (int)1, (int)4, (int)1, (int)5);
            this.setSheetCell(excel, 1, 6, curingAssessment.getRoadName());
            this.setSheetCell(excel, 1, 7, "");
            ExcelUtil.addMergeCellReign((Sheet)sheet, (int)1, (int)6, (int)1, (int)7);
            this.setSheetCell(excel, 2, 0, "\u5408\u540c\u540d\u79f0:");
            this.setSheetCell(excel, 2, 1, "");
            ExcelUtil.addMergeCellReign((Sheet)sheet, (int)2, (int)0, (int)2, (int)1);
            this.setSheetCell(excel, 2, 2, curingAssessment.getItemName());
            this.setSheetCell(excel, 2, 3, "");
            ExcelUtil.addMergeCellReign((Sheet)sheet, (int)2, (int)2, (int)2, (int)3);
            this.setSheetCell(excel, 2, 4, "\u5408\u540c\u7f16\u53f7:");
            this.setSheetCell(excel, 2, 5, "");
            ExcelUtil.addMergeCellReign((Sheet)sheet, (int)2, (int)4, (int)2, (int)5);
            this.setSheetCell(excel, 2, 6, curingAssessment.getItemNomber());
            this.setSheetCell(excel, 2, 7, "");
            ExcelUtil.addMergeCellReign((Sheet)sheet, (int)2, (int)6, (int)2, (int)7);
            List<CuringAssessmentDetailed> curingAssessmentDetailedList = curingAssessmentIVo.getCuringAssessmentDetailedList();
            ArrayList<Map> list = new ArrayList<Map>();
            if (BeanUtils.isNotEmpty(curingAssessmentDetailedList)) {
                for (CuringAssessmentDetailed curingAssessmentDetailed : curingAssessmentDetailedList) {
                    list.add(JsonUtil.toMap((String)JsonUtil.toJson((Object)((Object)curingAssessmentDetailed))));
                }
            }
            LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
            exportMap.put("assessmentContent", "\u8003\u6838\u5185\u5bb9");
            exportMap.put("weight", "\u6743\u91cd");
            exportMap.put("assessmentDetailedContent", "\u8be6\u7ec6\u8003\u6838\u5185\u5bb9");
            exportMap.put("scoringCriteria", "\u8bc4\u5206\u6807\u51c6");
            exportMap.put("checkSituation", "\u68c0\u67e5\u60c5\u51b5");
            exportMap.put("score", "\u5f97\u5206");
            exportMap.put("remarks", "\u5907\u6ce8");
            this.setSheetData(excel, exportMap, list, 3, 1);
        }
        return excel.getWorkBook();
    }

    public void setSheetTitle(Excel excel, String title) {
        excel.row().height(35.0f);
        excel.cell(0, 0).value((Object)"").border(BorderStyle.THIN, Color.BLACK).fontHeightInPoint(25).warpText(true).align(Align.LEFT).height(35.0f);
        excel.cell(0, 0).value((Object)title).align(Align.CENTER).height(35.0f).bgColor(Color.GREY_25_PERCENT).fontHeightInPoint(28).width(5120).border(BorderStyle.THIN, Color.BLACK).font(new IFontEditor(){

            public void updateFont(Font font) {
                font.boldweight(BoldWeight.BOLD);
                font.color(Color.BLACK);
            }
        });
    }

    public void setSheetCell(Excel excel, int row, int col, Object obj) {
        String val = obj == null ? "" : String.valueOf(obj);
        excel.cell(row, col).value((Object)"").border(BorderStyle.THIN, Color.WHITE).fontHeightInPoint(12).warpText(true).align(Align.LEFT).height(30.0f);
        excel.cell(row, col).value((Object)val).align(Align.CENTER).height(30.0f).fontHeightInPoint(12).width(5120).border(BorderStyle.THIN, Color.BLACK).font(new IFontEditor(){

            public void updateFont(Font font) {
                font.boldweight(BoldWeight.NORMAL);
                font.color(Color.BLACK);
            }
        });
    }

    public void setSheetHeader(Excel excel, Map<String, String> fieldMap, int row, int col) {
        int rows = row;
        int cols = col;
        for (String name : fieldMap.values()) {
            excel.cell(rows, cols).value((Object)"").border(BorderStyle.THIN, Color.BLACK).fontHeightInPoint(12).warpText(true).align(Align.LEFT).height(30.0f);
            excel.cell(rows, cols).value((Object)name).align(Align.CENTER).height(30.0f).fontHeightInPoint(12).width(5120).border(BorderStyle.THIN, Color.BLACK).font(new IFontEditor(){

                public void updateFont(Font font) {
                    font.boldweight(BoldWeight.BOLD);
                    font.color(Color.BLACK);
                }
            });
            ++cols;
        }
    }

    public void setSheetData(Excel excel, Map<String, String> fieldMap, List data, int headerRowIndex, int headerColIndex) {
        int size = fieldMap.size();
        int rows = headerRowIndex;
        int cols = headerColIndex;
        excel.cell(rows, 0).value((Object)"").border(BorderStyle.THIN, Color.BLACK).fontHeightInPoint(12).warpText(true).align(Align.LEFT).height(30.0f);
        excel.cell(rows, 0).value((Object)"\u5e8f\u53f7").align(Align.CENTER).height(30.0f).fontHeightInPoint(12).width(5120).border(BorderStyle.THIN, Color.BLACK).font(new IFontEditor(){

            public void updateFont(Font font) {
                font.boldweight(BoldWeight.BOLD);
                font.color(Color.BLACK);
            }
        });
        for (String name : fieldMap.values()) {
            excel.cell(rows, cols).value((Object)"").border(BorderStyle.THIN, Color.BLACK).fontHeightInPoint(12).warpText(true).align(Align.LEFT).height(30.0f);
            excel.cell(rows, cols).value((Object)name).align(Align.CENTER).height(30.0f).fontHeightInPoint(12).width(5120).border(BorderStyle.THIN, Color.BLACK).font(new IFontEditor(){

                public void updateFont(Font font) {
                    font.boldweight(BoldWeight.BOLD);
                    font.color(Color.BLACK);
                }
            });
            ++cols;
        }
        int datarows = rows + 1;
        int sequence = 1;
        for (Object obj : data) {
            Map rowObj = (Map)obj;
            int datacol = 1;
            excel.cell(datarows, 0).value((Object)sequence).border(BorderStyle.THIN, Color.BLACK).fontHeightInPoint(12).warpText(true).align(Align.CENTER).height(30.0f);
            for (String key : fieldMap.keySet()) {
                String val = rowObj.get(key) == null ? "" : rowObj.get(key).toString();
                excel.cell(datarows, datacol).value((Object)val).border(BorderStyle.THIN, Color.BLACK).fontHeightInPoint(12).warpText(true).align(Align.LEFT).height(30.0f);
                ++datacol;
            }
            ++datarows;
            ++sequence;
        }
    }

    public int setSheetDataNoHeader(Excel excel, Map<String, String> fieldMap, List data, int headerRowIndex, int headerColIndex) {
        if (data == null) {
            return headerRowIndex;
        }
        int datarows = headerRowIndex;
        for (Object obj : data) {
            Map rowObj = (Map)obj;
            int datacol = headerColIndex;
            for (String key : fieldMap.keySet()) {
                String val = rowObj.get(key) == null ? "" : rowObj.get(key).toString();
                excel.cell(datarows, datacol).value((Object)val).border(BorderStyle.THIN, Color.BLACK).fontHeightInPoint(12).warpText(true).align(Align.LEFT).height(30.0f);
                ++datacol;
            }
            ++datarows;
        }
        return datarows;
    }
}

