package com.artfess.uc.dao;

import com.artfess.uc.model.MatrixColDef;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 
 * <pre> 
 * 描述：矩阵列定义 DAO接口
 * 构建组：x7
 * 作者:pangq
 * 邮箱:pangq@jee-soft.cn
 * 日期:2020-06-05 14:02:42
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
public interface MatrixColDefDao extends BaseMapper<MatrixColDef> {
	/**
	 * 获取未删除的列定义
	 * @param matrixId
	 * @param colType
	 * @return
	 */
	List<MatrixColDef> getColList(@Param("matrixId") String matrixId,@Param("colType") Integer colType);

	/**
	 * 获取全部的列定义，包括删除的
	 * @param matrixId
	 * @param colType
	 * @return
	 */
	List<MatrixColDef> getColAllList(@Param("matrixId") String matrixId,@Param("colType") Integer colType);

	MatrixColDef getByCode(@Param("matrixId")String matrixId, @Param("code")String code, @Param("colType")Integer colType);

	void updateStatus(@Param("ids") List<String> ids, @Param("status") Integer status);

}
