package com.artfess.bpm.plugin.usercalc.role.content;

import org.w3c.dom.Element;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.artfess.base.util.JsonUtil;
import com.artfess.bpm.api.plugin.core.context.AbstractUserCalcPluginContext;
import com.artfess.bpm.api.plugin.core.def.BpmPluginDef;
import com.artfess.bpm.api.plugin.core.runtime.RunTimePlugin;
import com.artfess.bpm.plugin.usercalc.role.def.RolePluginDef;
import com.artfess.bpm.plugin.usercalc.role.runtime.RolePlugin;

/**
 * 角色作为流程审批人的上下文对象
 *
 * @company 广州宏天软件股份有限公司
 * @author pangq
 * @email pangq@jee-soft.cn
 * @date 2020年6月16日
 */
public class RolePluginContext extends AbstractUserCalcPluginContext {
	private static final long serialVersionUID = -5261531157333798291L;

	@Override
	public String getDescription() {
		RolePluginDef def = (RolePluginDef)this.getBpmPluginDef();
		if(def==null) return "";
		return def.getDescription();
	}

	@Override
	public String getTitle() {
		return "角色";
	}

	@SuppressWarnings("rawtypes")
	@Override
	public Class<? extends RunTimePlugin> getPluginClass() {
		return RolePlugin.class;
	}
	
	/**
	 * <role roleCode="" roleName="" />
	 */
	@Override
	public String getPluginXml() {
		BpmPluginDef bpmPluginDef = getBpmPluginDef();
		RolePluginDef def = (RolePluginDef)bpmPluginDef;
		if(def==null) return "";
		StringBuffer sb = new StringBuffer();
		sb.append("<role xmlns=\"http://www.jee-soft.cn/bpm/plugins/userCalc/role\" ");
		sb.append("  logicCal=\"" + def.getLogicCal().getKey() + "\" extract=\"" + def.getExtract().getKey() 
				+ "\" description=\"" + def.getDescription()+ "\" roleCode=\"" + def.getRoleCode()+ "\" roleName=\"" + def.getRoleName()+ "\">");
		sb.append("</role>");
		return sb.toString();
	}
	
	@Override
	protected BpmPluginDef parseElement(Element element) {
		RolePluginDef def = new RolePluginDef();
		String description = element.getAttribute("description");
		String roleCode = element.getAttribute("roleCode");
		String roleName = element.getAttribute("roleName");
		def.setDescription(description);
		def.setRoleCode(roleCode);
		def.setRoleName(roleName);
		return def;
	}

	@Override
	protected BpmPluginDef parseJson(ObjectNode pluginJson) throws Exception {
		RolePluginDef def = new RolePluginDef();
		String description = JsonUtil.getString(pluginJson, "description");
		String roleCode = JsonUtil.getString(pluginJson, "roleCode");
		String roleName = JsonUtil.getString(pluginJson, "roleName");
		def.setDescription(description);
		def.setRoleCode(roleCode);
		def.setRoleName(roleName);
		return def;
	}
}
