package com.artfess.portal.persistence.manager.impl;

import com.alibaba.druid.support.json.JSONUtils;
import com.artfess.base.cache.CacheManager;
import com.artfess.base.cache.ICache;
import com.artfess.base.cache.setting.CacheSetting;
import com.artfess.portal.exception.RedisConnectException;
import com.artfess.portal.params.RedisInfo;
import com.artfess.portal.persistence.manager.RedisService;
import com.artfess.portal.util.oConvertUtils;
import com.artfess.redis.util.RedisUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;

/**
 * Redis 监控信息获取
 *
 * @Author MrBird
 */
@Service("redisService")
@Slf4j
public class RedisServiceImpl implements RedisService {

    @Resource
    private RedisConnectionFactory redisConnectionFactory;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    @Resource
    CacheManager cacheManager;
  @Resource
    RedisUtil redisUtil;

    /**
     * Redis详细信息
     */
    @Override
    public List<RedisInfo> getRedisInfo() throws RedisConnectException {
        Properties info = redisConnectionFactory.getConnection().info();
        System.out.println(JSONUtils.toJSONString(info));
        System.out.println(info.toString());
        List<RedisInfo> infoList = new ArrayList<>();
        RedisInfo redisInfo = null;
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            redisInfo = new RedisInfo();
            redisInfo.setKey(oConvertUtils.getString(entry.getKey()));
            redisInfo.setValue(oConvertUtils.getString(entry.getValue()));
            infoList.add(redisInfo);
        }
        return infoList;
    }

    @Override
    public Map<String, Object> getKeysSize() throws RedisConnectException {
        Long dbSize = redisConnectionFactory.getConnection().dbSize();
        Map<String, Object> map = new HashMap<>();
        map.put("create_time", System.currentTimeMillis());
        map.put("dbSize", dbSize);

        log.info("--getKeysSize--: " + map.toString());
        return map;
    }

    @Override
    public Map<String, Object> getMemoryInfo() throws RedisConnectException {
        Map<String, Object> map = null;
        Properties info = redisConnectionFactory.getConnection().info();
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            String key = oConvertUtils.getString(entry.getKey());
            if ("used_memory".equals(key)) {
                map = new HashMap<>();
                map.put("used_memory", entry.getValue());
                map.put("create_time", System.currentTimeMillis());
            }
        }
        log.info("--getMemoryInfo--: " + map.toString());
        return map;
    }

    @Override
    public Map<String, Object> getAllCache(String key) {
/*		Set<String> keys=null;
        if (StringUtils.isBlank(key)) {
             keys = redisTemplate.keys("*");
        } else {
			keys=redisTemplate.keys(key+"*");
        }
        Map<String, Object> map = new HashMap<>();

		keys.forEach(s -> {
            map.put(s, redisTemplate.opsForValue().get(s));
        });*/

        return redisUtil.getAllCache(key);
    }

	@Override
	public String deleteCache(String... cacheKey) {
        redisUtil.del(cacheKey);
		return "success";
	}

}
