package com.artfess.form.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 提醒业务对象
 *
 * @author 超级管理员
 * @company 广州宏天软件股份有限公司
 * @since 2020-07-07
 */
@TableName("FORM_REMIND_DATA")
@ApiModel(value = "FormRemindData对象", description = "提醒业务对象")
public class FormRemindData extends BaseModel<FormRemindData> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "提醒内容")
    @TableField("CONTENT_")
    private String content;

    @ApiModelProperty(value = "提醒次数")
    @TableField("COUNT_")
    private String count;

    @ApiModelProperty(value = "提醒对象ID")
    @TableField("OBJ_ID_")
    private String objId;

    @ApiModelProperty(value = "提醒内型")
    @TableField("TYPE_OBJ_")
    private String typeObj;

    @ApiModelProperty(value = "打开类型  数据报表 或者流程实例查看页面")
    @TableField("OPEM_TYPE")
    private String opemType;

    @ApiModelProperty(value = "流程实例Id 或者业务对象Id")
    @TableField("OPEM_ID")
    private String opemId;

    @ApiModelProperty(value = "提醒主题")
    @TableField("SUBJECT_")
    private String subject;

    @ApiModelProperty(value = "外健")
    @TableField("REF_ID_")
    private String refId;

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getCount() {
        return count;
    }

    public void setCount(String count) {
        this.count = count;
    }

    public String getObjId() {
        return objId;
    }

    public void setObjId(String objId) {
        this.objId = objId;
    }

    public String getTypeObj() {
        return typeObj;
    }

    public void setTypeObj(String typeObj) {
        this.typeObj = typeObj;
    }

    public String getOpemType() {
        return opemType;
    }

    public void setOpemType(String opemType) {
        this.opemType = opemType;
    }

    public String getOpemId() {
        return opemId;
    }

    public void setOpemId(String opemId) {
        this.opemId = opemId;
    }

    public String getRefId() {
        return refId;
    }

    public void setRefId(String refId) {
        this.refId = refId;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "FormRemindData{" +
                "id=" + id +
                ", content=" + content +
                ", count=" + count +
                ", objId=" + objId +
                ", typeObj=" + typeObj +
                ", opemType=" + opemType +
                ", opemId=" + opemId +
                "}";
    }
}
