package com.artfess.application.model;

import com.mzt.logapi.beans.LogRecord;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.beans.factory.annotation.Value;

import java.util.Date;

public class BizErrLogs extends LogRecord {

    @ApiModelProperty(value = "请求url地址")
    protected String reqUrl;

    @ApiModelProperty(value = "执行时间")
    protected Long executionTime;

    @ApiModelProperty(value = "ip地址")
    protected String ip;

    @ApiModelProperty(value = "日志类型")
    protected String logType;

    @ApiModelProperty(value = "请求状态")
    protected String status;

    @ApiModelProperty(value = "模块")
    protected String moduleType="biz-hz-server";

    public BizErrLogs() {
    }
    public BizErrLogs(LogRecord logRecord) {
        super(logRecord.getId(), logRecord.getTenant(), logRecord.getBizKey(), logRecord.getBizNo(),
                logRecord.getOperator(), logRecord.getAction(), logRecord.getCategory(),
                logRecord.getCreateTime(), logRecord.getDetail());
    }

    public BizErrLogs(Integer id, String tenant, String bizKey, String bizNo, String operator, String action, String category, Date createTime, String detail, String reqUrl, String ip, String logType, String moduleType) {
        super(id, tenant, bizKey, bizNo, operator, action, category, createTime, detail);
        this.reqUrl = reqUrl;
        this.ip = ip;
        this.logType = logType;
        this.status = status;
        this.moduleType = moduleType;
        this.executionTime = executionTime;
    }

    public Long getExecutionTime() {
        return executionTime;
    }

    public void setExecutionTime(Long executionTime) {
        this.executionTime = executionTime;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getReqUrl() {
        return reqUrl;
    }

    public void setReqUrl(String reqUrl) {
        this.reqUrl = reqUrl;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getLogType() {
        return logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public String getModuleType() {
        return moduleType;
    }

    @Value("${spring.application.name:base}")
    public void setModuleType(String moduleType) {
        this.moduleType = moduleType;
    }

}
