package com.artfess.cqxy.ledger.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.bidManagement.manager.BiddingManagementManager;
import com.artfess.cqxy.bidManagement.model.BiddingManagement;
import com.artfess.cqxy.ledger.manager.BiddingLedgerManager;
import com.artfess.cqxy.ledger.vo.BiddingLedgerVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;

/**
 * @author 黎沐华
 * @date 2022/5/24 17:07
 */
@Slf4j
@RestController
@Api(tags = "台账-招投标台账接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RequestMapping("/biz/ledger/biddingLedger/v1")
public class BiddingLedgerController {

    @Autowired
    private BiddingLedgerManager manager;

    @Autowired
    private BiddingManagementManager biddingManagementManager;

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询所有数据", httpMethod = "POST")
    public CommonResult<PageList<BiddingLedgerVo>> page(@ApiParam(name = "queryFilter",value = "招投标查询器") @RequestBody QueryFilter<BiddingManagement> queryFilter) {
        PageList<BiddingLedgerVo> result = manager.queryByPage(queryFilter);
        return new CommonResult<>(true, "操作成功", result);
    }

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 分页数据
     */
    @PostMapping("/list")
    @ApiOperation(value = "S-分页查询所有数据(新)",notes = "参数说明：在通用查询器中的query对象组传入查询参数，传入 PROJECT_ID_ 项目ID 以切换项目，所有参数都需要带上表别名——主表为bbm、副表为pm",httpMethod = "POST")
    public CommonResult<PageList<BiddingManagement>> selectAll(
            @ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<BiddingManagement> queryFilter) {
        PageList<BiddingManagement> result = biddingManagementManager.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"操作成功",result);
    }

    /**
     * 导出数据到Excel
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @return 通用结果
     * @throws IOException IO异常
     */
    @PostMapping("/exportDataToExcel")
    @ApiOperation(value = "S-导出数据到Excel",notes = "使用项目管理查询器")
    public CommonResult exportDataToExcel (@ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<BiddingManagement> queryFilter, HttpServletResponse response) throws IOException {
        log.debug("导出数据到Excel接口请求参数：{}",queryFilter,response);
        manager.exportDataToExcel(queryFilter,response);
        return new CommonResult<>("导出成功");
    }
}
