package com.artfess.cqxy.projectManagement.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 目录管理表(BizDirectoryManagement)表实体类
 * @author 黎沐华
 * @since 2022-02-16 09:04:11
 */
@TableName("BIZ_DIRECTORY_MANAGEMENT")
@ApiModel(value="项目管理-目录管理对象-DirectoryManagement", description="目录管理表")
public class DirectoryManagement extends BizModel<DirectoryManagement> {

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("CODE_")
    @ApiModelProperty(value = "节点编码（节点编码与项目状态编码必须保持一致，以便展示项目流程节点对应状态）")
    private String code;

    @TableField("NAME_")
    @ApiModelProperty(value = "节点名称")
    private String name;

    @TableField("PCODE_")
    @ApiModelProperty(value = "父节点ID")
    private String pcode;

    @TableField("PNAME_")
    @ApiModelProperty(value = "父节点名称")
    private String pname;

    @TableField("URL_")
    @ApiModelProperty(value = "跳转路由地址")
    private String url;

    @TableField("FINISH_STATUS_")
    @ApiModelProperty(value = "节点状态（使用字典，0：锁定，1：未锁定（默认值））")
    private Integer finishStatus;

    @TableField("GROUP_TYPE_")
    @ApiModelProperty(value = "分组类型（使用字典，1：施工前，2：施工阶段，3：竣工验收阶段）")
    private Integer groupType;

    @TableField("SOURCE_")
    @ApiModelProperty(value = "前置节点")
    private String source;

    @TableField("SOURCE_URL_")
    @ApiModelProperty(value = "前置节点路由地址")
    private String sourceUrl;

    @TableField("TARGET_")
    @ApiModelProperty(value = "后置节点")
    private String target;

    @TableField("TARGET_URL_")
    @ApiModelProperty(value = "后置节点路由地址")
    private String targetUrl;

    @TableField("TIMEOUT_PERIOD_")
    @ApiModelProperty(value = "超时提醒时限(单位：天)")
    private Integer timeoutPeriod;

    @TableField("TIMEOUT_REMINDER_TYPE_")
    @ApiModelProperty(value = "超时提醒方式（使用字典，1：站内消息(默认)，2：邮件，3：短信）")
    private Integer timeoutReminderType;

    @TableField("TIMEOUT_REMINDER_INTERVAL_")
    @ApiModelProperty(value = "超时提醒间隔（单位：分钟）")
    private Integer timeoutReminderInterval;

    @TableField("TIMEOUT_TASK_ID_")
    @ApiModelProperty(value = "超时提醒任务ID（用于节点资料处理后关闭提醒）")
    private String timeoutTaskId;

    @TableField("TIMEOUT_TASK_STATUS_")
    @ApiModelProperty(value = "超时提醒任务状态，用于手动关闭/开启提醒(1：开启(默认值)，0：关闭)")
    private Integer timeoutTaskStatus;

    @TableField("HAS_CHILDREN")
    @ApiModelProperty(value = "是否有子节点（1有，0无）")
    private String hasChildren;

    @TableField("SN_")
    @ApiModelProperty(value = "排序号")
    private Long sn;

    @Override
    public String toString() {
        return "DirectoryManagement{" +
                "id='" + id + '\'' +
                ", code='" + code + '\'' +
                ", name='" + name + '\'' +
                ", pcode='" + pcode + '\'' +
                ", pname='" + pname + '\'' +
                ", url='" + url + '\'' +
                ", finishStatus=" + finishStatus +
                ", groupType=" + groupType +
                ", source='" + source + '\'' +
                ", sourceUrl='" + sourceUrl + '\'' +
                ", target='" + target + '\'' +
                ", targetUrl='" + targetUrl + '\'' +
                ", timeoutPeriod=" + timeoutPeriod +
                ", timeoutReminderType=" + timeoutReminderType +
                ", timeoutReminderInterval=" + timeoutReminderInterval +
                ", timeoutTaskId='" + timeoutTaskId + '\'' +
                ", timeoutTaskStatus=" + timeoutTaskStatus +
                ", hasChildren='" + hasChildren + '\'' +
                ", sn=" + sn +
                '}';
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPcode() {
        return pcode;
    }

    public void setPcode(String pcode) {
        this.pcode = pcode;
    }

    public String getPname() {
        return pname;
    }

    public void setPname(String pname) {
        this.pname = pname;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getFinishStatus() {
        return finishStatus;
    }

    public void setFinishStatus(Integer finishStatus) {
        this.finishStatus = finishStatus;
    }

    public Integer getGroupType() {
        return groupType;
    }

    public void setGroupType(Integer groupType) {
        this.groupType = groupType;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSourceUrl() {
        return sourceUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public String getTarget() {
        return target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTargetUrl() {
        return targetUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public Integer getTimeoutPeriod() {
        return timeoutPeriod;
    }

    public void setTimeoutPeriod(Integer timeoutPeriod) {
        this.timeoutPeriod = timeoutPeriod;
    }

    public Integer getTimeoutReminderType() {
        return timeoutReminderType;
    }

    public void setTimeoutReminderType(Integer timeoutReminderType) {
        this.timeoutReminderType = timeoutReminderType;
    }

    public Integer getTimeoutReminderInterval() {
        return timeoutReminderInterval;
    }

    public void setTimeoutReminderInterval(Integer timeoutReminderInterval) {
        this.timeoutReminderInterval = timeoutReminderInterval;
    }

    public String getTimeoutTaskId() {
        return timeoutTaskId;
    }

    public void setTimeoutTaskId(String timeoutTaskId) {
        this.timeoutTaskId = timeoutTaskId;
    }

    public Integer getTimeoutTaskStatus() {
        return timeoutTaskStatus;
    }

    public void setTimeoutTaskStatus(Integer timeoutTaskStatus) {
        this.timeoutTaskStatus = timeoutTaskStatus;
    }

    public String getHasChildre() {
        return hasChildren;
    }

    public void setHasChildre(String hasChildren) {
        this.hasChildren = hasChildren;
    }

    public Long getSn() {
        return sn;
    }

    public void setSn(Long sn) {
        this.sn = sn;
    }
}

