/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.ledger.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.contract.manager.AdministrativePaymentManager;
import com.artfess.cqxy.ledger.dao.PayLedgerDao;
import com.artfess.cqxy.ledger.manager.PayLedgerManager;
import com.artfess.cqxy.ledger.vo.PayLedgerNewVo;
import com.artfess.cqxy.ledger.vo.PayLedgerVo;
import com.artfess.cqxy.processManagermant.manager.ProgressManageManager;
import com.artfess.cqxy.projectManagement.dao.ProjectManagementDao;
import com.artfess.cqxy.projectManagement.manager.ProjectPersonnelManager;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PayLedgerManagerImpl
extends BaseManagerImpl<PayLedgerDao, PayLedgerVo>
implements PayLedgerManager {
    @Autowired
    private SysDictionaryManager sdm;
    @Autowired
    private ProjectPersonnelManager projectPersonnelManager;
    @Autowired
    private UCFeignService ucFeignService;
    @Autowired
    private ProjectManagementDao projectManagementDao;
    @Autowired
    private ProgressManageManager progressManager;
    @Autowired
    private AdministrativePaymentManager administrativePaymentManager;

    @Override
    public PageList<PayLedgerVo> queryByPage(QueryFilter<PayLedgerVo> queryFilter) {
        List<String> projectList;
        queryFilter.withSorter(new FieldSort("pm.PROJECT_TYPE_", Direction.ASC));
        queryFilter.withSorter(new FieldSort("pr.PROJECT_ID_", Direction.ASC));
        queryFilter.withSorter(new FieldSort("pr.REGISTER_DATE_", Direction.DESC));
        if (BizUtils.isProjectIdFields(queryFilter.getQuerys()).booleanValue() && null != (projectList = BizUtils.handProjectAuthByUser(this.ucFeignService, this.projectPersonnelManager, this.projectManagementDao)) && projectList.size() > 0) {
            queryFilter.addFilter("pr.PROJECT_ID_", projectList, QueryOP.IN);
        }
        QueryWrapper wrapper = (QueryWrapper)this.convert2Wrapper(queryFilter, PayLedgerVo.class);
        ((QueryWrapper)wrapper.eq((Object)"pr.IS_DELE_", (Object)"0")).eq((Object)"pm.IS_DELE_", (Object)"0");
        IPage<PayLedgerVo> result = ((PayLedgerDao)this.baseMapper).queryByPage((IPage<PayLedgerVo>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<PayLedgerVo>)wrapper);
        List data = result.getRecords();
        List purpose = this.sdm.queryDictListItemsByCode("jdgl-yt");
        for (PayLedgerVo ele : data) {
            if (ObjectUtils.isNotEmpty((Object)ele.getPurpose())) {
                ele.setPurpose(BizUtils.getDicValueByCode((List<DictModel>)purpose, ele.getPurpose()));
            }
            if (ObjectUtils.isNotEmpty((Object)ele.getPayeeAmountTotal())) {
                ele.setPayeeAmountTotal(ele.getPayeeAmountTotal().stripTrailingZeros());
            }
            if (ObjectUtils.isNotEmpty((Object)ele.getAmountAppropriated())) {
                ele.setAmountAppropriated(ele.getAmountAppropriated().add(ele.getPayeeAmountTotal()).stripTrailingZeros());
            } else {
                ele.setAmountAppropriated(BigDecimal.ZERO.add(ele.getPayeeAmountTotal()).stripTrailingZeros());
            }
            try {
                BigDecimal ratio = ele.getAmountAppropriated().divide(new BigDecimal(ele.getContractAmount()), 4, RoundingMode.HALF_EVEN).multiply(BigDecimal.valueOf(100L));
                if (ratio.compareTo(BigDecimal.valueOf(100L)) > 0) {
                    ratio = BigDecimal.valueOf(100L);
                }
                if (ratio.compareTo(BigDecimal.ZERO) == 0) {
                    ele.setPayRatio("-");
                    continue;
                }
                ele.setPayRatio(ratio.stripTrailingZeros().toPlainString() + "%");
            }
            catch (Exception e) {
                ele.setPayRatio("-");
            }
        }
        result.setRecords(data);
        return new PageList(result);
    }

    @Override
    public void exportDataToExcel(QueryFilter<PayLedgerVo> queryFilter, HttpServletResponse response) throws IOException {
        List data = this.queryByPage(queryFilter).getRows();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        String fileName = data.stream().collect(Collectors.groupingBy(PayLedgerVo::getProjectName)).keySet().toArray()[0] + "\u9879\u76ee\u652f\u4ed8\u53f0\u8d26";
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        ArrayList dataNew = new ArrayList();
        data.forEach(s -> dataNew.add(PayLedgerNewVo.convertToPayLedgerNewVo(s)));
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, PayLedgerNewVo.class, dataNew);
        Sheet sheetAt = workbook.getSheetAt(0);
        for (int i = 0; i < 9; ++i) {
            sheetAt.setColumnWidth(i, 5000);
        }
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public BigDecimal totalPayByYear(Integer year) {
        Object price;
        Map map2;
        Object price2;
        Assert.notNull((Object)year, (String)"\u7edf\u8ba1\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a!");
        BigDecimal result = BigDecimal.ZERO;
        List paymentList = this.administrativePaymentManager.list((Wrapper)new QueryWrapper().eq((Object)"PAYS_YEAR_", (Object)year));
        Map map1 = this.progressManager.getMap((Wrapper)((QueryWrapper)new QueryWrapper().select(new String[]{"SUM(PAYEE_AMOUNT_TOTAL_) as price"}).eq(year != 0, (Object)"YEAR_", (Object)year)).eq((Object)"IS_DELE_", (Object)"0"));
        if (BeanUtils.isNotEmpty((Object)map1) && BeanUtils.isNotEmpty(price2 = map1.get("price"))) {
            result = result.add((BigDecimal)price2);
        }
        if (BeanUtils.isNotEmpty((Object)(map2 = this.administrativePaymentManager.getMap((Wrapper)((QueryWrapper)new QueryWrapper().select(new String[]{"SUM(PAYS_VALUE_) as price"}).eq(year != 0, (Object)"PAYS_YEAR_", (Object)year)).eq((Object)"IS_DELE_", (Object)"0")))) && BeanUtils.isNotEmpty(price = map2.get("price"))) {
            result = result.add((BigDecimal)price);
        }
        return result.setScale(2, 4).stripTrailingZeros();
    }
}

