package com.artfess.uc.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.uc.dao.MatrixColDefDao;
import com.artfess.uc.manager.MatrixColDefManager;
import com.artfess.uc.model.MatrixColDef;
import com.artfess.uc.model.User;
import com.artfess.uc.util.ContextUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 
 * <pre> 
 * 描述：矩阵列定义 处理实现类
 * 构建组：x7
 * 作者:pangq
 * 邮箱:pangq@jee-soft.cn
 * 日期:2020-06-05 14:02:42
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@Service("matrixColDefManager")
public class MatrixColDefManagerImpl extends BaseManagerImpl<MatrixColDefDao, MatrixColDef> implements MatrixColDefManager{

	@Override
	public List<MatrixColDef> getCondList(String matrixId) {
		return this.getColList(matrixId,MatrixColDef.COND_COL_TYPE);
	}

	@Override
	public List<MatrixColDef> getRoleList(String matrixId) {
		return this.getColList(matrixId,MatrixColDef.ROLE_COL_TYPE);
	}

	@Override
	public List<MatrixColDef> getColList(String matrixId, Integer colType) {
		return baseMapper.getColList(matrixId,colType);
	}
	
	@Override
	public List<MatrixColDef> getColAllList(String matrixId, Integer colType) {
		return baseMapper.getColAllList(matrixId,colType);
	}

	@Override
	@Transactional
	public boolean saveCol(String matrixId, MatrixColDef matrixColDef, Integer colType, boolean isCodeExist) {
		boolean isAddCol = false;
		User user = ContextUtil.getCurrentUser();
		matrixColDef.setMatrixId(matrixId);
		matrixColDef.setColType(colType);
		
		if(BeanUtils.isEmpty(matrixColDef.getId())){
			//如果新增的列和已被删除的列别名相同，则将原已删除的进行更新操作
			if(isCodeExist){
				MatrixColDef oldEnt = baseMapper.getByCode(matrixId,matrixColDef.getCode(),colType);
				oldEnt.setName(matrixColDef.getName());
				oldEnt.setSn(matrixColDef.getSn());
				
				if(MatrixColDef.COND_COL_TYPE.equals(colType)){
					oldEnt.setCtrlType(matrixColDef.getCtrlType());
					oldEnt.setQueryAlias(matrixColDef.getQueryAlias());
				}
				if(MatrixColDef.ROLE_COL_TYPE.equals(colType)){
					oldEnt.setSelectType(matrixColDef.getSelectType());
				}
				
				oldEnt.setIsDele(0);
				oldEnt.setUpdateBy(user.getId());
				oldEnt.setUpdateTime(LocalDateTime.now());
				this.update(oldEnt);
			}else{
				matrixColDef.setCreateBy(user.getId());
				matrixColDef.setCreateTime(LocalDateTime.now());
				this.create(matrixColDef);
				isAddCol = true;
			}
		}else{
			matrixColDef.setUpdateBy(user.getId());
			matrixColDef.setUpdateTime(LocalDateTime.now());
			this.update(matrixColDef);
		}
		return isAddCol;
	}

	@Override
	public void updateStatus(List<String> ids, Integer status) {
		baseMapper.updateStatus(ids,status);
	}


//	private MatrixColDef copyColDef(MatrixColDef source, MatrixColDef target) {
//		target.setCode(source.getCode());
//		target.setColConfig(source.getColConfig());
//		target.setColType(source.getColType());
//		target.setCreateBy(source.getCreateBy());
//		target.setCreateOrgId(source.getCreateOrgId());
//		target.setCreateTime(source.getCreateTime());
//		target.setCtrlType(source.getCtrlType());
//		target.setMatrixId(source.getMatrixId());
//		target.setName(source.getName());
//		target.setQueryAlias(source.getQueryAlias());
//		target.setSelectType(source.getSelectType());
//		return target;
//	}
	
}
