package com.artfess.cqxy.projectApproval.model;


import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelEntity;
import com.artfess.base.annotation.BigDecimalFormat;
import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 年度计划表(DecisionAnnualPlan)表实体类
 *
 * @author 黎沐华
 * @since 2022-03-31 16:37:18
 */
@Data
@TableName("BIZ_DECISION_ANNUAL_PLAN")
@ApiModel(value="年度计划表对象-DecisionAnnualPlan", description="年度计划表")
public class DecisionAnnualPlan extends BizModel<DecisionAnnualPlan> {

    // 关联项目的信息放在开头，以便在导出时先导出项目中的配置，而不用进行额外的位置配置
    @ExcelEntity(id = "link")
    @TableField(exist = false)
    @ApiModelProperty(value = "关联的项目信息")
    private ProjectManagement projectInfo;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("PROJECT_ID_")
    @ApiModelProperty(value = "项目ID（关联项目管理表ID）")
    private String projectId;

    @TableField("PROJECT_NAME_")
    @ApiModelProperty(value = "项目名称（关联项目管理表项目名称）")
    private String projectName;

    @Excel(name = "项目类型")
    @TableField("PROJECT_CODE_")
    @ApiModelProperty(value = "项目类型（同项目管理中项目类型）")
    private Integer projectCode;

    @Excel(name = "建设类型")
    @TableField("PROJECT_TYPE_")
    @ApiModelProperty(value = "建设类型（1：新建，2：续建）")
    private String projectType;

    @Excel(name = "年份")
    @TableField("YEAR_")
    @ApiModelProperty(value = "年份（默认当前年份）")
    private Integer year;

    @Excel(name = "责任单位")
    @TableField("RESPONSIBLE_UNIT_")
    @ApiModelProperty(value = "责任单位")
    private String responsibleUnit;

    @Excel(name = "建设地址")
    @TableField("CONSTRUCTION_ADDRESS_")
    @ApiModelProperty(value = "建设地址")
    private String constructionAddress;

    @Excel(name = "建设规模及内容")
    @TableField("CONSTRUCTION_SCALE_CONTENT_")
    @ApiModelProperty(value = "建设规模及内容")
    private String constructionScaleContent;

    @Excel(name = "总投资")
    @TableField("TOTAL_INVESTMENT_")
    @ApiModelProperty(value = "总投资")
    @BigDecimalFormat
    private BigDecimal totalInvestment;

    @Excel(name = "开工时间",format = "yyyy-MM-dd")
    @TableField("COMMENCEMENT_TIME_")
    @ApiModelProperty(value = "开工时间（时间格式：yyyy-mm-dd）")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commencementTime;

    @Excel(name = "完工时间",format = "yyyy-MM-dd")
    @TableField("COMPLETION_TIME_")
    @ApiModelProperty(value = "完工时间（间格式：yyyy-mm-dd）")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completionTime;

    @Excel(name = "备注")
    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    @Excel(name = "年度总投资")
    @TableField("TOTAL_ANNUAL_INVESTMENT_")
    @ApiModelProperty(value = "年度总投资")
    @BigDecimalFormat
    private BigDecimal totalAnnualInvestment;

    @Excel(name = "本年度建设任务")
    @TableField("ANNUAL_TASKS_")
    @ApiModelProperty(value = "本年度建设任务")
    private String annualTasks;

    @Excel(name = "1月投资额")
    @TableField("INVESTMENT1_")
    @ApiModelProperty(value = "1月投资额")
    private BigDecimal investment1;

    @Excel(name = "2月投资额")
    @TableField("INVESTMENT2_")
    @ApiModelProperty(value = "2月投资额")
    private BigDecimal investment2;

    @Excel(name = "3月投资额")
    @TableField("INVESTMENT3_")
    @ApiModelProperty(value = "3月投资额")
    private BigDecimal investment3;

    @Excel(name = "4月投资额")
    @TableField("INVESTMENT4_")
    @ApiModelProperty(value = "4月投资额")
    private BigDecimal investment4;

    @Excel(name = "5月投资额")
    @TableField("INVESTMENT5_")
    @ApiModelProperty(value = "5月投资额")
    private BigDecimal investment5;

    @Excel(name = "6月投资额")
    @TableField("INVESTMENT6_")
    @ApiModelProperty(value = "6月投资额")
    private BigDecimal investment6;

    @Excel(name = "7月投资额")
    @TableField("INVESTMENT7_")
    @ApiModelProperty(value = "7月投资额")
    private BigDecimal investment7;

    @Excel(name = "8月投资额")
    @TableField("INVESTMENT8_")
    @ApiModelProperty(value = "8月投资额")
    private BigDecimal investment8;

    @Excel(name = "9月投资额")
    @TableField("INVESTMENT9_")
    @ApiModelProperty(value = "9月投资额")
    private BigDecimal investment9;

    @Excel(name = "10月投资额")
    @TableField("INVESTMENT10_")
    @ApiModelProperty(value = "10月投资额")
    private BigDecimal investment10;

    @Excel(name = "11月投资额")
    @TableField("INVESTMENT11_")
    @ApiModelProperty(value = "11月投资额")
    private BigDecimal investment11;

    @Excel(name = "12月投资额")
    @TableField("INVESTMENT12_")
    @ApiModelProperty(value = "12月投资额")
    private BigDecimal investment12;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    @Override
    public String toString() {
        return "DecisionAnnualPlan{" +
                "id='" + id + '\'' +
                ", projectId='" + projectId + '\'' +
                ", projectName='" + projectName + '\'' +
                ", projectType=" + projectType +
                ", projectCode=" + projectCode +
                ", responsibleUnit='" + responsibleUnit + '\'' +
                ", constructionAddress='" + constructionAddress + '\'' +
                ", constructionScaleContent='" + constructionScaleContent + '\'' +
                ", totalInvestment='" + totalInvestment + '\'' +
                ", commencementTime=" + commencementTime +
                ", completionTime=" + completionTime +
                ", remarks='" + remarks + '\'' +
                ", projectInfo=" + projectInfo +
                ", accessoryInfo=" + accessoryInfo +
                '}';
    }

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}

