/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.form.model.ComponentFunctionEntity;
import com.artfess.form.persistence.manager.ComponentFunctionManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u53d6\u503c\u51fd\u6570\u914d\u7f6e"})
@ApiGroup(group={"group_application"})
@RequestMapping(value={"/components/componentFunction"})
@RestController
public class ComponentFunctionController
extends BaseController<ComponentFunctionManager, ComponentFunctionEntity> {
    private static final Logger log = LoggerFactory.getLogger(ComponentFunctionController.class);
    @Resource
    ComponentFunctionManager componentFunctionService;

    @ApiOperation(value="\u65b0\u589e\u53d6\u503c\u51fd\u6570\u4fe1\u606f")
    @PostMapping(value={"/insertComponentFunction"})
    public CommonResult<String> insertComponentFunction(@RequestBody ComponentFunctionEntity componentFunctionEntity) {
        try {
            this.componentFunctionService.insertComponentFunction(componentFunctionEntity);
            return new CommonResult(true, componentFunctionEntity.getId());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new CommonResult(false, "\u65b0\u589e\u51fa\u9519" + e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u53d6\u503c\u51fd\u6570\u4fe1\u606f")
    @PostMapping(value={"/updateComponentFunction"})
    public CommonResult<String> updateComponentFunction(@RequestBody ComponentFunctionEntity componentFunctionEntity) {
        try {
            this.componentFunctionService.updateComponentFunction(componentFunctionEntity);
            return new CommonResult(true, componentFunctionEntity.getId());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new CommonResult(false, "\u51fa\u9519" + e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u53d6\u503c\u51fd\u6570\u4fe1\u606f")
    @PostMapping(value={"/loadComponentFunction"})
    public ComponentFunctionEntity loadComponentFunction(@ApiParam(value="\u53d6\u503c\u51fd\u6570ID") @RequestParam String id) {
        return this.componentFunctionService.loadComponentFunction(id);
    }

    @ApiOperation(value="\u6839\u636eID\u6279\u91cf\u5220\u9664\u53d6\u503c\u51fd\u6570\u4fe1\u606f")
    @PostMapping(value={"/deleteComponentFunction"})
    public CommonResult<String> deleteComponentFunction(@ApiParam(value="\u53d6\u503c\u51fd\u6570ID\u96c6\u5408\uff0c\u7528\u9017\u53f7\u9694\u5f00") @RequestParam String ids) {
        try {
            this.componentFunctionService.deleteComponentFunction(ids);
            return new CommonResult();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new CommonResult(false, "\u51fa\u9519" + e.getMessage());
        }
    }

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u503c\u51fd\u6570\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u53d6\u503c\u51fd\u6570\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    @ResponseBody
    public PageList<ComponentFunctionEntity> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<ComponentFunctionEntity> queryFilter) throws Exception {
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("ID_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return this.componentFunctionService.query(queryFilter);
    }
}

