package com.artfess.base.constants;

import java.io.File;

/**
 * 系统常量
 *
 * @company 广州宏天软件股份有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2019年6月5日
 */
public interface SystemConstants {
	/**
	 * 超级管理员账号
	 */
	String SYSTEM_ACCOUNT = "admin";

	/**
	 * 系统管理员账号
	 */
	String SYS_ADMIN_ACCOUNT = "sysadmin";

	/**
	 * 安全管理员账号
	 */
	String SEC_ACCOUNT = "secadmin";

	/**
	 * 日志审计员账号
	 */
	String AUDIT_ACCOUNT = "audit";

	/**
	 * 游客账号
	 */
	String GUEST_ACCOUNT = "guest";
	
    String REFERER_FEIGN ="feign";

	/**
	 * 系统管理员角色
	 */
	String SYSTEM_ROLE = "sysRole";

	/**
	 * 安全管理员角色
	 */
	String SEC_ROLE = "secRole";

	/**
	 * 日志审计员角色
	 */
	String AUDIT_ROLE = "auditRole";

	/**项目根目录*/
	public final String ROOT_PATH = System.getProperty("user.dir");

	/**模板下载、文件导入临时文件目录名*/
	public final String DATA_TEMP_FILE = "tempFile";

	/**模板下载、文件导入临时文件目录*/
	public final String TEMP_DATA_EXCEL = ROOT_PATH+ File.separator +DATA_TEMP_FILE;
}
