package com.artfess.cqxy.universal.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.universal.model.Chunk;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 通用附件表(BizAccessory)表服务接口
 * @author 黎沐华
 * @since 2022-02-16 17:14:40
 */
public interface AccessoryManager extends BaseManager<Accessory> {

    /**
     * 保存附件对象，在上传附件完成之后会返回一个附件对象，前端需要重新组装一个新的完整的附件对象
     * 为了方便依赖其他资源，放到Service层
     * @param accessoryList 附件对象
     * @return 添加成功与否
     */
    boolean saveAccess(List<Accessory> accessoryList);


    /**
     * 根据sourceId查询附件信息
     * @param sourceId sourceId
     * @return 附件信息集合
     */
    List<Accessory> getAccessoryBySourceId(String sourceId);

    /**
     * 根据sourceId分页查询附件信息
     * @param queryFilter 通用查询器
     * @return 附件信息集合
     */
    PageList<Accessory> getAccessoryPageBySourceId(QueryFilter<Accessory> queryFilter);

    /**
     * 根据sourceId删除附件信息
     * @param sourceId sourceId
     * @return 删除成功与否
     */
    boolean removeBySourceId(String sourceId);

    /**
     * 附件上传
     * @param chunk 分片上传对象
     * @param response 响应对象，用于修改响应状态
     * @return 附件对象
     * @throws Exception 异常
     */
     String fileUploadPost(Chunk chunk, HttpServletResponse response) throws Exception;

    /**
     * 合并上传的分片文件并异步上传到MinIO
     * @param bizPath 业务文件夹路径
     * @param fileName 文件名
     * @return 附件对象
     * @throws Exception 异常
     */
    Accessory minioUpload(String bizPath ,String fileName) throws Exception;

    /**
     * 通过minio下载文件并返回路径
     * @param accessory
     * @param bizPath
     * @return 返回下载后的路径，不包括文件名称，如需要文件名称需自行拼接
     * @throws Exception
     */
    String minIoDownFile(Accessory accessory, String bizPath) throws Exception;

    /**
     * 附件通用下载
     * @param ids 文件ids
     * @param bizPath 路径
     * @param response 响应对象，用于修改响应状态
     * @throws Exception 异常
     */
    void minIoDownFile(String ids,String bizPath,  HttpServletResponse response) throws Exception;

    /**
     * 通过项目ID修改项目ID
     *
     * @param oldProjectIds
     * @param newProjectId
     *
     */
    void updateProjectIdByProiectId(String oldProjectIds, String newProjectId);

    /**
     * 通过附件ID将minio文件下载并转为pdf,如果是pdf格式直接返回null
     * @param accessory 附件对象
     * @return 返回转换后的pdf完整路径
     */
    String fileToPdf(Accessory accessory);


    /**
     * 根据group标识查询附件信息
     * @param group group
     * @return 附件信息集合
     */
    List<Accessory> getAccessoryByGroup(String group);
}

