package com.artfess.cqxy.documentLibrary.model;

import com.artfess.base.entity.BizModel;
import com.artfess.cqxy.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 文件库表(FileLibrary)表实体类
 *
 * @author 黎沐华
 * @since 2022-04-02 09:22:25
 */
@TableName("BIZ_FILE_LIBRARY")
@ApiModel(value="文件库表对象-FileLibrary", description="文件库表表")
public class FileLibrary extends BizModel<FileLibrary> {

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("TYPE_ID_")
    @ApiModelProperty(value = "文件库分类ID（关联文件库分类表ID）")
    private String typeId;

    @TableField("ESTABLISHMENT_NAME_")
    @ApiModelProperty(value = "文件名称")
    private String establishmentName;

    @TableField("DOCUMENT_NUMBER_")
    @ApiModelProperty(value = "编号(文号)")
    private String documentNumber;

    @TableField("ESTABLISHMENT_DATE_")
    @ApiModelProperty(value = "批复日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date establishmentDate;

    @TableField("DESCRIBE_")
    @ApiModelProperty(value = "描述")
    private String describe;

    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件信息")
    private List<Accessory> accessoryInfo;

    @TableField(exist = false)
    @ApiModelProperty(value = "类型信息")
    private FileLibraryType typeInfo;

    @Override
    public String toString() {
        return "FileLibrary{" +
                "id='" + id + '\'' +
                ", typeId='" + typeId + '\'' +
                ", establishmentName='" + establishmentName + '\'' +
                ", documentNumber='" + documentNumber + '\'' +
                ", establishmentDate=" + establishmentDate +
                ", describe='" + describe + '\'' +
                ", remarks='" + remarks + '\'' +
                ", accessoryInfo=" + accessoryInfo +
                ", typeInfo=" + typeInfo +
                '}';
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTypeId() {
        return typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public FileLibraryType getTypeInfo() {
        return typeInfo;
    }

    public void setTypeInfo(FileLibraryType typeInfo) {
        this.typeInfo = typeInfo;
    }

    public String getEstablishmentName() {
        return establishmentName;
    }

    public void setEstablishmentName(String establishmentName) {
        this.establishmentName = establishmentName;
    }

    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Date getEstablishmentDate() {
        return establishmentDate;
    }

    public void setEstablishmentDate(Date establishmentDate) {
        this.establishmentDate = establishmentDate;
    }

    public String getDescribe() {
        return describe;
    }

    public void setDescribe(String describe) {
        this.describe = describe;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public List<Accessory> getAccessoryInfo() {
        return accessoryInfo;
    }

    public void setAccessoryInfo(List<Accessory> accessoryInfo) {
        this.accessoryInfo = accessoryInfo;
    }

    /**
     * 获取主键值
     * @return 主键值
     */
    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}

