package com.artfess.cqxy.processManagermant.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.processManagermant.model.ProgressManageReport;
import com.artfess.cqxy.statistics.vo.StatisticsVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 过程管理 - 进度管理 - 工程月报(BizProgressManageReport)表服务接口
 *
 * @author 黎沐华
 * @since 2022-03-11 17:46:51
 */
public interface ProgressManageReportManager extends BaseManager<ProgressManageReport> {

    /**
     * 导入Excel数据
     * @param file 文件
     * @param projectId 项目ID
     */
    void importExcelData(MultipartFile file, String projectId, String contractId/**, Integer portType, String portDate, Integer portUnit, String portUserName**/);

    boolean deleteByIds(List<String> ids);

    /**
     * 导出数据到Excel文件
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportDatatoExcel(QueryFilter<ProgressManageReport> queryFilter, HttpServletResponse response) throws IOException;

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    ProgressManageReport getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 数据集合
     */
    PageList<ProgressManageReport> queryAllByPage(QueryFilter<ProgressManageReport> queryFilter);

    /**
     * 根据项目ID查询总投资额
     * @param projectId
     * @return
     */
    BigDecimal getInvestmentTotal(String projectId, String portDate);

    /**
     * 通过项目ID修改项目ID
     *
     * @param oldProjectIds
     * @param newProjectId
     *
     */
    void updateProjectIdByProiectId(String oldProjectIds, String newProjectId);


    /**
     * 根据条件查询每月投资情况
     * @param statisticsVo
     * @return
     */
    List<Map<String, Object>> queryInvestment(StatisticsVo statisticsVo);


    /**
     * 根据项目ID查询最新的一条项目月报信息
     * @param projectId
     * @return
     */
    ProgressManageReport getByProjectId(String projectId);

    /**
     * 根据项目ID查询累计总投资以及本月进度，
     * 这是原来的，是从月报中统计的
     * @param projectId
     * @return
     */
    ProgressManageReport getProjectOvervieByProjectId(String projectId);

    void recalManageReport(String projectId);

}

