/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.designEstimate.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.designEstimate.dao.EnvironmentalAssessmentDao;
import com.artfess.cqxy.designEstimate.manager.EnvironmentalAssessmentManager;
import com.artfess.cqxy.designEstimate.model.EnvironmentalAssessment;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class EnvironmentalAssessmentManagerImpl
extends BaseManagerImpl<EnvironmentalAssessmentDao, EnvironmentalAssessment>
implements EnvironmentalAssessmentManager {
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private ProjectManagementManager pmm;
    @Autowired
    private GlobalRetrievalManager grm;

    public boolean saveOrUpdate(EnvironmentalAssessment entity) {
        boolean save = StringUtils.isEmpty((CharSequence)entity.getId());
        boolean savedMain = super.saveOrUpdate((Object)entity);
        ArrayList<Accessory> flag = entity.getAccessoryInfo();
        ArrayList<Accessory> accessoryList = null == flag ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.seven.getCode());
            ele.setGroup("EnvironmentalAssessment");
            ele.setNode(ProjectStatusEnum.seven.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        boolean saveAcc = accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
        this.pmm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.six.getCode()));
        this.handleRetrieval(save ? new GlobalRetrieval() : this.grm.getByBizId(entity.getId()), entity);
        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, EnvironmentalAssessment entity) {
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pmm.getById((Serializable)((Object)entity.getProjectId())));
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.ten.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.ten.getName());
        globalRetrieval.setBizTableName(FunctionEnum.ten.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.ten.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.ten.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.ten.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.ten.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.ten.getFunctionPath());
        globalRetrieval.setDocumentNumber(entity.getDocumentNumber());
        globalRetrieval.setName(entity.getName());
        globalRetrieval.setSearchTitle(entity.getName() + "_" + entity.getDocumentNumber() + "_" + entity.getReviewUnit() + "_" + entity.getConclusion() + "_" + entity.getProposal() + "_" + entity.getReviewComments() + "_" + entity.getEstablishmentRemarks());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public EnvironmentalAssessment getById(String id) {
        EnvironmentalAssessment result = ((EnvironmentalAssessmentDao)this.baseMapper).getById(id);
        result.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove((Wrapper)new QueryWrapper().eq((Object)"FILE_SOURCE_ID_", ids));
        }
        return this.removeByIds(ids);
    }

    @Override
    public PageList<EnvironmentalAssessment> queryAllByPage(QueryFilter<EnvironmentalAssessment> queryFilter) {
        BizUtils.handleFilter(queryFilter, "bea", "pm");
        IPage<EnvironmentalAssessment> result = ((EnvironmentalAssessmentDao)this.baseMapper).queryAllByPage((IPage<EnvironmentalAssessment>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<EnvironmentalAssessment>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (EnvironmentalAssessment ele : records) {
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return new PageList(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            InputStream inputStream = file.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            Sheet sheetAt = workbook.getSheetAt(0);
            for (Row row : sheetAt) {
                if (row.getRowNum() == 0) continue;
                EnvironmentalAssessment data = new EnvironmentalAssessment();
                data.setName(null == row.getCell(0) ? row.createCell(0).getStringCellValue() : row.getCell(0).getStringCellValue());
                data.setDocumentNumber(null == row.getCell(1) ? row.createCell(1).getStringCellValue() : row.getCell(1).getStringCellValue());
                data.setReviewUnit(null == row.getCell(2) ? row.createCell(2).getStringCellValue() : row.getCell(2).getStringCellValue());
                data.setEstablishmentDate(null == row.getCell(3) ? row.createCell(3).getDateCellValue() : row.getCell(3).getDateCellValue());
                data.setConclusion(null == row.getCell(4) ? row.createCell(4).getStringCellValue() : row.getCell(4).getStringCellValue());
                data.setProposal(null == row.getCell(5) ? row.createCell(5).getStringCellValue() : row.getCell(5).getStringCellValue());
                data.setReviewComments(null == row.getCell(6) ? row.createCell(6).getStringCellValue() : row.getCell(6).getStringCellValue());
                data.setEstablishmentRemarks(null == row.getCell(7) ? row.createCell(7).getStringCellValue() : row.getCell(7).getStringCellValue());
                data.setProjectId(projectId);
                ((EnvironmentalAssessmentDao)this.baseMapper).insert((Object)data);
                this.handleRetrieval(new GlobalRetrieval(), data);
            }
            workbook.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDatatoExcel(QueryFilter<EnvironmentalAssessment> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "\u8bbe\u8ba1\u6982\u7b97-\u73af\u8bc4-\u5bfc\u51fa\u7ed3\u679c";
        BizUtils.handleFilter(queryFilter, "bea", "pm");
        List data = ((EnvironmentalAssessmentDao)this.baseMapper).queryAllByPage((IPage<EnvironmentalAssessment>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<EnvironmentalAssessment>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, EnvironmentalAssessment.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }
}

