/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.statistics.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.bidManagement.manager.BiddingManagementManager;
import com.artfess.cqxy.contract.manager.ContractManager;
import com.artfess.cqxy.processManagermant.manager.ChangeManagementManager;
import com.artfess.cqxy.processManagermant.manager.ProgressManageManager;
import com.artfess.cqxy.processManagermant.manager.ProgressManageReportManager;
import com.artfess.cqxy.processManagermant.model.ProgressManageReport;
import com.artfess.cqxy.projectApproval.manager.ProjectEstablishmentManager;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.statistics.manager.NewStatisticsManager;
import com.artfess.cqxy.statistics.manager.StatisticsManager;
import com.artfess.cqxy.statistics.vo.BasicInformationVo;
import com.artfess.cqxy.statistics.vo.InvestmentProgressVo;
import com.artfess.cqxy.statistics.vo.ProjectCostVo;
import com.artfess.cqxy.statistics.vo.ProjectProgressVo;
import com.artfess.cqxy.statistics.vo.StartCountVo;
import com.artfess.cqxy.statistics.vo.StatisticsVo;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7edf\u8ba1\u62a5\u8868-\u9879\u76ee\u4fe1\u606f\u7edf\u8ba1\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
@RequestMapping(value={"/biz/statistics/v1"})
public class StatisticsController {
    private static final Logger log = LoggerFactory.getLogger(StatisticsController.class);
    @Autowired
    private StatisticsManager statisticsManager;
    @Autowired
    private SysDictionaryManager sdm;
    @Autowired
    private ProgressManageReportManager progressManageReportManager;
    @Autowired
    private ProgressManageManager progressManageManager;
    @Autowired
    private ProjectManagementManager projectManagementManager;
    @Autowired
    private BiddingManagementManager biddingManagementManager;
    @Autowired
    private ContractManager contractManager;
    @Autowired
    private ChangeManagementManager changeManagementManager;
    @Autowired
    private ProjectEstablishmentManager projectEstablishmentManager;
    @Autowired
    private NewStatisticsManager newStatisticsManager;

    @PostMapping(value={"/investmentProgress"})
    @ApiOperation(value="\u6295\u8d44\u8fdb\u5ea6\u7edf\u8ba1", httpMethod="POST")
    public CommonResult<InvestmentProgressVo> investmentProgress(@ApiParam(name="statisticsVo", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody StatisticsVo statisticsVo) {
        InvestmentProgressVo investmentProgressVo = new InvestmentProgressVo();
        List<Map<String, Object>> investments = this.progressManageReportManager.queryInvestment(statisticsVo);
        List<Map<String, Object>> payments = this.progressManageManager.queryInvestment(statisticsVo);
        ArrayList<Map<Integer, Object>> investmentList = new ArrayList<Map<Integer, Object>>();
        ArrayList<Map<Integer, Object>> outputList = new ArrayList<Map<Integer, Object>>();
        ArrayList<Map<Integer, Object>> paymentList = new ArrayList<Map<Integer, Object>>();
        for (int m = 1; m <= 12; ++m) {
            HashMap<Integer, BigDecimal> mp1;
            Integer moutn;
            boolean isMouth = true;
            if (investments != null && investments.size() > 0) {
                for (Map<String, Object> map : investments) {
                    moutn = map.get("mouth") == null ? 0 : (Integer)map.get("mouth");
                    Object investmentTotal = map.get("investmentTotal");
                    Object outputTotal = map.get("outputTotal");
                    if (m != moutn) continue;
                    HashMap<Integer, BigDecimal> mp12 = new HashMap<Integer, BigDecimal>();
                    mp12.put(m, ((BigDecimal)investmentTotal).stripTrailingZeros());
                    investmentList.add(mp12);
                    HashMap<Integer, BigDecimal> mp2 = new HashMap<Integer, BigDecimal>();
                    mp2.put(m, ((BigDecimal)outputTotal).stripTrailingZeros());
                    outputList.add(mp2);
                    isMouth = false;
                    break;
                }
            }
            if (isMouth) {
                mp1 = new HashMap<Integer, BigDecimal>();
                mp1.put(m, new BigDecimal(0));
                investmentList.add(mp1);
                HashMap<Integer, BigDecimal> hashMap = new HashMap<Integer, BigDecimal>();
                hashMap.put(m, new BigDecimal(0));
                outputList.add(hashMap);
            }
            isMouth = true;
            if (payments != null && payments.size() > 0) {
                for (Map map : payments) {
                    moutn = map.get("mouth") == null ? 0 : (Integer)map.get("mouth");
                    Object paymentTotal = map.get("paymentTotal");
                    if (m != moutn) continue;
                    HashMap<Integer, BigDecimal> mp13 = new HashMap<Integer, BigDecimal>();
                    mp13.put(m, ((BigDecimal)paymentTotal).stripTrailingZeros());
                    paymentList.add(mp13);
                    isMouth = false;
                }
            }
            if (!isMouth) continue;
            mp1 = new HashMap<Integer, BigDecimal>();
            mp1.put(m, new BigDecimal(0));
            paymentList.add(mp1);
        }
        investmentProgressVo.setInvestmentList(investmentList);
        investmentProgressVo.setOutputList(outputList);
        investmentProgressVo.setPaymentList(paymentList);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)investmentProgressVo);
    }

    @PostMapping(value={"/constructionProgress"})
    @ApiOperation(value="\u65bd\u5de5\u8fdb\u5ea6\u7edf\u8ba1", httpMethod="POST")
    public CommonResult<PageList<ProjectManagement>> constructionProgress(@ApiParam(name="queryFilter", value="\u9879\u76ee\u7ba1\u7406\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<ProjectManagement> queryFilter) {
        PageList<ProjectManagement> result = this.projectManagementManager.queryAllByPage(queryFilter);
        List rows = result.getRows();
        if (rows != null) {
            List xmzt = this.sdm.queryDictListItemsByCode("xmgl-xmzt");
            for (ProjectManagement pm : rows) {
                int i;
                Integer status = pm.getProjectStatus() == null ? 0 : Integer.valueOf(pm.getProjectStatus());
                ArrayList<Double> list = new ArrayList<Double>();
                if (status < 11 && status > 1) {
                    for (i = 1; i <= status; ++i) {
                        list.add(0.5);
                    }
                } else if (status == 11) {
                    for (i = 1; i <= status; ++i) {
                        if (i == 11) {
                            list.add(this.getProjectConstructionProgress(pm.getId()));
                            continue;
                        }
                        list.add(0.5);
                    }
                } else if (status > 11) {
                    for (i = 1; i <= status; ++i) {
                        if (i == 11) {
                            list.add(4.0);
                            continue;
                        }
                        if (i == 15) continue;
                        list.add(0.5);
                    }
                }
                pm.setProjectConstructionProgress(list);
                pm.setProjectStatusValue(BizUtils.getDicValueByCode((List<DictModel>)xmzt, status));
            }
        }
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/biddingStatistics"})
    @ApiOperation(value="\u62db\u6295\u6807\u7edf\u8ba1", httpMethod="POST")
    public CommonResult<List<Map<String, Object>>> biddingStatistics(@ApiParam(name="statisticsVo", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody StatisticsVo statisticsVo) {
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", this.biddingManagementManager.queryInvestment(statisticsVo));
    }

    @PostMapping(value={"/contractAmount"})
    @ApiOperation(value="\u5408\u540c\u91d1\u989d\u7edf\u8ba1", httpMethod="POST")
    public CommonResult<List<Map<String, Object>>> contractAmount(@ApiParam(name="statisticsVo", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody StatisticsVo statisticsVo) {
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", this.contractManager.queryInvestment(statisticsVo));
    }

    @PostMapping(value={"/engineeringChange"})
    @ApiOperation(value="\u53d8\u66f4\u8d39\u7528\u7edf\u8ba1", httpMethod="POST", notes="\u7528\u4e8e\u5c55\u793a\u997c\u56fe\u6309\u7167\u53d8\u66f4\u7c7b\u578b\u7edf\u8ba1\uff08\u5355\u4f4d\uff1a\u4e07\u5143\uff09")
    public CommonResult<List<Map<String, Object>>> engineeringChange(@ApiParam(name="statisticsVo", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody StatisticsVo statisticsVo) {
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", this.changeManagementManager.queryInvestment(statisticsVo));
    }

    @PostMapping(value={"/engineeringChangeNumber"})
    @ApiOperation(value="\u53d8\u66f4\u6570\u91cf\u7edf\u8ba1", httpMethod="POST", notes="\u7528\u4e8e\u67f1\u72b6\u56fe\u6309\u6708\u7edf\u8ba1(\u5355\u4f4d\uff1a\u4e2a)")
    public CommonResult<List<Map<Integer, Object>>> engineeringChangeNumber(@ApiParam(name="statisticsVo", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody StatisticsVo statisticsVo) {
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", this.changeManagementManager.engineeringChangeNumber(statisticsVo));
    }

    @PostMapping(value={"/measurementPayment"})
    @ApiOperation(value="\u5efa\u8bbe\u60c5\u51b5\u7edf\u8ba1", httpMethod="POST")
    public CommonResult<List<Map<String, Object>>> measurementPayment(@ApiParam(name="statisticsVo", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody StatisticsVo statisticsVo) {
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", this.projectEstablishmentManager.queryInvestment(statisticsVo));
    }

    @PostMapping(value={"/getBasicInformation"})
    @ApiOperation(value="\u9879\u76ee\u57fa\u672c\u60c5\u51b5\u7edf\u8ba1", httpMethod="POST")
    public CommonResult<BasicInformationVo> getBasicInformation(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<ProjectManagement> queryFilter) {
        BasicInformationVo basicInformation = this.newStatisticsManager.getBasicInformation(queryFilter);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)basicInformation);
    }

    @PostMapping(value={"/getProjectProgress"})
    @ApiOperation(value="\u9879\u76ee\u8fdb\u5ea6\u7edf\u8ba1", httpMethod="POST")
    public CommonResult<ProjectProgressVo> getProjectProgress(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<ProjectManagement> queryFilter) {
        ProjectProgressVo projectProgress = this.newStatisticsManager.getProjectProgress(queryFilter);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)projectProgress);
    }

    @PostMapping(value={"/getStartCount"})
    @ApiOperation(value="\u5f00\u5de5\u603b\u6570\u7edf\u8ba1", httpMethod="POST")
    public CommonResult<StartCountVo> getStartCount(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<ProjectManagement> queryFilter) {
        StartCountVo startCount = this.newStatisticsManager.getStartCount(queryFilter);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)startCount);
    }

    @PostMapping(value={"/getCompletedCount"})
    @ApiOperation(value="\u7ae3\u5de5\u603b\u6570\u7edf\u8ba1", httpMethod="POST")
    public CommonResult<StartCountVo> getCompletedCount(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<ProjectManagement> queryFilter) {
        StartCountVo acceptanceCount = this.newStatisticsManager.getAcceptanceCount(queryFilter);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)acceptanceCount);
    }

    @PostMapping(value={"/getProjectCost"})
    @ApiOperation(value="\u9879\u76ee\u8d39\u7528\u7edf\u8ba1", httpMethod="POST")
    public CommonResult<ProjectCostVo> getProjectCost(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<ProjectManagement> queryFilter) {
        ProjectCostVo projectCost = this.newStatisticsManager.getProjectCost(queryFilter);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)projectCost);
    }

    public Double getProjectConstructionProgress(String projectId) {
        String imageProgress;
        Double projectConstructionProgress = 0.5;
        ProgressManageReport progressManageReport = this.progressManageReportManager.getByProjectId(projectId);
        if (null != progressManageReport && StringUtils.isNotBlank((CharSequence)(imageProgress = progressManageReport.getImageProgress()))) {
            Double progress = Double.valueOf(imageProgress = imageProgress.replace("%", ""));
            projectConstructionProgress = progress <= 15.0 ? Double.valueOf(0.5) : (progress <= 35.0 ? Double.valueOf(1.0) : (progress <= 45.0 ? Double.valueOf(1.5) : (progress <= 55.0 ? Double.valueOf(2.0) : (progress <= 65.0 ? Double.valueOf(2.5) : (progress <= 75.0 ? Double.valueOf(3.0) : (progress <= 85.0 ? Double.valueOf(3.5) : Double.valueOf(4.0)))))));
        }
        return projectConstructionProgress;
    }
}

