package com.artfess.sysConfig.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.sysConfig.model.ExcelTempFields;
import com.artfess.sysConfig.persistence.dao.ExcelTempFieldsDao;
import com.artfess.sysConfig.persistence.manager.ExcelTempFieldsManager;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 导入导出模板
 *
 * @author wh
 * @company rzx
 * @since 2021-08-04
 */
@Service("excelTempFieldManager")
public class ExcelTempFieldManagerImpl extends BaseManagerImpl<ExcelTempFieldsDao, ExcelTempFields> implements ExcelTempFieldsManager {
    public  List<ExcelTempFields> getExcelTempByeTempId(String tempId){
        QueryWrapper<ExcelTempFields> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("TEMP_ID", tempId);
        queryWrapper.orderByAsc("ORDER_INDEX");
        return this.list(queryWrapper);
    }
}
