package com.artfess.form.util;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bo.instance.BoDataImportHandler;
import com.artfess.form.model.Form;
import com.artfess.form.model.FormMeta;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * 表单实用函数。
 *
 * @author ray。
 */
public class FormUtil {
    /**
     * 返回模版物理的路径。
     *
     * @return
     * @throws Exception
     */
    public static String getDesignTemplatePath() throws Exception {
        return FileUtil.getClassesPath() + "template" + File.separator + "design" + File.separator;
    }

    /**
     * 获取意见表单字段。
     * <pre>
     * 通过解析表单，返回表单中的意见字段数据。
     * </pre>
     *
     * @param html
     * @return
     */
    public static Map<String, String> parseOpinion(String html) {
        Map<String, String> map = new HashMap<String, String>();
        Document doc = Jsoup.parseBodyFragment(html);
        Elements list = doc.select("[opinion]");
        for (Iterator<Element> it = list.iterator(); it.hasNext(); ) {
            Element el = it.next();
            String opinion = el.attr("opinion");
            try {
                if (opinion != null) {
                    JsonNode jsonObject = JsonUtil.toJsonNode(opinion);
                    String name = jsonObject.get("name") + "";//;el.attr("name");
                    String memo = jsonObject.get("desc") + "";//el.attr("opinionname");
                    map.put(name, memo);
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    /**
     * bfile 需要转换成文件的byte数组
     * filePath  生成的文件保存路径
     * fileName  生成文件后保存的名称如test.pdf，test.jpg等
     */
    public static void getFile(byte[] bfile, String filePath, String fileName) {
        BufferedOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(filePath);
            boolean isDir = dir.isDirectory();
            if (!isDir) {// 目录不存在则先建目录
                try {
                    dir.mkdirs();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            file = new File(filePath + File.separator + fileName);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            } else {
                file.delete();
            }
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bfile);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (bos != null) {
                try {
                    bos.close();
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    // 参数fileName是jar包的路径，processorName 是业务类的包名+类名
    @SuppressWarnings("resource")
    public static BoDataImportHandler loadImportHandler(String filePath, String processorName) {
        URL url = null;
        BoDataImportHandler boDataImportHandler = null;
        File file = new File(filePath);
        try {
            url = file.toURI().toURL();
            URLClassLoader loader = new URLClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader());
            Class<?> processorClass = loader.loadClass(processorName);
            boDataImportHandler = (BoDataImportHandler) processorClass.newInstance();
        } catch (Exception e1) {
            e1.printStackTrace();
        }

        return boDataImportHandler;
    }

    /**
     * 根据表单元数据解析出其中的表单字段
     *
     * @param bpmFormDef
     * @return
     * @throws IOException
     */
    public static ArrayNode resolutionFieldsByFormMeta(FormMeta bpmFormDef) throws IOException {
        ArrayNode resolutionFields = JsonUtil.getMapper().createArrayNode();
        if (!StringUtil.isEmpty(bpmFormDef.getExpand())) {
            JsonNode expand = JsonUtil.toJsonNode(bpmFormDef.getExpand());
            ArrayNode table = (ArrayNode) expand.findValue("list");
            for (JsonNode tableNode : table) {
                String ctrlType = "";
                if (tableNode.has("ctrlType")) {
                    ctrlType = tableNode.get("ctrlType").asText();
                }
                if (tableNode.has("columns")) {
                    // 栅格布局的字段保存  tab 折叠
                    ArrayNode columns = (ArrayNode) tableNode.findValue("columns");
                    for (JsonNode column : columns) {
                        if (column.has("list")) {
                            ArrayNode fields = (ArrayNode) column.findValue("list");
                            for (JsonNode field : fields) {

                                if (Form.GRID_LAYOUT.equals(field.get("ctrlType").asText())) {//tab 折叠 嵌套栅格布局
                                    ArrayNode gridColumns = (ArrayNode) field.findValue("columns");
                                    for (JsonNode gridColumn : gridColumns) {
                                        if (gridColumn.has("list")) {
                                            ArrayNode gridFields = (ArrayNode) gridColumn.findValue("list");
                                            for (JsonNode gridField : gridFields) {
                                                ObjectNode fieldObj = (ObjectNode) gridField;
                                                fieldObj.put("type", "main");
                                                resolutionFields.add(fieldObj);
                                            }
                                        }
                                    }
                                } else if (Form.SUBTABLE_LAYOUT.equals(field.get("ctrlType").asText()) || Form.SUBDIV_LAYOUT.equals(field.get("ctrlType").asText()) || Form.HOT_TABLE.equals(field.get("ctrlType").asText())) {//tab 折叠 嵌套子表布局
                                    // table子表布局、div子表布局、handsonTable子表布局
                                    ArrayNode subtableLists = (ArrayNode) field.findValue("list");
                                    resolutionSub(bpmFormDef.getId(), subtableLists, resolutionFields);
                                } else if (Form.MAIN_TABLE.equals(field.get("ctrlType").asText())) {
                                    // table主表布局
                                    ArrayNode Lists = (ArrayNode) field.findValue("rows");
                                    for (JsonNode rowNode : Lists) {
                                        ArrayNode cols = (ArrayNode) rowNode.findValue("cols");
                                        for (JsonNode colNode : cols) {
                                            if (colNode.has("list") && BeanUtils.isNotEmpty(colNode.get("list"))) {
                                                ArrayNode list = (ArrayNode) colNode.findValue("list");
                                                for (JsonNode tfield : list) {
                                                    ObjectNode fieldObj = (ObjectNode) tfield;
                                                    fieldObj.put("type", "main");
                                                    resolutionFields.add(fieldObj);
                                                }
                                            }
                                        }
                                    }
                                } else if (Form.TAB_LAYOUT.equals(field.get("ctrlType").asText())) {
                                    // tab
                                    String tctrlType = "";
                                    if (tableNode.has("ctrlType")) {
                                        tctrlType = field.get("ctrlType").asText();
                                    }
                                    ArrayNode tabColumns = (ArrayNode) field.findValue("columns");
                                    for (JsonNode tabColumn : tabColumns) {
                                        if (tabColumn.has("list")) {
                                            ArrayNode tabFields = (ArrayNode) tabColumn.findValue("list");
                                            for (JsonNode tabField : tabFields) {

                                                if (Form.GRID_LAYOUT.equals(tabField.get("ctrlType").asText())) {//tab 折叠 嵌套栅格布局
                                                    ArrayNode gridColumns = (ArrayNode) tabField.findValue("columns");
                                                    for (JsonNode gridColumn : gridColumns) {
                                                        if (gridColumn.has("list")) {
                                                            ArrayNode gridFields = (ArrayNode) gridColumn.findValue("list");
                                                            for (JsonNode tgridField : gridFields) {
                                                                ObjectNode fieldObj = (ObjectNode) tgridField;
                                                                fieldObj.put("type", "main");
                                                                resolutionFields.add(fieldObj);
                                                            }
                                                        }
                                                    }
                                                } else if (Form.SUBTABLE_LAYOUT.equals(tabField.get("ctrlType").asText()) || Form.SUBDIV_LAYOUT.equals(tabField.get("ctrlType").asText()) || Form.HOT_TABLE.equals(tabField.get("ctrlType").asText())) {//tab 折叠 嵌套子表布局
                                                    // 子表布局
                                                    ArrayNode subtableLists = (ArrayNode) tabField.findValue("list");
                                                    resolutionSub(bpmFormDef.getId(), subtableLists, resolutionFields);
                                                } else if (Form.MAIN_TABLE.equals(tabField.get("ctrlType").asText())) {
                                                    // table主表布局
                                                    ArrayNode Lists = (ArrayNode) tabField.findValue("rows");
                                                    for (JsonNode rowNode : Lists) {
                                                        ArrayNode cols = (ArrayNode) rowNode.findValue("cols");
                                                        for (JsonNode colNode : cols) {
                                                            if (colNode.has("list") && BeanUtils.isNotEmpty(colNode.get("list"))) {
                                                                ArrayNode list = (ArrayNode) colNode.findValue("list");
                                                                for (JsonNode tfield : list) {
                                                                    ObjectNode fieldObj = (ObjectNode) tfield;
                                                                    fieldObj.put("type", "main");
                                                                    resolutionFields.add(fieldObj);
                                                                }
                                                            }
                                                        }
                                                    }
                                                } else {
                                                    ObjectNode fieldObj = (ObjectNode) tabField;
                                                    fieldObj.put("type", "main");
                                                    resolutionFields.add(fieldObj);
                                                }
                                            }
                                        } else if (Form.SUBTABLE_LAYOUT.equals(tctrlType) || Form.SUBDIV_LAYOUT.equals(tctrlType) || Form.HOT_TABLE.equals(tctrlType)) {
                                            // 子表布局
                                            ArrayNode Lists = (ArrayNode) field.findValue("list");
                                            resolutionSub(bpmFormDef.getId(), Lists, resolutionFields);
                                        } else {
                                            // 不使用布局
                                            resolutionFields.add(field);
                                        }
                                    }
                                } else {
                                    ObjectNode fieldObj = (ObjectNode) field;
                                    fieldObj.put("type", "main");
                                    resolutionFields.add(fieldObj);
                                }
                            }
                        }
                    }
                } else if (Form.SUBTABLE_LAYOUT.equals(ctrlType) || Form.SUBDIV_LAYOUT.equals(ctrlType) || Form.HOT_TABLE.equals(ctrlType)) {
                    // tab子表布局,div子表布局,hottable子表布局
                    ArrayNode Lists = (ArrayNode) tableNode.findValue("list");
                    resolutionSub(bpmFormDef.getId(), Lists, resolutionFields);
                } else if (Form.MAIN_TABLE.equals(ctrlType)) {
                    // table主表布局
                    ArrayNode Lists = (ArrayNode) tableNode.findValue("rows");
                    for (JsonNode rowNode : Lists) {
                        ArrayNode cols = (ArrayNode) rowNode.findValue("cols");
                        for (JsonNode colNode : cols) {
                            if (colNode.has("list") && BeanUtils.isNotEmpty(colNode.get("list"))) {
                                ArrayNode list = (ArrayNode) colNode.findValue("list");
                                for (JsonNode field : list) {
                                    ObjectNode fieldObj = (ObjectNode) field;
                                    fieldObj.put("type", "main");
                                    resolutionFields.add(fieldObj);
                                }
                            }
                        }
                    }
                } else {
                    // 不使用布局
                    resolutionFields.add(tableNode);
                }
            }
        }
        return resolutionFields;
    }

    private static void resolutionSub(String defId, ArrayNode Lists, ArrayNode resolutionFields) throws IOException {
        if (BeanUtils.isNotEmpty(Lists)) {
            for (JsonNode field : Lists) {
                if (field.has("ctrlType") && field.has("list") && (Form.SUNTABLE_LAYOUT.equals(field.get("ctrlType").asText())
                        || Form.SUNDIV_LAYOUT.equals(field.get("ctrlType").asText()))) {
                    ArrayNode sunLists = (ArrayNode) field.findValue("list");
                    for (JsonNode sunField : sunLists) {
                        if (Form.GRID_LAYOUT.equals(sunField.get("ctrlType").asText())) {//div子表布局  嵌套栅格布局
                            ArrayNode gridColumns = (ArrayNode) sunField.findValue("columns");
                            for (JsonNode gridColumn : gridColumns) {
                                if (gridColumn.has("list")) {
                                    ArrayNode gridFields = (ArrayNode) gridColumn.findValue("list");
                                    for (JsonNode gridField : gridFields) {
                                        ObjectNode fieldObj = (ObjectNode) gridField;
                                        resolutionFields.add(fieldObj);
                                    }
                                }
                            }
                        } else {
                            resolutionFields.add(sunField);
                        }
                    }
                } else if (field.has("ctrlType") && Form.GRID_LAYOUT.equals(field.get("ctrlType").asText())) {
                    ArrayNode gridColumns = (ArrayNode) field.findValue("columns");
                    for (JsonNode gridColumn : gridColumns) {
                        if (gridColumn.has("list")) {
                            ArrayNode gridFields = (ArrayNode) gridColumn.findValue("list");
                            for (JsonNode gridField : gridFields) {
                                ObjectNode fieldObj = (ObjectNode) gridField;
                                resolutionFields.add(fieldObj);
                            }
                        }
                    }
                } else {
                    resolutionFields.add(field);
                }
            }
        }
    }

}
