package com.artfess.form.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 业务列表模型  --- 系统按钮配置表
 * </p>
 *
 * @author wh
 * @since 2020-05-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("SYS_BUTTONS")
@ApiModel(value="SysButton对象", description="系统通用功能操作--按钮模板配置表")
public class OperationButtonEntity extends BaseModel<OperationButtonEntity> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(name = "id", notes = "主键")
    @TableId("id_")
    protected String id;

    @ApiModelProperty(value = "按钮名称")
    @TableField("name")
    private String name;

    @ApiModelProperty(value = "按钮编码")
    @TableField("code")
    private String code;

    @ApiModelProperty(value = "按钮别名")
    @TableField("ALIAS")
    private String alias;

    @ApiModelProperty(value = "按钮图标（弹出图标库选择）")
    @TableField("ICON")
    private String icon;

    @ApiModelProperty(value = "按钮样式（选择几种固定常用样式风格）")
    @TableField("STYLE")
    private String style;

    @ApiModelProperty(value = "按钮提醒内容")
    @TableField("REMIND")
    private String remind;

    @ApiModelProperty(value = "排序号")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty(value = "方法名")
    @TableField("method")
    private String method;

    @ApiModelProperty(value = "方法参数")
    @TableField("method_param")
    private String methodParam;

    @ApiModelProperty(value = "启用标志（0：禁用  1：启用）")
    //@TableField(value ="FLAG",fill = FieldFill.INSERT)
    private Integer flag;

    @TableLogic
    @ApiModelProperty(value = "删除标志（0：已删除 1：未删除）")
    @TableField(value = "DEL_FLAG",select=false)
    private Integer delFlag;
}
