package com.artfess.application.jms.impl;

import com.artfess.activemq.model.JmsMessage;
import com.artfess.base.jms.JmsActor;
import com.artfess.base.jms.NoticeMessageType;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.vo.ClientInfo;
import com.artfess.application.jms.JmsHandler;
import com.artfess.application.model.AppPushContent;
import com.artfess.application.model.MsgTemplate;
import com.artfess.application.model.SysExecutor;
import com.artfess.application.persistence.manager.MessageLogManager;
import com.artfess.application.persistence.manager.MsgTemplateManager;
import com.artfess.application.persistence.manager.SysMessageManager;
import com.artfess.application.service.impl.TemplateServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 内部消息处理器
 *
 * @company 广州宏天软件股份有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2018年10月9日
 */
@Service
public class InnerHandler implements JmsHandler {
	private static final Logger logger = LoggerFactory.getLogger(InnerHandler.class);
	@Resource
	SysMessageManager sysMessageManager;
	@Resource
	MessageLogManager messageLogManager;
	
	@Resource
	AppPushHandler appPushHandler;
	@Resource
	MsgTemplateManager msgTemplateManager;
	@Resource
	TemplateServiceImpl templateServiceImpl;
	@Override
	public String getType() {
		return NoticeMessageType.INNER.key();
	}

	@Override
	public boolean send(JmsMessage jmsMessage) {
		try {
			//处理消息
			List<JmsActor> receivers = jmsMessage.getReceivers();
			//构造接收人
			List<SysExecutor> list = new ArrayList<SysExecutor>();
			for(JmsActor actor : receivers){
				SysExecutor executor = new SysExecutor(actor.getId(), actor.getName(), SysExecutor.TYPE_USER);
				list.add(executor);
			}
			if(BeanUtils.isEmpty(list)) return false;
			
			String senderId = null;
			String senderName = null;
			JmsActor sender = jmsMessage.getSender();
			if(BeanUtils.isNotEmpty(sender)) {
				senderId = sender.getId();
				senderName = sender.getName();
			}
			sysMessageManager.sendMsg(jmsMessage.getSubject(), jmsMessage.getContent(), jmsMessage.getType(),jmsMessage.getTypeKey(), senderId, senderName, list);
			//根据消息模板的key获取模板对象
            MsgTemplate msgTemplate = msgTemplateManager.getByKey(jmsMessage.getTemplateAlias());
            if(BeanUtils.isNotEmpty(msgTemplate)){
            	jmsMessage.getExtendVars().put("templateType", msgTemplate.getTypeKey());
            }
            
            
            // 推送手机app消息
            String content = templateServiceImpl.parsePlainContent(msgTemplate, jmsMessage.getExtendVars());
            Map<String,Object> vars = jmsMessage.getExtendVars();
			Map<String,Object> params = new HashMap<>();
			params.put("taskId", vars.getOrDefault("taskId", ""));
			params.put("instId", vars.getOrDefault("instId", ""));
			params.put("templateType", vars.getOrDefault("templateType",""));
			params.put("templateAlias", jmsMessage.getTemplateAlias());
			for (JmsActor actor : receivers) {
				if(BeanUtils.isNotEmpty(actor.getClientId())){
					appPushHandler.pushIndexMsgToSingle(new ClientInfo(actor.getClientId(),actor.getClientToken()), 
							new AppPushContent(jmsMessage.getSubject(), content, params));
				}
			}
			messageLogManager.handLogByMsgHander(jmsMessage, true, "");
			return true;
		}catch(Exception ex) {
			logger.error(ex.getMessage());
			messageLogManager.handLogByMsgHander(jmsMessage, false, ex.getMessage());
			return false;
		}
	}

	@Override
	public String getTitle() {
		return "内部消息";
	}

	@Override
	public boolean getIsDefault() {
		return true;
	}

	@Override
	public boolean getSupportHtml() {
		return false;
	}
}