/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.ledger.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.cqxy.ledger.manager.MenuCustomizeFieldManager;
import com.artfess.cqxy.ledger.manager.MenuFieldTempManager;
import com.artfess.cqxy.ledger.model.MenuCustomizeField;
import com.artfess.cqxy.ledger.model.MenuFieldTemp;
import com.artfess.cqxy.ledger.vo.MenuCustomizeParamVo;
import com.artfess.cqxy.ledger.vo.MenuCustomizeVo;
import com.artfess.cqxy.processManagermant.manager.ProgressManageManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u53f0\u8d26-\u81ea\u5b9a\u4e49\u53f0\u8d26-\u83dc\u5355\u81ea\u5b9a\u4e49\u6a21\u677f\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
@RequestMapping(value={"/biz/menuFieldTemp/v1"})
public class MenuFieldTempController
extends BaseController<MenuFieldTempManager, MenuFieldTemp> {
    private static final Logger log = LoggerFactory.getLogger(MenuFieldTempController.class);
    @Resource
    private MenuCustomizeFieldManager menuCustomizeFieldManager;
    @Resource
    private ProgressManageManager progressManageManager;

    @PostMapping(value={"/delete"})
    @ApiOperation(value="S-\u6279\u91cf\u5220\u9664\u6570\u636e", httpMethod="POST")
    public CommonResult delete(@ApiParam(name="ids", value="ID\u96c6\u5408") @RequestParam(value="ids") String ids) {
        Assert.notNull((Object)ids, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List<String> idList = Arrays.asList(ids.split(","));
        ((MenuFieldTempManager)this.baseService).removeByIds(idList);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"TEMP_ID_", idList);
        this.menuCustomizeFieldManager.remove((Wrapper)queryWrapper);
        return new CommonResult(true, "\u6570\u636e\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="S-\u6279\u91cf\u4fdd\u5b58\u6216\u4fee\u6539\u6570\u636e", httpMethod="POST")
    public CommonResult insert(@RequestBody MenuFieldTemp menuFieldTemp) {
        Assert.notNull((Object)((Object)menuFieldTemp), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ((MenuFieldTempManager)this.baseService).saveOrUpdate((Object)menuFieldTemp);
        List<MenuCustomizeField> menuCustomizeFieldList = menuFieldTemp.getMenuCustomizeFieldList();
        if (null != menuCustomizeFieldList && menuCustomizeFieldList.size() > 0) {
            for (MenuCustomizeField menuCustomizeField : menuCustomizeFieldList) {
                menuCustomizeField.setTempId(menuFieldTemp.getId());
                menuCustomizeField.setProjectId(menuFieldTemp.getProjectId());
                menuCustomizeField.setProjectName(menuFieldTemp.getProjectName());
                this.menuCustomizeFieldManager.saveOrUpdate((Object)menuCustomizeField);
            }
        }
        return new CommonResult(true, "\u6570\u636e\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @PostMapping(value={"/detail/{id}"})
    @ApiOperation(value="S-\u6839\u636eID\u67e5\u8be2\u8be6\u60c5", httpMethod="POST")
    public CommonResult<MenuFieldTemp> selectOne(@ApiParam(name="id", value="\u4e3b\u952eID") @PathVariable String id) {
        Assert.notNull((Object)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        MenuFieldTemp result = (MenuFieldTemp)((Object)((MenuFieldTempManager)this.baseService).getById((Serializable)((Object)id)));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"TEMP_ID_", new Object[]{id});
        queryWrapper.orderByAsc((Object)"SN_");
        result.setMenuCustomizeFieldList(this.menuCustomizeFieldManager.list((Wrapper)queryWrapper));
        return new CommonResult(true, "\u6570\u636e\u67e5\u8be2\u6210\u529f", (Object)result);
    }

    @PostMapping(value={"/getDataById"})
    @ApiOperation(value="S-\u6839\u636e\u6a21\u677fID\u9884\u89c8\u6570\u636e", httpMethod="POST")
    public CommonResult<MenuCustomizeVo> getDataById(@RequestBody MenuCustomizeParamVo menuCustomizeParamVo) {
        Assert.notNull((Object)menuCustomizeParamVo, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        return new CommonResult(true, "\u6570\u636e\u67e5\u8be2\u6210\u529f\uff01", (Object)((MenuFieldTempManager)this.baseService).getDataByIdss(menuCustomizeParamVo));
    }

    @PostMapping(value={"/exportDataById"})
    @ApiOperation(value="S-\u6839\u636e\u6a21\u677fID\u5bfc\u51fa\u6570\u636e", httpMethod="POST")
    public CommonResult<String> exportDataById(@RequestBody MenuCustomizeParamVo menuCustomizeParamVo, HttpServletResponse response) throws IOException {
        Assert.notNull((Object)menuCustomizeParamVo, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ((MenuFieldTempManager)this.baseService).exportDataToExcel(menuCustomizeParamVo, response);
        return new CommonResult(true, "\u6570\u636e\u5bfc\u51fa\u6210\u529f\uff01");
    }
}

